/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alfheim;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import mythicbotany.ModBlockTags;
import mythicbotany.MythicBotany;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;

public class ShatteredTrunkPlacer
extends AbstractTrunkPlacer {
    public static final TrunkPlacerType<ShatteredTrunkPlacer> SHATTERED_TRUNK = new TrunkPlacerType(RecordCodecBuilder.create(instance -> ShatteredTrunkPlacer.func_236915_a_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, ShatteredTrunkPlacer::new)));

    public ShatteredTrunkPlacer(int height, int max, int min) {
        super(height, max, min);
    }

    @Nonnull
    protected TrunkPlacerType<?> func_230381_a_() {
        return SHATTERED_TRUNK;
    }

    @Nonnull
    public List<FoliagePlacer.Foliage> func_230382_a_(@Nonnull IWorldGenerationReader world, @Nonnull Random rand, int height, @Nonnull BlockPos pos, @Nonnull Set<BlockPos> positions, @Nonnull MutableBoundingBox box, @Nonnull BaseTreeFeatureConfig config) {
        ArrayList<FoliagePlacer.Foliage> list = new ArrayList<FoliagePlacer.Foliage>();
        ShatteredTrunkPlacer.func_236909_a_((IWorldGenerationReader)world, (BlockPos)pos.func_177977_b());
        for (Direction dir : Direction.values()) {
            if (dir.func_176740_k() == Direction.Axis.Y || rand.nextInt(3) != 0) continue;
            BlockPos.Mutable mpos = pos.func_177972_a(Direction.UP).func_177972_a(dir).func_239590_i_();
            for (int i = 0; i < 3; ++i) {
                mpos.func_196234_d(0, -1, 0);
                if (!this.placeLog(world, (BlockPos)mpos, rand, box, config)) break;
            }
            if (!world.func_217375_a(pos, AbstractBlock.AbstractBlockState::func_200132_m)) continue;
            ShatteredTrunkPlacer.func_236909_a_((IWorldGenerationReader)world, (BlockPos)pos.func_177977_b());
        }
        int straightTrunkSize = Math.max(3, height - 3);
        for (int i = 0; i < straightTrunkSize; ++i) {
            this.placeLog(world, pos.func_177981_b(i), rand, box, config);
        }
        int shatters = 3 + rand.nextInt(3);
        block3: for (int i = 0; i < shatters; ++i) {
            int xd = rand.nextInt(3);
            int zd = rand.nextInt(3);
            int xs = rand.nextBoolean() ? 1 : -1;
            int zs = rand.nextBoolean() ? 1 : -1;
            BlockPos.Mutable mpos = pos.func_177981_b(straightTrunkSize - 1).func_239590_i_();
            int shatterSize = 3 + rand.nextInt(4);
            for (int j = 0; j < shatterSize; ++j) {
                int xm = xd == 0 ? 0 : xd / 2 + rand.nextInt((xd + 1) / 2);
                int zm = zd == 0 ? 0 : zd / 2 + rand.nextInt((zd + 1) / 2);
                int x = 0;
                int z = 0;
                while (x < xm || z < zm) {
                    mpos.func_196234_d(x < xm ? xs : 0, rand.nextInt(3) != 0 ? 1 : 0, z < zm ? zs : 0);
                    x = Math.min(xm, x + 1);
                    z = Math.min(zm, z + 1);
                    if (!this.placeLog(world, (BlockPos)mpos, rand, box, config)) continue block3;
                    list.add(new FoliagePlacer.Foliage(mpos.func_185334_h(), 0, false));
                }
            }
        }
        return list;
    }

    private boolean placeLog(IWorldGenerationReader world, BlockPos pos, Random rand, MutableBoundingBox box, BaseTreeFeatureConfig config) {
        if (world.func_217375_a(pos, state -> state.func_196958_f() || state.func_235714_a_(ModBlockTags.ALFHEIM_LEAVES) || state.func_185904_a() == Material.field_151582_l || state.func_203425_a(Blocks.field_150355_j))) {
            ShatteredTrunkPlacer.func_236913_a_((IWorldWriter)world, (BlockPos)pos, (BlockState)config.field_227368_m_.func_225574_a_(rand, pos), (MutableBoundingBox)box);
            return true;
        }
        return false;
    }

    static {
        Registry.func_218322_a((Registry)Registry.field_239701_aw_, (ResourceLocation)new ResourceLocation(MythicBotany.getInstance().modid, "shattered_trunk"), SHATTERED_TRUNK);
    }
}

