/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alfheim.entity;

import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nonnull;
import mythicbotany.ModEntities;
import mythicbotany.alfheim.AlfheimWorldGen;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import vazkii.botania.client.fx.SparkleParticleData;

public class AlfPixie
extends CreatureEntity {
    public AlfPixie(@Nonnull World world) {
        this(ModEntities.alfPixie, world);
    }

    public AlfPixie(EntityType<AlfPixie> type, World world) {
        super(type, world);
        this.field_70728_aV = 3;
        this.field_70765_h = new MoveHelperController(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomFlyGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAroundGoal(this));
        this.field_70714_bg.func_75776_a(12, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EndermanEntity.class, 0, true, false, entity -> true));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, EndermiteEntity.class, 0, true, false, entity -> true));
        this.initExtraAI();
    }

    protected void initExtraAI() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
    }

    public int func_70641_bl() {
        return 7;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.field_70173_aa % 10 == 0 && this.field_70725_aQ == 0) {
            this.func_70691_i(1.0f);
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 4; ++i) {
                SparkleParticleData data = SparkleParticleData.sparkle((float)(0.1f + (float)Math.random() * 0.25f), (float)1.0f, (float)0.25f, (float)0.9f, (int)12);
                this.field_70170_p.func_195594_a((IParticleData)data, this.func_226277_ct_() + (Math.random() - 0.5) * 0.25, this.func_226278_cu_() + 0.5 + (Math.random() - 0.5) * 0.25, this.func_226281_cx_() + (Math.random() - 0.5) * 0.25, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean func_70617_f_() {
        return false;
    }

    public void func_213352_e(@Nonnull Vector3d vec) {
        if (this.func_70090_H()) {
            this.func_213309_a(0.02f, vec);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.8));
        } else if (this.func_180799_ab()) {
            this.func_213309_a(0.02f, vec);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
        } else {
            BlockPos ground = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() - 1.0, this.func_226281_cx_());
            float slipperiness = 0.91f;
            if (this.field_70122_E) {
                slipperiness = this.field_70170_p.func_180495_p(ground).getSlipperiness((IWorldReader)this.field_70170_p, ground, (Entity)this) * 0.91f;
            }
            float groundModifier = 6.3333335f / (slipperiness * slipperiness * slipperiness);
            slipperiness = 0.91f;
            if (this.field_70122_E) {
                slipperiness = this.field_70170_p.func_180495_p(ground).getSlipperiness((IWorldReader)this.field_70170_p, ground, (Entity)this) * 0.91f;
            }
            this.func_213309_a(this.field_70122_E ? 0.1f * groundModifier : 0.02f, vec);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a((double)slipperiness));
        }
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    public static AttributeModifierMap entityAttributes() {
        return MobEntity.func_233639_cI_().func_233815_a_(Attributes.field_233818_a_, 4.0).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233813_a_();
    }

    public static boolean canSpawnAt(EntityType<AlfPixie> type, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return world.func_180495_p(pos).isAir((IBlockReader)world, pos);
    }

    private static class RandomFlyGoal
    extends Goal {
        private final AlfPixie entity;

        public RandomFlyGoal(AlfPixie entity) {
            this.entity = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            double zd;
            double yd;
            MovementController controller = this.entity.func_70605_aq();
            if (!controller.func_75640_a()) {
                return true;
            }
            double xd = controller.func_179917_d() - this.entity.func_226277_ct_();
            double m = xd * xd + (yd = controller.func_179919_e() - this.entity.func_226278_cu_()) * yd + (zd = controller.func_179918_f() - this.entity.func_226281_cx_()) * zd;
            return m < 1.0 || m > 3600.0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            int aboveGround = 0;
            BlockPos.Mutable mpos = this.entity.func_233580_cy_().func_177977_b().func_239590_i_();
            while (mpos.func_177956_o() > 0 && AlfheimWorldGen.passReplaceableAndDreamwood(this.entity.field_70170_p.func_180495_p((BlockPos)mpos))) {
                mpos.func_189536_c(Direction.DOWN);
                if (++aboveGround < 10) continue;
            }
            Random random = this.entity.func_70681_au();
            double x = this.entity.func_226277_ct_() + (random.nextDouble() * 2.0 - 1.0) * 16.0;
            double y = this.entity.func_226278_cu_() + (random.nextDouble() * 2.0 - 1.0) * 16.0 - (double)(2 * (aboveGround - 5));
            double z = this.entity.func_226281_cx_() + (random.nextDouble() * 2.0 - 1.0) * 16.0;
            this.entity.func_70605_aq().func_75642_a(x, y, z, 0.8);
        }
    }

    private static class MoveHelperController
    extends MovementController {
        private final AlfPixie entity;
        private int cooldown;

        public MoveHelperController(AlfPixie entity) {
            super((MobEntity)entity);
            this.entity = entity;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO && this.cooldown-- <= 0) {
                this.cooldown += this.entity.func_70681_au().nextInt(5) + 2;
                Vector3d motion = new Vector3d(this.field_75646_b - this.entity.func_226277_ct_(), this.field_75647_c - this.entity.func_226278_cu_(), this.field_75644_d - this.entity.func_226281_cx_());
                double d0 = motion.func_72433_c();
                if (this.checkNoCollision(motion = motion.func_72432_b(), MathHelper.func_76143_f((double)d0))) {
                    this.entity.func_213317_d(this.entity.func_213322_ci().func_178787_e(motion.func_186678_a(0.1)));
                } else {
                    this.field_188491_h = MovementController.Action.WAIT;
                }
            }
        }

        private boolean checkNoCollision(Vector3d p_220673_1_, int p_220673_2_) {
            AxisAlignedBB aabb = this.entity.func_174813_aQ();
            for (int i = 1; i < p_220673_2_; ++i) {
                if (this.entity.field_70170_p.func_226665_a__((Entity)this.entity, aabb = aabb.func_191194_a(p_220673_1_))) continue;
                return false;
            }
            return true;
        }
    }

    private static class LookAroundGoal
    extends Goal {
        private final AlfPixie entity;

        public LookAroundGoal(AlfPixie entity) {
            this.entity = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.entity.func_70638_az() == null) {
                Vector3d motion = this.entity.func_213322_ci();
                this.entity.field_70761_aq = this.entity.field_70177_z = -((float)MathHelper.func_181159_b((double)motion.field_72450_a, (double)motion.field_72449_c)) * 57.29578f;
            } else {
                LivingEntity target = this.entity.func_70638_az();
                if (target.func_70068_e((Entity)this.entity) < 4096.0) {
                    double xd = target.func_226277_ct_() - this.entity.func_226277_ct_();
                    double zd = target.func_226281_cx_() - this.entity.func_226281_cx_();
                    this.entity.field_70761_aq = this.entity.field_70177_z = -((float)MathHelper.func_181159_b((double)xd, (double)zd)) * 57.29578f;
                }
            }
        }
    }
}

