/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alftools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import javax.annotation.Nonnull;
import mythicbotany.ModItems;
import mythicbotany.MythicBotany;
import mythicbotany.network.AlfSwordLeftClickSerializer;
import mythicbotany.pylon.PylonRepairable;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import vazkii.botania.common.entity.EntityManaBurst;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraSword;
import vazkii.botania.common.lib.ModTags;

public class AlfsteelSword
extends ItemTerraSword
implements PylonRepairable {
    public static final int MANA_PER_DURABILITY = 200;
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public AlfsteelSword(Item.Properties props) {
        super(props.func_200918_c(4600));
        MinecraftForge.EVENT_BUS.addListener(this::leftClick);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.func_200894_d(), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", 2.4, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    private void leftClick(PlayerInteractEvent.LeftClickEmpty evt) {
        if (!evt.getItemStack().func_190926_b() && evt.getItemStack().func_77973_b() == this) {
            MythicBotany.getNetwork().instance.sendToServer((Object)new AlfSwordLeftClickSerializer.AlfSwordLeftClickMessage());
        }
    }

    public int getManaPerDamage() {
        return 2 * super.getManaPerDamage();
    }

    public EntityManaBurst getBurst(PlayerEntity player, ItemStack stack) {
        EntityManaBurst burst = super.getBurst(player, stack);
        if (burst != null) {
            burst.setColor(16224512);
            burst.setMana(this.getManaPerDamage());
            burst.setStartingMana(this.getManaPerDamage());
            burst.setMinManaLoss(20);
            burst.setManaLossPerTick(2.0f);
        }
        return burst;
    }

    public float func_200894_d() {
        return 12.0f;
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> func_111205_h(@Nonnull EquipmentSlotType equipmentSlot) {
        return equipmentSlot == EquipmentSlotType.MAINHAND ? this.attributeModifiers : super.func_111205_h(equipmentSlot);
    }

    public boolean func_82789_a(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        return repair.func_77973_b() == ModItems.alfsteelIngot || !Ingredient.func_199805_a((ITag)ModTags.Items.INGOTS_TERRASTEEL).test(repair) && super.func_82789_a(toRepair, repair);
    }

    @Override
    public boolean canRepairPylon(ItemStack stack) {
        return stack.func_77952_i() > 0;
    }

    @Override
    public int getRepairManaPerTick(ItemStack stack) {
        return 500;
    }

    @Override
    public ItemStack repairOneTick(ItemStack stack) {
        stack.func_196085_b(Math.max(0, stack.func_77952_i() - 5));
        return stack;
    }
}

