/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.infuser;

import com.google.common.base.Predicates;
import io.github.noeppi_noeppi.libx.mod.registration.TileEntityBase;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.MythicBotany;
import mythicbotany.infuser.IInfuserRecipe;
import mythicbotany.infuser.InfuserRecipe;
import mythicbotany.misc.SolidifiedMana;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.common.block.ModBlocks;

public class TileManaInfuser
extends TileEntityBase
implements ISparkAttachable,
ITickableTileEntity {
    private int mana;
    private boolean active;
    @Nullable
    private transient IInfuserRecipe recipe;
    @Nullable
    private ItemStack output;
    private transient int maxMana;
    private transient int fromColor = -1;
    private transient int toColor = -1;

    public TileManaInfuser(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || !this.hasValidPlatform()) {
            return;
        }
        if (this.active && this.recipe != null && this.mana > 0) {
            MythicBotany.getNetwork().spawnInfusionParticles(this.field_145850_b, this.field_174879_c, (float)this.mana / (float)this.recipe.getManaUsage(), this.recipe.fromColor(), this.recipe.toColor());
        }
        List<ItemEntity> items = this.getItems();
        List<ItemStack> stacks = items.stream().map(ItemEntity::func_92059_d).collect(Collectors.toList());
        if (this.active && this.recipe != null && this.output != null) {
            if (this.recipe.result(stacks).func_190926_b()) {
                SolidifiedMana.dropMana(this.field_145850_b, this.field_174879_c, this.mana);
                this.active = false;
                this.recipe = null;
                this.fromColor = -1;
                this.toColor = -1;
                this.mana = 0;
                this.maxMana = 0;
                this.output = null;
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
                this.func_70296_d();
            } else if (this.mana >= this.recipe.getManaUsage()) {
                this.active = false;
                this.recipe = null;
                this.fromColor = -1;
                this.toColor = -1;
                this.mana = 0;
                this.maxMana = 0;
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
                items.forEach(Entity::func_70106_y);
                ItemEntity outItem = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, this.output);
                this.field_145850_b.func_217376_c((Entity)outItem);
                this.output = null;
                this.func_70296_d();
            } else {
                items.forEach(ie -> MythicBotany.getNetwork().setItemMagnetImmune((ItemEntity)ie));
            }
        } else {
            Pair<IInfuserRecipe, ItemStack> match = InfuserRecipe.getOutput(this.field_145850_b, stacks);
            if (match != null) {
                if (!this.active) {
                    this.active = true;
                    this.recipe = (IInfuserRecipe)match.getLeft();
                    this.mana = 0;
                } else {
                    this.recipe = (IInfuserRecipe)match.getLeft();
                    this.mana = MathHelper.func_76125_a((int)this.mana, (int)0, (int)this.recipe.getManaUsage());
                }
                this.maxMana = this.recipe.getManaUsage();
                this.fromColor = this.recipe.fromColor();
                this.toColor = this.recipe.toColor();
                this.output = (ItemStack)match.getRight();
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
                items.forEach(ie -> MythicBotany.getNetwork().setItemMagnetImmune((ItemEntity)ie));
                this.func_70296_d();
            } else if (this.active || this.recipe != null || this.output != null) {
                SolidifiedMana.dropMana(this.field_145850_b, this.field_174879_c, this.mana);
                this.active = false;
                this.recipe = null;
                this.fromColor = -1;
                this.toColor = -1;
                this.mana = 0;
                this.maxMana = 0;
                this.output = null;
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
                this.func_70296_d();
            }
        }
    }

    private List<ItemEntity> getItems() {
        return this.field_145850_b.func_217357_a(ItemEntity.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)));
    }

    private boolean hasValidPlatform() {
        BlockPos center = this.field_174879_c.func_177977_b();
        return this.field_145850_b.func_180495_p(center).func_177230_c() == ModBlocks.shimmerrock && this.field_145850_b.func_180495_p(center.func_177978_c().func_177976_e()).func_177230_c() == ModBlocks.shimmerrock && this.field_145850_b.func_180495_p(center.func_177978_c().func_177974_f()).func_177230_c() == ModBlocks.shimmerrock && this.field_145850_b.func_180495_p(center.func_177968_d().func_177976_e()).func_177230_c() == ModBlocks.shimmerrock && this.field_145850_b.func_180495_p(center.func_177968_d().func_177974_f()).func_177230_c() == ModBlocks.shimmerrock && this.field_145850_b.func_180495_p(center.func_177978_c()).func_177230_c() == Blocks.field_150340_R && this.field_145850_b.func_180495_p(center.func_177974_f()).func_177230_c() == Blocks.field_150340_R && this.field_145850_b.func_180495_p(center.func_177968_d()).func_177230_c() == Blocks.field_150340_R && this.field_145850_b.func_180495_p(center.func_177976_e()).func_177230_c() == Blocks.field_150340_R;
    }

    public boolean canAttachSpark(ItemStack itemStack) {
        return true;
    }

    public void attachSpark(ISparkEntity iSparkEntity) {
    }

    public int getAvailableSpaceForMana() {
        if (this.recipe != null) {
            return Math.max(0, this.recipe.getManaUsage() - this.mana);
        }
        return 0;
    }

    public ISparkEntity getAttachedSpark() {
        List sparks = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(this.field_174879_c.func_177984_a(), this.field_174879_c.func_177984_a().func_177982_a(1, 1, 1)), (Predicate)Predicates.instanceOf(ISparkEntity.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ISparkEntity)e;
        }
        return null;
    }

    public boolean areIncomingTranfersDone() {
        return !this.active;
    }

    public boolean isFull() {
        if (this.recipe == null) {
            return true;
        }
        return this.mana >= this.recipe.getManaUsage();
    }

    public void receiveMana(int i) {
        if (this.recipe != null) {
            this.mana = MathHelper.func_76125_a((int)(this.mana + i), (int)0, (int)this.recipe.getManaUsage());
            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
            this.func_70296_d();
        }
    }

    public boolean canReceiveManaFromBursts() {
        return this.active;
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public void func_230337_a_(@Nonnull BlockState stateIn, @Nonnull CompoundNBT compound) {
        super.func_230337_a_(stateIn, compound);
        this.mana = compound.func_74762_e("mana");
        this.output = compound.func_74764_b("output") ? ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("output")) : null;
        this.active = compound.func_74767_n("active");
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        compound.func_74768_a("mana", this.mana);
        if (this.output != null) {
            compound.func_218657_a("output", (INBT)this.output.func_77955_b(new CompoundNBT()));
        }
        compound.func_74757_a("active", this.active);
        return super.func_189515_b(compound);
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        if (this.field_145850_b.field_72995_K) {
            return super.func_189517_E_();
        }
        CompoundNBT compound = super.func_189517_E_();
        compound.func_74768_a("mana", this.mana);
        compound.func_74768_a("max", this.maxMana);
        if (this.recipe != null) {
            compound.func_74768_a("fromColor", this.fromColor);
            compound.func_74768_a("toColor", this.toColor);
        } else {
            compound.func_74768_a("fromColor", -1);
            compound.func_74768_a("toColor", -1);
        }
        return compound;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        this.mana = tag.func_74762_e("mana");
        this.maxMana = tag.func_74762_e("maxMana");
        this.fromColor = tag.func_74762_e("fromColor");
        this.toColor = tag.func_74762_e("toColor");
    }

    public int getSourceColor() {
        return this.fromColor;
    }

    public int getTargetColor() {
        return this.toColor;
    }

    public double getProgess() {
        if (this.maxMana <= 0) {
            return -1.0;
        }
        return (double)this.mana / (double)this.maxMana;
    }
}

