/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Triple;

public class LittleBoxItemRenderer
implements IIngredientRenderer<ItemStack> {
    private static final Map<Triple<Integer, Integer, Boolean>, LittleBoxItemRenderer> renders = new HashMap<Triple<Integer, Integer, Boolean>, LittleBoxItemRenderer>();
    private static IIngredientRenderer<ItemStack> parent;
    private final int x;
    private final int z;
    private final boolean consume;

    public static LittleBoxItemRenderer getRenderer(int x, int z, boolean consume) {
        Triple triple = Triple.of((Object)x, (Object)z, (Object)consume);
        if (!renders.containsKey(triple)) {
            renders.put((Triple<Integer, Integer, Boolean>)triple, new LittleBoxItemRenderer(x, z, consume));
        }
        return renders.get(triple);
    }

    public static void setParent(IIngredientRenderer<ItemStack> parent) {
        LittleBoxItemRenderer.parent = parent;
    }

    private LittleBoxItemRenderer(int x, int z, boolean consume) {
        this.x = x;
        this.z = z;
        this.consume = x == 0 && z == 0 || consume;
    }

    public void render(@Nonnull MatrixStack matrixStack, int x, int y, @Nullable ItemStack stack) {
        if (parent != null) {
            parent.render(matrixStack, x - 2, y - 2, (Object)stack);
        }
    }

    @Nonnull
    public List<ITextComponent> getTooltip(@Nonnull ItemStack stack, @Nonnull ITooltipFlag flag) {
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        if (parent != null) {
            tooltip.addAll(parent.getTooltip((Object)stack, flag));
        }
        if (this.x != 0 || this.z != 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.mythicbotany.rune_offset", new Object[]{this.x, this.z}).func_240699_a_(TextFormatting.GOLD));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.mythicbotany.rune_master").func_240699_a_(TextFormatting.GOLD));
        }
        if (this.consume) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.mythicbotany.rune_consume").func_240699_a_(TextFormatting.DARK_RED));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.mythicbotany.rune_keep").func_240699_a_(TextFormatting.DARK_GREEN));
        }
        return tooltip;
    }

    @Nonnull
    public FontRenderer getFontRenderer(@Nonnull Minecraft mc, @Nonnull ItemStack stack) {
        if (parent != null) {
            return parent.getFontRenderer(mc, (Object)stack);
        }
        return Minecraft.func_71410_x().field_71466_p;
    }
}

