/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.loot;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import mythicbotany.ModItems;
import mythicbotany.alftools.AlfsteelPick;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import vazkii.botania.common.lib.ModTags;

public class AlfsteelDisposeModifier
extends LootModifier {
    private AlfsteelDisposeModifier(ILootCondition[] conditions) {
        super(conditions);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        ItemStack tool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
        if (entity != null && tool != null && !tool.func_190926_b()) {
            AlfsteelDisposeModifier.filterDisposable(generatedLoot, entity, tool);
        }
        return generatedLoot;
    }

    public static void filterDisposable(List<ItemStack> drops, Entity entity, ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() == ModItems.alfsteelPick && AlfsteelPick.isTipped((ItemStack)stack)) {
            drops.removeIf(loot -> !loot.func_190926_b() && (ModTags.Items.DISPOSABLE.func_230235_a_((Object)loot.func_77973_b()) || ModTags.Items.SEMI_DISPOSABLE.func_230235_a_((Object)loot.func_77973_b()) && !entity.func_225608_bj_()));
        }
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AlfsteelDisposeModifier> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        public AlfsteelDisposeModifier read(ResourceLocation location, JsonObject object, ILootCondition[] conditions) {
            return new AlfsteelDisposeModifier(conditions);
        }

        public JsonObject write(AlfsteelDisposeModifier modifier) {
            return this.makeConditions(modifier.conditions);
        }
    }
}

