/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.misc;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.ModItems;
import mythicbotany.config.MythicConfig;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaTooltipDisplay;

public class SolidifiedMana
extends Item
implements IManaItem,
IManaTooltipDisplay {
    public SolidifiedMana(Item.Properties properties) {
        super(properties);
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (this.getMana(stack) > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.mythicbotany.solidified_mana").func_240699_a_(TextFormatting.GRAY));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.mythicbotany.invalid_solidified_mana").func_240699_a_(TextFormatting.RED));
        }
    }

    public int getMana(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_196082_o().func_74762_e("Mana") : 0;
    }

    public int getMaxMana(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_196082_o().func_74762_e("Mana") : 0;
    }

    public void addMana(ItemStack stack, int mana) {
        if (mana < 0) {
            stack.func_196082_o().func_74768_a("Mana", this.getMana(stack) + mana);
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (this.getMana(stack) <= 0) {
            entity.func_70106_y();
            return true;
        }
        return false;
    }

    public boolean canReceiveManaFromPool(ItemStack stack, TileEntity pool) {
        return false;
    }

    public boolean canReceiveManaFromItem(ItemStack stack, ItemStack otherStack) {
        return false;
    }

    public boolean canExportManaToPool(ItemStack stack, TileEntity pool) {
        return true;
    }

    public boolean canExportManaToItem(ItemStack stack, ItemStack otherStack) {
        return false;
    }

    public boolean isNoExport(ItemStack stack) {
        return false;
    }

    public float getManaFractionForDisplay(ItemStack stack) {
        return this.getMana(stack) > 0 ? 1.0f : 0.0f;
    }

    public static void dropMana(World world, BlockPos pos, int mana) {
        SolidifiedMana.dropMana(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.25, (double)pos.func_177952_p() + 0.5, mana);
    }

    public static void dropMana(World world, double x, double y, double z, int mana) {
        if (MythicConfig.solidified_mana) {
            int manaForStack;
            for (int manaLeft = mana; manaLeft > 0; manaLeft -= manaForStack) {
                manaForStack = Math.min(manaLeft, 200000);
                ItemStack stack = new ItemStack((IItemProvider)ModItems.solidifiedMana);
                stack.func_196082_o().func_74768_a("Mana", manaForStack);
                ItemEntity ie = new ItemEntity(world, x, y, z, stack);
                world.func_217376_c((Entity)ie);
            }
        }
    }
}

