/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.mjoellnir;

import com.google.common.collect.ImmutableSet;
import io.github.noeppi_noeppi.libx.mod.registration.Registerable;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.ModBlocks;
import mythicbotany.MythicBotany;
import mythicbotany.config.MythicConfig;
import mythicbotany.mjoellnir.EntityMjoellnir;
import mythicbotany.mjoellnir.ItemMjoellnir;
import mythicbotany.mjoellnir.RenderEntityMjoellnir;
import mythicbotany.mjoellnir.RenderMjoellnir;
import mythicbotany.mjoellnir.TileMjoellnir;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import vazkii.botania.common.item.relic.ItemThorRing;

public class BlockMjoellnir
extends Block
implements Registerable {
    public static final VoxelShape SHAPE = VoxelShapes.func_197872_a((VoxelShape)BlockMjoellnir.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)9.0, (double)13.0), (VoxelShape)BlockMjoellnir.func_208617_a((double)7.0, (double)9.0, (double)7.0, (double)9.0, (double)22.0, (double)9.0));
    private final Item item;
    private final TileEntityType<TileMjoellnir> teType;
    private final EntityType<EntityMjoellnir> entityType;

    public BlockMjoellnir(AbstractBlock.Properties properties, Item.Properties itemProperties) {
        super(properties);
        this.item = new ItemMjoellnir(this, itemProperties.func_200916_a(MythicBotany.getInstance().tab).func_234689_a_());
        this.teType = new TileEntityType(() -> new TileMjoellnir(this.getTileType()), (Set)ImmutableSet.of((Object)((Object)this)), null);
        this.entityType = EntityType.Builder.func_220322_a(EntityMjoellnir::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.6f, 0.9f).func_233606_a_(20).func_206830_a(MythicBotany.getInstance().modid + "_mjoellnir");
    }

    public TileEntityType<TileMjoellnir> getTileType() {
        return this.teType;
    }

    public EntityType<EntityMjoellnir> getEntityType() {
        return this.entityType;
    }

    public Set<Object> getAdditionalRegisters() {
        return ImmutableSet.of((Object)this.item, this.teType, this.entityType);
    }

    public void registerClient(ResourceLocation id, Consumer<Runnable> defer) {
        RenderTypeLookup.setRenderLayer((Block)this, (RenderType)RenderType.func_228643_e_());
        ClientRegistry.bindTileEntityRenderer(this.teType, RenderMjoellnir::new);
        RenderingRegistry.registerEntityRenderingHandler(this.entityType, RenderEntityMjoellnir::new);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult hit) {
        if (world.field_72995_K) return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        if (BlockMjoellnir.canHold(player)) {
            TileMjoellnir tile = BlockMjoellnir.getTile(world, pos);
            if (!BlockMjoellnir.putInInventory(player, tile.getStack().func_77946_l(), BlockMjoellnir.getHotbarSlot(player, hand))) return ActionResultType.FAIL;
            world.func_180501_a(pos, state.func_204520_s().func_206883_i(), 3);
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        } else {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.mythicbotany.mjoellnir_heavy_pick").func_240699_a_(TextFormatting.GRAY), player.func_110124_au());
        }
        return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
    }

    @Nonnull
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull ISelectionContext ctx) {
        return SHAPE;
    }

    @Nonnull
    public BlockRenderType func_149645_b(@Nonnull BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileMjoellnir createTileEntity(BlockState state, IBlockReader world) {
        return (TileMjoellnir)this.teType.func_200968_a();
    }

    private static TileMjoellnir getTile(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileMjoellnir) {
            return (TileMjoellnir)te;
        }
        throw new IllegalStateException("expected a tile entity of type TileMjoellnir, got " + te);
    }

    public static boolean placeInWorld(ItemStack stack, World world, BlockPos pos) {
        return BlockMjoellnir.placeInWorld(stack, world, pos, true);
    }

    public static boolean placeInWorld(ItemStack stack, World world, BlockPos pos, boolean dropOld) {
        BlockState state = world.func_180495_p(pos);
        float hardness = state.func_185887_b((IBlockReader)world, pos);
        if (state.func_177230_c() != ModBlocks.mjoellnir && (hardness >= 0.0f && hardness <= 60.0f || state.func_185904_a().func_76222_j())) {
            List drops = null;
            if (dropOld && world instanceof ServerWorld) {
                drops = Block.func_220070_a((BlockState)state, (ServerWorld)((ServerWorld)world), (BlockPos)pos, (TileEntity)world.func_175625_s(pos));
            }
            if (world.func_180501_a(pos, ModBlocks.mjoellnir.func_176223_P(), 11)) {
                if (drops != null) {
                    drops.forEach(drop -> {
                        ItemEntity ie = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), drop.func_77946_l());
                        world.func_217376_c((Entity)ie);
                    });
                }
                BlockMjoellnir.getTile(world, pos).setStack(stack.func_77946_l());
                if (!world.field_72995_K) {
                    world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187692_g, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static void putInWorld(ItemStack stack, World world, BlockPos pos) {
        BlockMjoellnir.putInWorld(stack, world, pos, true);
    }

    public static void putInWorld(ItemStack stack, World world, BlockPos pos, boolean dropOldOnReplace) {
        if (!BlockMjoellnir.placeInWorld(stack, world, pos, dropOldOnReplace)) {
            ItemEntity ie = new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack.func_77946_l());
            ie.func_184224_h(true);
            world.func_217376_c((Entity)ie);
        }
    }

    public static boolean canHold(PlayerEntity player) {
        return player.func_184812_l_() || player.func_175149_v() || MythicConfig.mjoellnir.requirement.test(player) || !ItemThorRing.getThorRing((PlayerEntity)player).func_190926_b() && MythicConfig.mjoellnir.requirement_thor.test(player);
    }

    public static boolean putInInventory(PlayerEntity player, ItemStack stack, int hotbarSlot) {
        int slot;
        ItemStack current;
        boolean inserted = false;
        if (hotbarSlot < 9) {
            current = player.field_71071_by.func_70301_a(hotbarSlot);
            if (current.func_190926_b()) {
                player.field_71071_by.func_70299_a(hotbarSlot, stack);
                inserted = true;
            }
        } else if (hotbarSlot == 9 && (current = (ItemStack)player.field_71071_by.field_184439_c.get(0)).func_190926_b()) {
            player.field_71071_by.field_184439_c.set(0, (Object)stack);
            inserted = true;
        }
        if (!inserted && (slot = player.field_71071_by.func_70447_i()) >= 0) {
            player.field_71071_by.func_70299_a(slot, stack);
            inserted = true;
        }
        return inserted;
    }

    public static int getHotbarSlot(PlayerEntity player, Hand hand) {
        return hand == Hand.MAIN_HAND ? player.field_71071_by.field_70461_c : 9;
    }
}

