/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.rune;

import io.github.noeppi_noeppi.libx.inventory.BaseItemStackHandler;
import io.github.noeppi_noeppi.libx.inventory.ItemStackHandlerWrapper;
import io.github.noeppi_noeppi.libx.mod.registration.TileEntityBase;
import io.github.noeppi_noeppi.libx.util.NBTX;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.ModItemTags;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileRuneHolder
extends TileEntityBase {
    private final BaseItemStackHandler inventory = new BaseItemStackHandler(1, slot -> {
        this.func_70296_d();
        this.markDispatchable();
    }, (slot, stack) -> ModItemTags.RITUAL_RUNES.func_230235_a_((Object)stack.func_77973_b()));
    private final LazyOptional<IItemHandlerModifiable> itemCap;
    @Nullable
    private BlockPos target;
    private double floatProgress;

    public TileRuneHolder(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.inventory.setDefaultSlotLimit(1);
        this.itemCap = ItemStackHandlerWrapper.createLazy(() -> this.inventory);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.itemCap : super.getCapability(cap, side);
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.inventory.deserializeNBT(nbt.func_74775_l("Inventory"));
        this.target = NBTX.getPos((CompoundNBT)nbt, (String)"TargetPos");
        this.floatProgress = nbt.func_74769_h("FloatProgress");
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        nbt.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        if (this.target != null) {
            NBTX.putPos((CompoundNBT)nbt, (String)"TargetPos", (BlockPos)this.target);
            nbt.func_74780_a("FloatProgress", this.floatProgress);
        }
        return super.func_189515_b(nbt);
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        if (!this.field_145850_b.field_72995_K) {
            nbt.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
            if (this.target != null) {
                NBTX.putPos((CompoundNBT)nbt, (String)"TargetPos", (BlockPos)this.target);
                nbt.func_74780_a("FloatProgress", this.floatProgress);
            }
        }
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT nbt) {
        super.handleUpdateTag(state, nbt);
        if (this.field_145850_b.field_72995_K) {
            this.inventory.deserializeNBT(nbt.func_74775_l("Inventory"));
            this.target = NBTX.getPos((CompoundNBT)nbt, (String)"TargetPos");
            this.floatProgress = nbt.func_74769_h("FloatProgress");
        }
    }

    @Nullable
    public BlockPos getTarget() {
        return this.target;
    }

    public double getFloatProgress() {
        return this.floatProgress;
    }

    public void setTarget(@Nullable BlockPos target, double floatProgress, boolean sync) {
        this.target = target;
        this.floatProgress = target != null ? MathHelper.func_151237_a((double)floatProgress, (double)0.0, (double)1.0) : 0.0;
        this.func_70296_d();
        if (sync) {
            this.markDispatchable();
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB aabb = super.getRenderBoundingBox();
        if (this.target != null) {
            return aabb.func_72321_a((double)(this.target.func_177958_n() - this.field_174879_c.func_177958_n()), 0.0, (double)(this.target.func_177952_p() - this.field_174879_c.func_177952_p())).func_186662_g(1.0);
        }
        return aabb;
    }
}

