/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.mrscauthd.boss_tools.ModInnet;
import net.mrscauthd.boss_tools.compat.CompatibleManager;
import net.mrscauthd.boss_tools.gui.screens.planetselection.PlanetSelectionGui;
import net.mrscauthd.boss_tools.keybind.KeyBindings;
import net.mrscauthd.boss_tools.machines.OxygenBubbleDistributorBlock;
import net.mrscauthd.boss_tools.world.oregen.OreGeneration;
import net.mrscauthd.boss_tools.world.structure.configuration.STStructures;
import net.mrscauthd.boss_tools.world.structure.configuration.STStructures2;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="boss_tools")
public class BossToolsMod {
    public static final Logger LOGGER = LogManager.getLogger(BossToolsMod.class);
    public static final String ModId = "boss_tools";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("boss_tools", "boss_tools"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID;

    public BossToolsMod() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        bus.register((Object)this);
        ModInnet.ENTITYS.register(bus);
        ModInnet.ITEMS.register(bus);
        ModInnet.BLOCKS.register(bus);
        ModInnet.TILE_ENTITYS.register(bus);
        ModInnet.SOUNDS.register(bus);
        ModInnet.SENSOR.register(bus);
        ModInnet.FLUIDS.register(bus);
        ModInnet.RECIPE_SERIALIZERS.register(bus);
        ModInnet.ROCKET_PARTS.register(bus);
        ModInnet.EFFECTS.register(bus);
        ModInnet.GUIS.register(bus);
        ModInnet.PARTICLES.register(bus);
        forgeBus.addListener(EventPriority.NORMAL, ModInnet::addDimensionalSpacing);
        forgeBus.addListener(EventPriority.HIGH, ModInnet::biomeModification);
        STStructures2.DEFERRED_REGISTRY_STRUCTURE.register(bus);
        STStructures.DEFERRED_REGISTRY_STRUCTURE.register(bus);
        forgeBus.addListener(EventPriority.HIGH, ModInnet::biomesLoading);
        forgeBus.addListener(EventPriority.HIGH, OreGeneration::biomesLoading);
        KeyBindings.registerMessages();
        BossToolsMod.addNetworkMessage(OxygenBubbleDistributorBlock.ChangeRangeMessage.class, OxygenBubbleDistributorBlock.ChangeRangeMessage::encode, OxygenBubbleDistributorBlock.ChangeRangeMessage::decode, OxygenBubbleDistributorBlock.ChangeRangeMessage::handle);
        BossToolsMod.addNetworkMessage(OxygenBubbleDistributorBlock.ChangeWorkingAreaVisibleMessage.class, OxygenBubbleDistributorBlock.ChangeWorkingAreaVisibleMessage::encode, OxygenBubbleDistributorBlock.ChangeWorkingAreaVisibleMessage::decode, OxygenBubbleDistributorBlock.ChangeWorkingAreaVisibleMessage::handle);
        BossToolsMod.addNetworkMessage(PlanetSelectionGui.NetworkMessage.class, PlanetSelectionGui.NetworkMessage::encode, PlanetSelectionGui.NetworkMessage::decode, PlanetSelectionGui.NetworkMessage::handle);
        CompatibleManager.loadAll();
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, PacketBuffer> encoder, Function<PacketBuffer, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }
}

