/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.armor;

import java.util.List;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.mrscauthd.boss_tools.armormaterial.SpaceSuitArmorMaterial;
import net.mrscauthd.boss_tools.capability.IOxygenStorage;
import net.mrscauthd.boss_tools.capability.OxygenUtil;
import net.mrscauthd.boss_tools.capability.SpaceSuitCapabilityProvider;
import net.mrscauthd.boss_tools.entity.renderer.spacesuit.SpaceSuitModel;
import net.mrscauthd.boss_tools.events.Methodes;
import net.mrscauthd.boss_tools.gauge.GaugeTextHelper;
import net.mrscauthd.boss_tools.itemgroup.BossToolsItemGroups;

public class SpaceSuit {
    public static ArmorItem OXYGEN_MASK = new ArmorItem(SpaceSuitArmorMaterial.ArmorMaterial, EquipmentSlotType.HEAD, new Item.Properties().func_200916_a(BossToolsItemGroups.tab_normal)){

        @OnlyIn(value=Dist.CLIENT)
        public BipedModel getArmorModel(LivingEntity living, ItemStack stack, EquipmentSlotType slot, BipedModel defaultModel) {
            BipedModel armorModel = new BipedModel(1.0f);
            armorModel.field_78116_c = new SpaceSuitModel.SPACE_SUIT_P1().Head;
            armorModel.field_228270_o_ = living.func_225608_bj_();
            armorModel.field_217113_d = defaultModel.field_217113_d;
            armorModel.field_217114_e = living.func_70631_g_();
            return armorModel;
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
            return "boss_tools:textures/models/armor/space_suit_head.png";
        }
    };
    public static ArmorItem SPACE_SUIT = new ArmorItem(SpaceSuitArmorMaterial.ArmorMaterial, EquipmentSlotType.CHEST, new Item.Properties().func_200916_a(BossToolsItemGroups.tab_normal)){

        @OnlyIn(value=Dist.CLIENT)
        public BipedModel getArmorModel(LivingEntity living, ItemStack stack, EquipmentSlotType slot, BipedModel defaultModel) {
            BipedModel armorModel = new BipedModel(1.0f);
            armorModel.field_78115_e = new SpaceSuitModel.SPACE_SUIT_P1().Body;
            armorModel.field_178724_i = new SpaceSuitModel.SPACE_SUIT_P1().ArmLeft;
            armorModel.field_178723_h = new SpaceSuitModel.SPACE_SUIT_P1().ArmRight;
            armorModel.field_228270_o_ = living.func_225608_bj_();
            armorModel.field_217113_d = defaultModel.field_217113_d;
            armorModel.field_217114_e = living.func_70631_g_();
            return armorModel;
        }

        public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
            return new SpaceSuitCapabilityProvider(stack, 48000);
        }

        public void func_77624_a(ItemStack itemstack, World world, List<ITextComponent> list, ITooltipFlag flag) {
            super.func_77624_a(itemstack, world, list, flag);
            IOxygenStorage oxygenStorage = OxygenUtil.getItemStackOxygenStorage(itemstack);
            list.add((ITextComponent)GaugeTextHelper.buildSpacesuitOxygenTooltip(oxygenStorage));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
            return "boss_tools:textures/models/armor/space_suit.png";
        }

        public void onArmorTick(ItemStack itemstack, World world, PlayerEntity player) {
            Methodes.extractArmorOxygenUsingTimer(itemstack, player);
        }
    };
    public static ArmorItem SPACE_PANTS = new ArmorItem(SpaceSuitArmorMaterial.ArmorMaterial, EquipmentSlotType.LEGS, new Item.Properties().func_200916_a(BossToolsItemGroups.tab_normal)){

        @OnlyIn(value=Dist.CLIENT)
        public BipedModel getArmorModel(LivingEntity living, ItemStack stack, EquipmentSlotType slot, BipedModel defaultModel) {
            BipedModel armorModel = new BipedModel(1.0f);
            armorModel.field_178722_k = new SpaceSuitModel.SPACE_SUIT_P2().LegLeft;
            armorModel.field_178721_j = new SpaceSuitModel.SPACE_SUIT_P2().LegRight;
            armorModel.field_228270_o_ = living.func_225608_bj_();
            armorModel.field_217113_d = defaultModel.field_217113_d;
            armorModel.field_217114_e = living.func_70631_g_();
            return armorModel;
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
            return "boss_tools:textures/models/armor/space_suit_legs.png";
        }
    };
    public static ArmorItem SPACE_BOOTS = new ArmorItem(SpaceSuitArmorMaterial.ArmorMaterial, EquipmentSlotType.FEET, new Item.Properties().func_200916_a(BossToolsItemGroups.tab_normal)){

        @OnlyIn(value=Dist.CLIENT)
        public BipedModel getArmorModel(LivingEntity living, ItemStack stack, EquipmentSlotType slot, BipedModel defaultModel) {
            BipedModel armorModel = new BipedModel(1.0f);
            armorModel.field_178722_k = new SpaceSuitModel.SPACE_SUIT_P1().FootLeft;
            armorModel.field_178721_j = new SpaceSuitModel.SPACE_SUIT_P1().FootRight;
            armorModel.field_228270_o_ = living.func_225608_bj_();
            armorModel.field_217113_d = defaultModel.field_217113_d;
            armorModel.field_217114_e = living.func_70631_g_();
            return armorModel;
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
            return "boss_tools:textures/models/armor/space_suit.png";
        }
    };
}

