/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.capability;

import java.util.Optional;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.mrscauthd.boss_tools.capability.IEnergyStorageHolder;

public class EnergyStorageBasic
extends EnergyStorage
implements INBTSerializable<CompoundNBT> {
    private final IEnergyStorageHolder holder;

    public EnergyStorageBasic(IEnergyStorageHolder holder, int capacity, int maxReceive, int maxExtract, int energy) {
        super(capacity, maxReceive, maxExtract, energy);
        this.holder = holder;
    }

    public EnergyStorageBasic(IEnergyStorageHolder holder, int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract);
        this.holder = holder;
    }

    public EnergyStorageBasic(IEnergyStorageHolder holder, int capacity, int maxTransfer) {
        super(capacity, maxTransfer);
        this.holder = holder;
    }

    public EnergyStorageBasic(IEnergyStorageHolder holder, int capacity) {
        super(capacity);
        this.holder = holder;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), maxReceive);
        if (!simulate && energyReceived > 0) {
            this.energy += energyReceived;
            Optional.ofNullable(this.getHolder()).ifPresent(h -> h.onEnergyChanged((IEnergyStorage)this, energyReceived));
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.getEnergyStored(), maxExtract);
        if (!simulate && energyExtracted > 0) {
            this.energy -= energyExtracted;
            Optional.ofNullable(this.getHolder()).ifPresent(h -> h.onEnergyChanged((IEnergyStorage)this, -energyExtracted));
        }
        return energyExtracted;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public boolean canExtract() {
        return this.getMaxExtract() > 0;
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public boolean canReceive() {
        return this.getMaxReceive() > 0;
    }

    public IEnergyStorageHolder getHolder() {
        return this.holder;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("energy", this.energy);
        return compound;
    }

    public void deserializeNBT(CompoundNBT compound) {
        this.energy = compound.func_74762_e("energy");
    }
}

