/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.capability;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.mrscauthd.boss_tools.capability.CapabilityOxygen;
import net.mrscauthd.boss_tools.capability.IOxygenStorage;
import net.mrscauthd.boss_tools.capability.IOxygenStorageHolder;
import net.mrscauthd.boss_tools.capability.OxygenStorage;
import net.mrscauthd.boss_tools.compat.CompatibleManager;
import net.mrscauthd.boss_tools.compat.mekanism.MekanismHelper;
import net.mrscauthd.boss_tools.compat.mekanism.OxygenStorageGasAdapter;

public class SpaceSuitCapabilityProvider
implements ICapabilityProvider,
IOxygenStorageHolder {
    public static final String KEY_OXYGEN = "Energy";
    private ItemStack itemStack;
    private IOxygenStorage oxygenStorage;

    public SpaceSuitCapabilityProvider(ItemStack itemStack, int capacity) {
        this.itemStack = itemStack;
        this.oxygenStorage = new OxygenStorage(this, capacity);
        this.readOxygen();
    }

    private void readOxygen() {
        CompoundNBT compound = this.getItemStack().func_196082_o();
        this.getOxygenStorage().setOxygenStored(compound.func_74762_e(KEY_OXYGEN));
    }

    public void writeOxygen() {
        CompoundNBT compound = this.getItemStack().func_196082_o();
        compound.func_74768_a(KEY_OXYGEN, this.getOxygenStorage().getOxygenStored());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction direction) {
        if (capability == CapabilityOxygen.OXYGEN) {
            this.readOxygen();
            return LazyOptional.of(this::getOxygenStorage).cast();
        }
        if (CompatibleManager.MEKANISM.isLoaded() && capability == MekanismHelper.getGasHandlerCapability()) {
            return LazyOptional.of(() -> new OxygenStorageGasAdapter((IOxygenStorage)this.getCapability(CapabilityOxygen.OXYGEN, direction).orElse(null), true, true)).cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public void onOxygenChanged(IOxygenStorage oxygenStorage, int oxygenDelta) {
        this.writeOxygen();
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public IOxygenStorage getOxygenStorage() {
        return this.oxygenStorage;
    }
}

