/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.compat.hwyla;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mcp.mobius.waila.api.IServerDataProvider;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.mrscauthd.boss_tools.gauge.GaugeValueHelper;
import net.mrscauthd.boss_tools.gauge.GaugeValueSerializer;
import net.mrscauthd.boss_tools.gauge.IGaugeValue;
import net.mrscauthd.boss_tools.machines.tile.AbstractMachineTileEntity;

public class ServerDataProvider
implements IServerDataProvider<TileEntity> {
    public static final ResourceLocation DATA_KEY = new ResourceLocation("boss_tools", "datakey");
    public static final ServerDataProvider INSTANCE = new ServerDataProvider();

    public static ListNBT write(List<IGaugeValue> list) {
        ListNBT nbt = new ListNBT();
        list.stream().map(GaugeValueSerializer.Serializer::serialize).forEach(arg_0 -> nbt.add(arg_0));
        return nbt;
    }

    public static List<IGaugeValue> read(ListNBT nbt) {
        ArrayList<IGaugeValue> list = new ArrayList<IGaugeValue>();
        nbt.stream().map(h -> (CompoundNBT)h).map(GaugeValueSerializer.Serializer::deserialize).forEach(list::add);
        return list;
    }

    public static ListNBT get(CompoundNBT compound) {
        return compound.func_150295_c(DATA_KEY.toString(), 10);
    }

    public static void put(CompoundNBT compound, ListNBT nbt) {
        compound.func_218657_a(DATA_KEY.toString(), (INBT)nbt);
    }

    public void appendServerData(CompoundNBT data, ServerPlayerEntity player, World world, TileEntity t) {
        if (t instanceof AbstractMachineTileEntity) {
            AbstractMachineTileEntity machineTileEntity = (AbstractMachineTileEntity)t;
            IEnergyStorage energyStorage = (IEnergyStorage)machineTileEntity.getCapability(CapabilityEnergy.ENERGY).orElse(null);
            ArrayList<IGaugeValue> list = new ArrayList<IGaugeValue>();
            if (energyStorage != null) {
                list.add(GaugeValueHelper.getEnergy(energyStorage));
            }
            list.addAll(machineTileEntity.getGaugeValues());
            machineTileEntity.getFluidHandlers().values().stream().map(machineTileEntity::getFluidHandlerGaugeValues).flatMap(Collection::stream).forEach(list::add);
            ServerDataProvider.put(data, ServerDataProvider.write(list));
        }
    }
}

