/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.fluid.Fluid;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class FluidIngredient
implements Predicate<FluidStack> {
    public static final FluidIngredient EMPTY = new Empty();
    public static final int MINAMOUNT = 1;
    public static final String KEY_AMOUNT = "amount";
    public static final String KEY_TAG = "tag";
    public static final String KEY_NAME = "name";
    public static final String KEY_NAMES = "names";
    private List<Fluid> cachedFluids;
    private int amount;

    private FluidIngredient(int amount) {
        this.amount = amount;
    }

    @Override
    public boolean test(FluidStack stack) {
        return this.getFluids().stream().anyMatch(f -> f.func_207187_a(stack.getFluid())) && stack.getAmount() >= this.amount;
    }

    public List<Fluid> getFluids() {
        if (this.cachedFluids == null) {
            this.cachedFluids = Collections.unmodifiableList(ForgeRegistries.FLUIDS.getValues().stream().filter(this::testFluid).collect(Collectors.toList()));
        }
        return this.cachedFluids;
    }

    public List<FluidStack> toStacks() {
        return this.getFluids().stream().map(f -> new FluidStack(f, this.getAmount())).collect(Collectors.toList());
    }

    public FluidStack toStack() {
        List<Fluid> fluids = this.getFluids();
        return fluids.size() == 0 ? FluidStack.EMPTY : new FluidStack(fluids.get(0), this.getAmount());
    }

    public int getAmount() {
        return this.amount;
    }

    public void write(PacketBuffer buffer) {
        List<Fluid> fluids = this.getFluids();
        int size = fluids.size();
        buffer.writeInt(size);
        for (int i = 0; i < size; ++i) {
            buffer.writeRegistryId((IForgeRegistryEntry)fluids.get(i));
        }
        buffer.writeInt(this.getAmount());
    }

    public static FluidIngredient deserialize(JsonObject json) {
        int amount = JSONUtils.func_151203_m((JsonObject)json, (String)KEY_AMOUNT);
        if (json.has(KEY_TAG)) {
            String tagName = JSONUtils.func_151200_h((JsonObject)json, (String)KEY_TAG);
            return FluidIngredient.of((ITag<Fluid>)TagCollectionManager.func_242178_a().func_241837_c().func_199910_a(new ResourceLocation(tagName)), amount);
        }
        if (json.has(KEY_NAME)) {
            JsonElement nameJson = json.get(KEY_NAME);
            if (nameJson.isJsonArray()) {
                List<Fluid> fluids = Lists.newArrayList((Iterable)nameJson.getAsJsonArray()).stream().map(j -> (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(j.getAsString()))).collect(Collectors.toList());
                return FluidIngredient.of(fluids, amount);
            }
            return FluidIngredient.of((Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(nameJson.getAsString())), amount);
        }
        return EMPTY;
    }

    public static FluidIngredient read(PacketBuffer buffer) {
        int size = buffer.readInt();
        ArrayList<Fluid> fluids = new ArrayList<Fluid>();
        for (int i = 0; i < size; ++i) {
            fluids.add((Fluid)buffer.readRegistryId());
        }
        int amount = buffer.readInt();
        return FluidIngredient.of(fluids, amount);
    }

    public static FluidIngredient of(Fluid fluid) {
        return new FluidMatch(fluid, 1);
    }

    public static FluidIngredient of(Fluid fluid, int amount) {
        return new FluidMatch(fluid, amount);
    }

    public static FluidIngredient of(FluidStack stack) {
        return new FluidMatch(stack.getFluid(), stack.getAmount());
    }

    public static FluidIngredient of(List<Fluid> fluids, int amount) {
        return new FluidMatch(fluids, amount);
    }

    public static FluidIngredient of(ITag<Fluid> tag) {
        return new TagMatch(tag, 1);
    }

    public static FluidIngredient of(ITag<Fluid> tag, int amount) {
        return new TagMatch(tag, amount);
    }

    public abstract boolean testFluid(Fluid var1);

    public static class TagMatch
    extends FluidIngredient {
        private final ITag<Fluid> tag;

        public TagMatch(ITag<Fluid> tag, int amount) {
            super(amount);
            this.tag = tag;
        }

        @Override
        public boolean testFluid(Fluid fluid) {
            return this.tag.func_230236_b_().contains(fluid);
        }

        public ITag<Fluid> getTag() {
            return this.tag;
        }
    }

    public static class FluidMatch
    extends FluidIngredient {
        private final List<Fluid> fluids;

        public FluidMatch(Fluid fluid, int amount) {
            this(Lists.newArrayList((Object[])new Fluid[]{fluid}), amount);
        }

        public FluidMatch(List<Fluid> fluids, int amount) {
            super(amount);
            this.fluids = Collections.unmodifiableList(fluids);
        }

        @Override
        public boolean testFluid(Fluid fluid) {
            return this.fluids.stream().anyMatch(f -> f.func_207187_a(fluid));
        }

        @Override
        public List<Fluid> getFluids() {
            return this.fluids;
        }
    }

    public static class Empty
    extends FluidIngredient {
        public Empty() {
            super(0);
        }

        @Override
        public boolean testFluid(Fluid fluid) {
            return false;
        }
    }
}

