/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Predicate;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.mrscauthd.boss_tools.ModInnet;
import net.mrscauthd.boss_tools.crafting.BossToolsRecipe;
import net.mrscauthd.boss_tools.crafting.BossToolsRecipeTypes;

public class GeneratingRecipe
extends BossToolsRecipe
implements Predicate<ItemStack> {
    public static final int SLOT_FUEL = 0;
    private final Ingredient ingredient;
    private final int burnTime;

    public GeneratingRecipe(ResourceLocation id, JsonObject json) {
        super(id, json);
        JsonObject inputJson = JSONUtils.func_152754_s((JsonObject)json, (String)"input");
        this.ingredient = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)inputJson, (String)"ingredient"));
        this.burnTime = JSONUtils.func_151203_m((JsonObject)json, (String)"burnTime");
    }

    public GeneratingRecipe(ResourceLocation id, PacketBuffer buffer) {
        super(id, buffer);
        this.ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        this.burnTime = buffer.readInt();
    }

    public GeneratingRecipe(ResourceLocation id, Ingredient ingredient, int burnTime) {
        super(id);
        this.ingredient = ingredient;
        this.burnTime = burnTime;
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        this.getIngredient().func_199564_a(buffer);
        buffer.writeInt(this.getBurnTime());
    }

    public boolean func_194133_a(int var1, int var2) {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModInnet.RECIPE_SERIALIZER_GENERATING.get();
    }

    public IRecipeType<?> func_222127_g() {
        return BossToolsRecipeTypes.GENERATING;
    }

    public int getFuelSlot(IInventory inventory, World world) {
        return 0;
    }

    @Override
    public boolean test(ItemStack ingredient) {
        return this.ingredient.test(ingredient);
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList list = super.func_192400_c();
        list.add((Object)this.getIngredient());
        return list;
    }

    public int getBurnTime() {
        return this.burnTime;
    }
}

