/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.mrscauthd.boss_tools.crafting.BossToolsRecipe;

public abstract class ItemStackToItemStackRecipe
extends BossToolsRecipe
implements Predicate<ItemStack> {
    private final Ingredient ingredient;
    private final ItemStack output;
    private final int cookTime;

    public ItemStackToItemStackRecipe(ResourceLocation id, JsonObject json) {
        super(id, json);
        JsonObject inputJson = JSONUtils.func_152754_s((JsonObject)json, (String)"input");
        this.ingredient = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)inputJson, (String)"ingredient"));
        this.output = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"output"), (boolean)true);
        this.cookTime = JSONUtils.func_151203_m((JsonObject)json, (String)"cookTime");
    }

    public ItemStackToItemStackRecipe(ResourceLocation id, PacketBuffer buffer) {
        super(id, buffer);
        this.ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        this.output = buffer.func_150791_c();
        this.cookTime = buffer.readInt();
    }

    public ItemStackToItemStackRecipe(ResourceLocation id, Ingredient ingredient, ItemStack output, int cookTime) {
        super(id);
        this.ingredient = ingredient;
        this.output = output.func_77946_l();
        this.cookTime = cookTime;
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.getIngredient().func_199564_a(buffer);
        buffer.func_150788_a(this.getOutput());
        buffer.writeInt(this.getCookTime());
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.ingredient.test(stack);
    }

    public boolean func_194133_a(int var1, int var2) {
        return true;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList list = super.func_192400_c();
        list.add((Object)this.getIngredient());
        return list;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getCookTime() {
        return this.cookTime;
    }
}

