/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.crafting;

import com.google.gson.JsonObject;
import java.util.function.Predicate;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.mrscauthd.boss_tools.crafting.BossToolsRecipe;
import net.mrscauthd.boss_tools.crafting.FluidIngredient;

public abstract class OxygenMakingRecipeAbstract
extends BossToolsRecipe
implements Predicate<FluidStack> {
    private final FluidIngredient input;
    private final int oxygen;

    public OxygenMakingRecipeAbstract(ResourceLocation id, JsonObject json) {
        super(id, json);
        this.input = FluidIngredient.deserialize(JSONUtils.func_152754_s((JsonObject)json, (String)"input"));
        this.oxygen = JSONUtils.func_151203_m((JsonObject)json, (String)"oxygen");
    }

    public OxygenMakingRecipeAbstract(ResourceLocation id, PacketBuffer buffer) {
        super(id, buffer);
        this.input = FluidIngredient.read(buffer);
        this.oxygen = buffer.readInt();
    }

    public OxygenMakingRecipeAbstract(ResourceLocation id, FluidIngredient ingredient, int oxygen) {
        super(id);
        this.input = ingredient;
        this.oxygen = oxygen;
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        this.getInput().write(buffer);
        buffer.writeInt(this.getOxygen());
    }

    public boolean func_194133_a(int var1, int var2) {
        return true;
    }

    @Override
    public boolean test(FluidStack fluidStack) {
        return this.input.test(fluidStack);
    }

    public FluidIngredient getInput() {
        return this.input;
    }

    public int getOxygen() {
        return this.oxygen;
    }

    public abstract IRecipeSerializer<?> func_199559_b();

    public abstract IRecipeType<?> func_222127_g();
}

