/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.mrscauthd.boss_tools.ModInnet;
import net.mrscauthd.boss_tools.crafting.BossToolsRecipe;
import net.mrscauthd.boss_tools.crafting.BossToolsRecipeTypes;
import net.mrscauthd.boss_tools.crafting.RocketPart;
import net.mrscauthd.boss_tools.inventory.RocketPartsItemHandler;

public class WorkbenchingRecipe
extends BossToolsRecipe
implements BiPredicate<RocketPartsItemHandler, Boolean> {
    private final Map<RocketPart, List<Ingredient>> parts;
    private final ItemStack output;

    public WorkbenchingRecipe(ResourceLocation id, JsonObject json) {
        super(id, json);
        JsonObject inputJson = JSONUtils.func_152754_s((JsonObject)json, (String)"input");
        JsonObject partsJson = JSONUtils.func_152754_s((JsonObject)inputJson, (String)"parts");
        HashMap map = new HashMap();
        for (Map.Entry entry : partsJson.entrySet()) {
            RocketPart part = (RocketPart)ModInnet.ROCKET_PARTS_REGISTRY.getValue(new ResourceLocation((String)entry.getKey()));
            JsonArray slotsJson = ((JsonElement)entry.getValue()).getAsJsonArray();
            List ingredients = Lists.newArrayList((Iterable)slotsJson).stream().map(js -> Ingredient.func_199802_a((JsonElement)js)).collect(Collectors.toList());
            map.put(part, Collections.unmodifiableList(ingredients));
        }
        this.parts = Collections.unmodifiableMap(map);
        this.output = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"output"), (boolean)true);
    }

    public WorkbenchingRecipe(ResourceLocation id, PacketBuffer buffer) {
        super(id, buffer);
        int partsSize = buffer.readInt();
        HashMap map = new HashMap();
        for (int i = 0; i < partsSize; ++i) {
            RocketPart part = (RocketPart)buffer.readRegistryId();
            int ingredientsSize = buffer.readInt();
            List ingredients = Arrays.stream(new Ingredient[ingredientsSize]).map(e -> Ingredient.func_199566_b((PacketBuffer)buffer)).collect(Collectors.toList());
            map.put(part, Collections.unmodifiableList(ingredients));
        }
        this.parts = Collections.unmodifiableMap(map);
        this.output = buffer.func_150791_c();
    }

    public WorkbenchingRecipe(ResourceLocation id, Map<RocketPart, List<Ingredient>> parts, ItemStack output) {
        super(id);
        HashMap<RocketPart, List<Ingredient>> map = new HashMap<RocketPart, List<Ingredient>>();
        for (Map.Entry<RocketPart, List<Ingredient>> entry : parts.entrySet()) {
            map.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
        this.parts = Collections.unmodifiableMap(map);
        this.output = output.func_77946_l();
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        buffer.writeInt(this.parts.size());
        for (Map.Entry<RocketPart, List<Ingredient>> entry : this.parts.entrySet()) {
            buffer.writeRegistryId((IForgeRegistryEntry)entry.getKey());
            List<Ingredient> ingredients = entry.getValue();
            buffer.writeInt(ingredients.size());
            ingredients.forEach(i -> i.func_199564_a(buffer));
        }
        buffer.func_150788_a(this.output);
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList ingredients = super.func_192400_c();
        ingredients.addAll((Collection)this.parts.values().stream().flatMap(l -> l.stream()).collect(Collectors.toList()));
        return ingredients;
    }

    public boolean func_194133_a(int var1, int var2) {
        return false;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public Map<RocketPart, List<Ingredient>> getParts() {
        return this.parts;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModInnet.RECIPE_SERIALIZER_WORKBENCHING.get();
    }

    public IRecipeType<?> func_222127_g() {
        return BossToolsRecipeTypes.WORKBENCHING;
    }

    public boolean test(RocketPartsItemHandler itemHandler) {
        return this.test(itemHandler, false);
    }

    @Override
    public boolean test(RocketPartsItemHandler itemHandler, Boolean ignoreAir) {
        for (Map.Entry<RocketPart, List<Ingredient>> entry : this.getParts().entrySet()) {
            List<Ingredient> ingredients;
            RocketPart part = entry.getKey();
            IItemHandlerModifiable subHandler = itemHandler.getSubHandlers().get((Object)part);
            if (subHandler == null) {
                return false;
            }
            int subHandlerSlots = subHandler.getSlots();
            if (subHandlerSlots < (ingredients = entry.getValue()).size()) {
                return false;
            }
            for (int i = 0; i < subHandlerSlots; ++i) {
                ItemStack stack = subHandler.getStackInSlot(i);
                Ingredient ingredient = ingredients.get(i);
                if (ignoreAir.booleanValue() && stack.func_190926_b() || ingredient.test(stack)) continue;
                return false;
            }
        }
        return true;
    }
}

