/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.entity;

import io.netty.buffer.Unpooled;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EntityArmorInvWrapper;
import net.minecraftforge.items.wrapper.EntityHandsInvWrapper;
import net.mrscauthd.boss_tools.gui.screens.lander.LanderGui;

public class LanderEntity
extends CreatureEntity {
    private final ItemStackHandler inventory = new ItemStackHandler(2){

        public int getSlotLimit(int slot) {
            return 64;
        }
    };
    private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, new EntityHandsInvWrapper((LivingEntity)this), new EntityArmorInvWrapper((LivingEntity)this)});

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0);
    }

    public LanderEntity(EntityType<LanderEntity> type, World world) {
        super(type, world);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_241845_aY() {
        return true;
    }

    protected void func_82167_n(Entity p_82167_1_) {
    }

    public void func_70108_f(Entity entityIn) {
    }

    @Deprecated
    public boolean func_205710_ba() {
        return true;
    }

    public boolean func_184603_cC() {
        return false;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected void func_184651_r() {
        super.func_184651_r();
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223222_a_;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent func_184601_bQ(DamageSource ds) {
        return null;
    }

    public SoundEvent func_184615_bR() {
        return null;
    }

    public double func_70042_X() {
        return super.func_70042_X() - 0.25;
    }

    public void func_174812_G() {
        this.func_213337_cE();
        this.func_70106_y();
    }

    public AxisAlignedBB func_184177_bl() {
        return new AxisAlignedBB(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()).func_72314_b(3.0, 3.0, 3.0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76355_l().equals("fall")) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_217385_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 10.0f, Explosion.Mode.BREAK);
            }
            this.func_213337_cE();
            this.func_70106_y();
            return true;
        }
        if (!source.func_76352_a() && source.func_76346_g() != null && source.func_76346_g().func_225608_bj_() && !this.func_184207_aI()) {
            this.func_213337_cE();
            this.func_70106_y();
        }
        return false;
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemstack)) continue;
            this.func_199701_a_(itemstack);
        }
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side == null) {
            return LazyOptional.of(() -> this.combined).cast();
        }
        return super.getCapability(capability, side);
    }

    public IItemHandlerModifiable getItemHandler() {
        return (IItemHandlerModifiable)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).resolve().get();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("InventoryCustom", (INBT)this.inventory.serializeNBT());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        INBT inventoryCustom = compound.func_74781_a("InventoryCustom");
        if (inventoryCustom instanceof CompoundNBT) {
            this.inventory.deserializeNBT((CompoundNBT)inventoryCustom);
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity sourceentity, Hand hand) {
        super.func_230254_b_(sourceentity, hand);
        ActionResultType retval = ActionResultType.func_233537_a_((boolean)this.field_70170_p.func_201670_d());
        if (sourceentity instanceof ServerPlayerEntity && sourceentity.func_225608_bj_()) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)sourceentity), (INamedContainerProvider)new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return new StringTextComponent("Lander");
                }

                public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
                    PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
                    packetBuffer.func_150787_b(LanderEntity.this.func_145782_y());
                    return new LanderGui.GuiContainer(id, inventory, packetBuffer);
                }
            }, buf -> buf.func_150787_b(this.func_145782_y()));
            return retval;
        }
        sourceentity.func_184220_m((Entity)this);
        return retval;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }
}

