/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.entity;

import com.google.common.collect.Sets;
import io.netty.buffer.Unpooled;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EntityArmorInvWrapper;
import net.minecraftforge.items.wrapper.EntityHandsInvWrapper;
import net.mrscauthd.boss_tools.ModInnet;
import net.mrscauthd.boss_tools.entity.RocketTier1Entity;
import net.mrscauthd.boss_tools.events.Methodes;
import net.mrscauthd.boss_tools.fluid.FluidUtil2;
import net.mrscauthd.boss_tools.gui.screens.rover.RoverGui;

public class RoverEntity
extends CreatureEntity {
    private double speed = 0.0;
    private boolean forward = false;
    public static final DataParameter<Integer> FUEL = EntityDataManager.func_187226_a(RocketTier1Entity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final int FUEL_BUCKETS = 3;
    private final ItemStackHandler inventory = new ItemStackHandler(9){

        public int getSlotLimit(int slot) {
            return 64;
        }
    };
    private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, new EntityHandsInvWrapper((LivingEntity)this), new EntityArmorInvWrapper((LivingEntity)this)});

    public RoverEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70180_af.func_187214_a(FUEL, (Object)0);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity p_82167_1_) {
    }

    public void func_70108_f(Entity entityIn) {
    }

    @Deprecated
    public boolean func_205710_ba() {
        return true;
    }

    public boolean func_184603_cC() {
        return false;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected void func_184651_r() {
        super.func_184651_r();
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223222_a_;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent func_184601_bQ(DamageSource ds) {
        return null;
    }

    public SoundEvent func_184615_bR() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    public Vector3d func_230268_c_(LivingEntity livingEntity) {
        Vector3d[] avector3d = new Vector3d[]{RoverEntity.func_233559_a_((double)this.func_213311_cf(), (double)livingEntity.func_213311_cf(), (float)livingEntity.field_70177_z), RoverEntity.func_233559_a_((double)this.func_213311_cf(), (double)livingEntity.func_213311_cf(), (float)(livingEntity.field_70177_z - 22.5f)), RoverEntity.func_233559_a_((double)this.func_213311_cf(), (double)livingEntity.func_213311_cf(), (float)(livingEntity.field_70177_z + 22.5f)), RoverEntity.func_233559_a_((double)this.func_213311_cf(), (double)livingEntity.func_213311_cf(), (float)(livingEntity.field_70177_z - 45.0f)), RoverEntity.func_233559_a_((double)this.func_213311_cf(), (double)livingEntity.func_213311_cf(), (float)(livingEntity.field_70177_z + 45.0f))};
        LinkedHashSet set = Sets.newLinkedHashSet();
        double d0 = this.func_174813_aQ().field_72337_e;
        double d1 = this.func_174813_aQ().field_72338_b - 0.5;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (Vector3d vector3d : avector3d) {
            blockpos$mutable.func_189532_c(this.func_226277_ct_() + vector3d.field_72450_a, d0, this.func_226281_cx_() + vector3d.field_72449_c);
            for (double d2 = d0; d2 > d1; d2 -= 1.0) {
                set.add(blockpos$mutable.func_185334_h());
                blockpos$mutable.func_189536_c(Direction.DOWN);
            }
        }
        for (BlockPos blockpos : set) {
            double d3;
            if (this.field_70170_p.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206960_b) || !TransportationHelper.func_234630_a_((double)(d3 = this.field_70170_p.func_242403_h(blockpos)))) continue;
            Vector3d vector3d1 = Vector3d.func_237490_a_((Vector3i)blockpos, (double)d3);
            for (Pose pose : livingEntity.func_230297_ef_()) {
                AxisAlignedBB axisalignedbb = livingEntity.func_233648_f_(pose);
                if (!TransportationHelper.func_234631_a_((ICollisionReader)this.field_70170_p, (LivingEntity)livingEntity, (AxisAlignedBB)axisalignedbb.func_191194_a(vector3d1))) continue;
                livingEntity.func_213301_b(pose);
                return vector3d1;
            }
        }
        return new Vector3d(this.func_226277_ct_(), this.func_174813_aQ().field_72337_e, this.func_226281_cx_());
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    protected void func_184225_p(Entity passenger) {
        if (passenger.func_225608_bj_() && !passenger.field_70170_p.field_72995_K && passenger instanceof ServerPlayerEntity) {
            this.func_70659_e(0.0f);
        }
        super.func_184225_p(passenger);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        ItemStack itemStack = new ItemStack((IItemProvider)ModInnet.ROVER_ITEM.get(), 1);
        itemStack.func_196082_o().func_74768_a("boss_tools:fuel", ((Integer)this.func_184212_Q().func_187225_a(FUEL)).intValue());
        return itemStack;
    }

    public double func_70042_X() {
        return super.func_70042_X() - 0.15;
    }

    public void func_174812_G() {
        this.spawnRoverItem();
        this.func_213337_cE();
        this.func_70106_y();
    }

    public AxisAlignedBB func_184177_bl() {
        return new AxisAlignedBB(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()).func_72314_b(4.5, 4.5, 4.5);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!source.func_76352_a() && source.func_76346_g() != null && source.func_76346_g().func_225608_bj_() && !this.func_184207_aI()) {
            this.spawnRoverItem();
            this.func_213337_cE();
            this.func_70106_y();
        }
        return false;
    }

    protected void spawnRoverItem() {
        if (!this.field_70170_p.func_201670_d()) {
            ItemStack itemStack = new ItemStack((IItemProvider)ModInnet.ROVER_ITEM.get(), 1);
            itemStack.func_196082_o().func_74768_a("boss_tools:fuel", ((Integer)this.func_184212_Q().func_187225_a(FUEL)).intValue());
            ItemEntity entityToSpawn = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), itemStack);
            entityToSpawn.func_174867_a(10);
            this.field_70170_p.func_217376_c((Entity)entityToSpawn);
        }
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemstack)) continue;
            this.func_199701_a_(itemstack);
        }
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side == null) {
            return LazyOptional.of(() -> this.combined).cast();
        }
        return super.getCapability(capability, side);
    }

    public IItemHandlerModifiable getItemHandler() {
        return (IItemHandlerModifiable)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).resolve().get();
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("InventoryCustom", (INBT)this.inventory.serializeNBT());
        compound.func_74768_a("fuel", ((Integer)this.field_70180_af.func_187225_a(FUEL)).intValue());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        INBT inventoryCustom = compound.func_74781_a("InventoryCustom");
        if (inventoryCustom instanceof CompoundNBT) {
            this.inventory.deserializeNBT((CompoundNBT)inventoryCustom);
        }
        this.field_70180_af.func_187227_b(FUEL, (Object)compound.func_74762_e("fuel"));
    }

    public ActionResultType func_230254_b_(PlayerEntity sourceentity, Hand hand) {
        super.func_230254_b_(sourceentity, hand);
        ActionResultType retval = ActionResultType.func_233537_a_((boolean)this.field_70170_p.func_201670_d());
        if (sourceentity instanceof ServerPlayerEntity && sourceentity.func_225608_bj_()) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)sourceentity), (INamedContainerProvider)new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return RoverEntity.this.func_145748_c_();
                }

                public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
                    PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
                    packetBuffer.func_150787_b(RoverEntity.this.func_145782_y());
                    return new RoverGui.GuiContainer(id, inventory, packetBuffer);
                }
            }, buf -> buf.func_150787_b(this.func_145782_y()));
            return retval;
        }
        sourceentity.func_184220_m((Entity)this);
        return retval;
    }

    public boolean getforward() {
        return this.forward;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (Methodes.tagCheck(FluidUtil2.findBucketFluid(this.inventory.getStackInSlot(0).func_77973_b()), ModInnet.FLUID_VEHICLE_FUEL_TAG) && (Integer)this.field_70180_af.func_187225_a(FUEL) <= 2000) {
            this.func_184212_Q().func_187227_b(FUEL, (Object)((Integer)this.func_184212_Q().func_187225_a(FUEL) + 1000));
            this.inventory.setStackInSlot(0, new ItemStack((IItemProvider)Items.field_151133_ar));
        }
        if (this.func_184188_bt().isEmpty()) {
            return;
        }
        if (!(this.func_184188_bt().get(0) instanceof PlayerEntity)) {
            return;
        }
        if (this.func_208600_a((ITag)FluidTags.field_206959_a)) {
            return;
        }
        PlayerEntity passanger = (PlayerEntity)this.func_184188_bt().get(0);
        if ((double)passanger.field_191988_bg > 0.01 && (Integer)this.func_184212_Q().func_187225_a(FUEL) != 0) {
            this.field_70180_af.func_187227_b(FUEL, (Object)((Integer)this.func_184212_Q().func_187225_a(FUEL) - 1));
            this.forward = true;
        } else if ((double)passanger.field_191988_bg < -0.01 && (Integer)this.func_184212_Q().func_187225_a(FUEL) != 0) {
            this.field_70180_af.func_187227_b(FUEL, (Object)((Integer)this.func_184212_Q().func_187225_a(FUEL) - 1));
            this.forward = false;
        }
    }

    public void func_213352_e(Vector3d dir) {
        if (!this.func_184188_bt().isEmpty() && this.func_184188_bt().get(0) instanceof PlayerEntity) {
            PlayerEntity passanger = (PlayerEntity)this.func_184188_bt().get(0);
            this.field_70747_aH = this.func_70689_ay() * 0.15f;
            this.field_70138_W = 1.0f;
            double pmovement = passanger.field_191988_bg;
            if (pmovement == 0.0 || (Integer)this.func_184212_Q().func_187225_a(FUEL) == 0 || this.func_208600_a((ITag)FluidTags.field_206959_a)) {
                pmovement = 0.0;
                this.func_70659_e(0.0f);
                if (this.speed != 0.0 && this.speed > 0.02) {
                    this.speed -= 0.02;
                }
            }
            if (this.forward && (Integer)this.func_184212_Q().func_187225_a(FUEL) != 0) {
                if ((double)this.func_70689_ay() >= 0.01 && this.speed <= 0.32) {
                    this.speed += 0.02;
                }
                if ((double)this.func_70689_ay() < 0.25) {
                    this.func_70659_e(this.func_70689_ay() + 0.02f);
                }
            }
            if (!this.forward) {
                if ((Integer)this.func_184212_Q().func_187225_a(FUEL) != 0 && !this.func_208600_a((ITag)FluidTags.field_206959_a) && (double)this.func_70689_ay() <= 0.04) {
                    this.func_70659_e(this.func_70689_ay() + 0.02f);
                }
                if ((double)this.func_70689_ay() >= 0.08) {
                    this.func_70659_e(0.0f);
                }
            }
            if (this.forward) {
                this.setWellRotationPlus(4.0f, 0.4f);
            } else {
                this.setWellRotationMinus(8.0f, 0.8f);
            }
            super.func_213352_e(new Vector3d(0.0, 0.0, pmovement));
            return;
        }
        super.func_213352_e(new Vector3d(0.0, 0.0, 0.0));
    }

    public void setWellRotationMinus(float rotation1, float rotation2) {
        double d0;
        this.field_184618_aE = this.field_70721_aZ;
        double d1 = this.func_226277_ct_() - this.field_70169_q;
        float f1 = -MathHelper.func_76133_a((double)(d1 * d1 + (d0 = this.func_226281_cx_() - this.field_70166_s) * d0)) * rotation1;
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        this.field_70721_aZ += (f1 - this.field_70721_aZ) * rotation2;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public void setWellRotationPlus(float rotation1, float rotation2) {
        double d0;
        this.field_184618_aE = this.field_70721_aZ;
        double d1 = this.func_226277_ct_() - this.field_70169_q;
        float f1 = MathHelper.func_76133_a((double)(d1 * d1 + (d0 = this.func_226281_cx_() - this.field_70166_s) * d0)) * rotation1;
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        this.field_70721_aZ += (f1 - this.field_70721_aZ) * rotation2;
        this.field_184619_aG += this.field_70721_aZ;
    }
}

