/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.entity.alien;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.INPC;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.ai.brain.task.BeginRaidTask;
import net.minecraft.entity.ai.brain.task.ExpirePOITask;
import net.minecraft.entity.ai.brain.task.FindJobTask;
import net.minecraft.entity.ai.brain.task.FindPotentialJobTask;
import net.minecraft.entity.ai.brain.task.GatherPOITask;
import net.minecraft.entity.ai.brain.task.HideFromRaidOnBellRingTask;
import net.minecraft.entity.ai.brain.task.InteractWithDoorTask;
import net.minecraft.entity.ai.brain.task.LookTask;
import net.minecraft.entity.ai.brain.task.PanicTask;
import net.minecraft.entity.ai.brain.task.PickupWantedItemTask;
import net.minecraft.entity.ai.brain.task.SwimTask;
import net.minecraft.entity.ai.brain.task.SwitchVillagerJobTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.ai.brain.task.TradeTask;
import net.minecraft.entity.ai.brain.task.VillagerTasks;
import net.minecraft.entity.ai.brain.task.WakeUpTask;
import net.minecraft.entity.ai.brain.task.WalkToTargetTask;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.merchant.IMerchant;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.mrscauthd.boss_tools.ModInnet;
import net.mrscauthd.boss_tools.entity.AlienZombieEntity;
import net.mrscauthd.boss_tools.entity.alien.AlienJobs;
import net.mrscauthd.boss_tools.entity.alien.AlienTrade;
import net.mrscauthd.boss_tools.events.Config;

public class AlienEntity
extends VillagerEntity
implements IMerchant,
INPC {
    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntity>>> core(VillagerProfession profession, float p_220638_1_) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new SwimTask(0.8f)), (Object)Pair.of((Object)0, (Object)new InteractWithDoorTask()), (Object)Pair.of((Object)0, (Object)new LookTask(45, 90)), (Object)Pair.of((Object)0, (Object)new PanicTask()), (Object)Pair.of((Object)0, (Object)new WakeUpTask()), (Object)Pair.of((Object)0, (Object)new HideFromRaidOnBellRingTask()), (Object)Pair.of((Object)0, (Object)new BeginRaidTask()), (Object)Pair.of((Object)0, (Object)new ExpirePOITask(profession.func_221149_b(), MemoryModuleType.field_220942_c)), (Object)Pair.of((Object)0, (Object)new ExpirePOITask(profession.func_221149_b(), MemoryModuleType.field_234101_d_)), (Object)Pair.of((Object)1, (Object)new WalkToTargetTask()), (Object)Pair.of((Object)2, (Object)new SwitchVillagerJobTask(profession)), (Object)Pair.of((Object)3, (Object)new TradeTask(p_220638_1_)), (Object[])new Pair[]{Pair.of((Object)5, (Object)new PickupWantedItemTask(p_220638_1_, false, 4)), Pair.of((Object)6, (Object)new GatherPOITask(profession.func_221149_b(), MemoryModuleType.field_220942_c, MemoryModuleType.field_234101_d_, true, Optional.empty())), Pair.of((Object)7, (Object)new FindPotentialJobTask(p_220638_1_)), Pair.of((Object)8, (Object)new FindJobTask(p_220638_1_)), Pair.of((Object)10, (Object)new GatherPOITask(PointOfInterestType.field_221069_q, MemoryModuleType.field_220941_b, false, Optional.of((byte)14))), Pair.of((Object)10, (Object)new GatherPOITask(PointOfInterestType.field_221070_r, MemoryModuleType.field_220943_d, true, Optional.of((byte)14)))});
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.5).func_233815_a_(Attributes.field_233819_b_, 48.0);
    }

    public AlienEntity(EntityType<? extends VillagerEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public AlienEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        AlienEntity alienentity = new AlienEntity((EntityType<? extends VillagerEntity>)((EntityType)ModInnet.ALIEN.get()), this.field_70170_p);
        alienentity.func_213386_a((IServerWorld)p_241840_1_, p_241840_1_.func_175649_E(alienentity.func_233580_cy_()), SpawnReason.BREEDING, null, null);
        return alienentity;
    }

    public void func_241841_a(ServerWorld p_241841_1_, LightningBoltEntity p_241841_2_) {
        this.func_241209_g_(this.func_223314_ad() + 1);
        if (this.func_223314_ad() == 0) {
            this.func_70015_d(8);
        }
        this.func_70097_a(DamageSource.field_180137_b, p_241841_2_.getDamage());
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        if (itemstack.func_77973_b() != ModInnet.ALIEN_SPAWN_EGG.get() && this.func_70089_S() && !this.func_213716_dX() && !this.func_70608_bn() && !p_230254_1_.func_226563_dT_()) {
            if (this.func_70631_g_()) {
                this.shakeHead();
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            boolean flag = this.func_213706_dY().isEmpty();
            if (p_230254_2_ == Hand.MAIN_HAND) {
                if (flag && !this.field_70170_p.field_72995_K) {
                    this.shakeHead();
                }
                p_230254_1_.func_195066_a(Stats.field_188074_H);
            }
            if (flag) {
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (!this.field_70170_p.field_72995_K && !this.field_213724_bz.isEmpty()) {
                this.displayMerchantGui(p_230254_1_);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    private void displayMerchantGui(PlayerEntity player) {
        this.recalculateSpecialPricesFor(player);
        this.func_70932_a_(player);
        this.func_213707_a(player, this.func_145748_c_(), this.func_213700_eh().func_221132_c());
    }

    private void recalculateSpecialPricesFor(PlayerEntity playerIn) {
        int i = this.func_223107_f(playerIn);
        if (i != 0) {
            for (MerchantOffer merchantoffer : this.func_213706_dY()) {
                merchantoffer.func_222207_a(-MathHelper.func_76141_d((float)((float)i * merchantoffer.func_222211_m())));
            }
        }
        if (playerIn.func_70644_a(Effects.field_220310_F)) {
            EffectInstance effectinstance = playerIn.func_70660_b(Effects.field_220310_F);
            int k = effectinstance.func_76458_c();
            for (MerchantOffer merchantoffer1 : this.func_213706_dY()) {
                double d0 = 0.3 + 0.0625 * (double)k;
                int j = (int)Math.floor(d0 * (double)merchantoffer1.func_222218_a().func_190916_E());
                merchantoffer1.func_222207_a(-Math.max(j, 1));
            }
        }
    }

    private void shakeHead() {
        this.func_213720_r(40);
        if (!this.field_70170_p.func_201670_d()) {
            this.func_184185_a(SoundEvents.field_187913_gm, this.func_70599_aP(), this.func_70647_i());
        }
    }

    protected Brain<?> func_213364_a(Dynamic<?> dynamicIn) {
        Brain brain = this.func_230289_cH_().func_233748_a_(dynamicIn);
        this.initBrain((Brain<VillagerEntity>)brain);
        return brain;
    }

    public void func_213770_a(ServerWorld serverWorldIn) {
        Brain brain = this.func_213375_cj();
        brain.func_218227_b(serverWorldIn, (LivingEntity)this);
        this.field_213378_br = brain.func_218185_f();
        this.initBrain((Brain<VillagerEntity>)this.func_213375_cj());
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, AlienZombieEntity.class, 15.0f, 0.5, 0.5));
    }

    private void initBrain(Brain<VillagerEntity> villagerBrain) {
        VillagerProfession villagerprofession = this.func_213700_eh().func_221130_b();
        if (this.func_70631_g_()) {
            villagerBrain.func_218203_a(Schedule.field_221385_c);
            villagerBrain.func_218208_a(Activity.field_221368_d, VillagerTasks.func_220645_a((float)0.5f));
        } else {
            villagerBrain.func_218203_a(Schedule.field_221386_d);
            villagerBrain.func_233700_a_(Activity.field_221367_c, VillagerTasks.func_220639_b((VillagerProfession)villagerprofession, (float)0.5f), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.field_220942_c, (Object)MemoryModuleStatus.VALUE_PRESENT)));
        }
        villagerBrain.func_218208_a(Activity.field_221365_a, AlienEntity.core(villagerprofession, 0.5f));
        villagerBrain.func_218208_a(Activity.field_221369_e, VillagerTasks.func_220635_c((VillagerProfession)villagerprofession, (float)0.5f));
        villagerBrain.func_218208_a(Activity.field_221366_b, VillagerTasks.func_220641_e((VillagerProfession)villagerprofession, (float)0.5f));
        villagerBrain.func_218208_a(Activity.field_221371_g, VillagerTasks.func_220636_f((VillagerProfession)villagerprofession, (float)0.5f));
        villagerBrain.func_218208_a(Activity.field_221373_i, VillagerTasks.func_220642_g((VillagerProfession)villagerprofession, (float)0.5f));
        villagerBrain.func_218208_a(Activity.field_221372_h, VillagerTasks.func_220640_h((VillagerProfession)villagerprofession, (float)0.5f));
        villagerBrain.func_218208_a(Activity.field_221374_j, VillagerTasks.func_220644_i((VillagerProfession)villagerprofession, (float)0.5f));
        villagerBrain.func_218199_a((Set)ImmutableSet.of((Object)Activity.field_221365_a));
        villagerBrain.func_218200_b(Activity.field_221366_b);
        villagerBrain.func_218202_a(Activity.field_221366_b);
        villagerBrain.func_218211_a(this.field_70170_p.func_72820_D(), this.field_70170_p.func_82737_E());
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (reason == SpawnReason.COMMAND || reason == SpawnReason.SPAWN_EGG || reason == SpawnReason.SPAWNER || reason == SpawnReason.DISPENSER) {
            this.func_213753_a(this.func_213700_eh().func_221134_a(VillagerType.func_242371_a((Optional)worldIn.func_242406_i(this.func_233580_cy_()))));
        }
        if (reason == SpawnReason.STRUCTURE) {
            this.field_234542_bL_ = true;
        }
        if (spawnDataIn == null) {
            spawnDataIn = new AgeableEntity.AgeableData(false);
        }
        int max = 13;
        int min = 1;
        for (int i = 0; i < new Random().nextInt(max + 1 - min) + min; ++i) {
            AlienJobs j = AlienJobs.values()[i];
            this.func_213753_a(this.func_213700_eh().func_221126_a(j.getAlienJobs()));
        }
        return spawnDataIn;
    }

    public void func_242367_a(ServerWorld p_242367_1_, long p_242367_2_, int p_242367_4_) {
    }

    protected void func_213712_ef() {
        AlienTrade.ITrade[] avillagertrades$itrade;
        VillagerData villagerdata = this.func_213700_eh();
        Int2ObjectMap<AlienTrade.ITrade[]> int2objectmap = AlienTrade.VILLAGER_DEFAULT_TRADES.get(villagerdata.func_221130_b());
        if (int2objectmap != null && !int2objectmap.isEmpty() && (avillagertrades$itrade = (AlienTrade.ITrade[])int2objectmap.get(villagerdata.func_221132_c())) != null) {
            MerchantOffers merchantoffers = this.func_213706_dY();
            this.addTrades(merchantoffers, avillagertrades$itrade, 6);
        }
    }

    protected void addTrades(MerchantOffers givenMerchantOffers, AlienTrade.ITrade[] newTrades, int maxNumbers) {
        HashSet set = Sets.newHashSet();
        if (newTrades.length > maxNumbers) {
            while (set.size() < maxNumbers) {
                set.add(this.field_70146_Z.nextInt(newTrades.length));
            }
        } else {
            for (int i = 0; i < newTrades.length; ++i) {
                set.add(i);
            }
        }
        for (Integer integer : set) {
            AlienTrade.ITrade villagertrades$itrade = newTrades[integer];
            MerchantOffer merchantoffer = villagertrades$itrade.getOffer((Entity)this, this.field_70146_Z);
            if (merchantoffer == null) continue;
            givenMerchantOffers.add((Object)merchantoffer);
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!Config.AlienSpawn) {
            this.func_70106_y();
        }
    }
}

