/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.entity.renderer.flagtileentity;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.mrscauthd.boss_tools.entity.renderer.flagtileentity.TileEntityHeadModel;
import net.mrscauthd.boss_tools.flag.FlagBlock;
import net.mrscauthd.boss_tools.flag.FlagTileEntity;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityHeadRenderer
extends TileEntityRenderer<FlagTileEntity> {
    private static final Map<FlagBlock.ISkullType, TileEntityHeadModel> MODELS = (Map)Util.func_200696_a((Object)Maps.newHashMap(), p_209262_0_ -> {
        TileEntityHeadModel genericheadmodel1 = new TileEntityHeadModel();
        p_209262_0_.put(FlagBlock.Types.PLAYER, genericheadmodel1);
    });
    private static final Map<FlagBlock.ISkullType, ResourceLocation> SKINS = (Map)Util.func_200696_a((Object)Maps.newHashMap(), p_209263_0_ -> p_209263_0_.put(FlagBlock.Types.PLAYER, DefaultPlayerSkin.func_177335_a()));

    public TileEntityHeadRenderer(TileEntityRendererDispatcher p_i226015_1_) {
        super(p_i226015_1_);
    }

    public void render(FlagTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (tileEntityIn.func_195044_w().func_177229_b(FlagBlock.HALF) == DoubleBlockHalf.UPPER) {
            BlockState blockstate = tileEntityIn.func_195044_w();
            boolean flag = blockstate.func_177230_c() instanceof FlagBlock;
            Direction direction = flag ? (Direction)blockstate.func_177229_b((Property)FlagBlock.FACING) : null;
            TileEntityHeadRenderer.render(direction, ((Direction)blockstate.func_177229_b((Property)FlagBlock.FACING)).func_185119_l(), ((FlagBlock)blockstate.func_177230_c()).getSkullType(), tileEntityIn.getPlayerProfile(), 0.0f, matrixStackIn, bufferIn, combinedLightIn);
        }
    }

    public static void render(@Nullable Direction directionIn, float p_228879_1_, FlagBlock.ISkullType skullType, @Nullable GameProfile gameProfileIn, float animationProgress, MatrixStack matrixStackIn, IRenderTypeBuffer buffer, int combinedLight) {
        TileEntityHeadModel genericheadmodel = MODELS.get(skullType);
        matrixStackIn.func_227860_a_();
        if (directionIn == null) {
            matrixStackIn.func_227861_a_(0.5, 0.0, 0.5);
        } else {
            float f = 0.25f;
            matrixStackIn.func_227861_a_((double)(0.5f - (float)directionIn.func_82601_c() * 0.25f), 0.25, (double)(0.5f - (float)directionIn.func_82599_e() * 0.25f));
        }
        matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
        IVertexBuilder ivertexbuilder = buffer.getBuffer(TileEntityHeadRenderer.getRenderType(skullType, gameProfileIn));
        genericheadmodel.func_225603_a_(animationProgress, p_228879_1_, 0.0f);
        genericheadmodel.func_225598_a_(matrixStackIn, ivertexbuilder, combinedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227865_b_();
    }

    private static RenderType getRenderType(FlagBlock.ISkullType skullType, @Nullable GameProfile gameProfileIn) {
        ResourceLocation resourcelocation = SKINS.get(skullType);
        if (skullType == FlagBlock.Types.PLAYER && gameProfileIn != null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            Map map = minecraft.func_152342_ad().func_152788_a(gameProfileIn);
            return map.containsKey(MinecraftProfileTexture.Type.SKIN) ? RenderType.func_228644_e_((ResourceLocation)minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN)) : RenderType.func_228640_c_((ResourceLocation)DefaultPlayerSkin.func_177334_a((UUID)PlayerEntity.func_146094_a((GameProfile)gameProfileIn)));
        }
        return RenderType.func_239267_e_((ResourceLocation)resourcelocation);
    }
}

