/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.events;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.HandSide;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.mrscauthd.boss_tools.ModInnet;
import net.mrscauthd.boss_tools.entity.LanderEntity;
import net.mrscauthd.boss_tools.events.Gravity;
import net.mrscauthd.boss_tools.events.Methodes;
import net.mrscauthd.boss_tools.events.OxygenSystem;
import net.mrscauthd.boss_tools.events.SpaceSoundSystem;
import net.mrscauthd.boss_tools.events.forgeevents.RenderHandItemEvent;
import net.mrscauthd.boss_tools.events.forgeevents.SetupLivingBipedAnimEvent;

@Mod.EventBusSubscriber(modid="boss_tools")
public class Events {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            PlayerEntity player = event.player;
            World world = player.field_70170_p;
            if (player.func_184187_bx() instanceof LanderEntity) {
                Methodes.landerTeleportOrbit(player, world);
            }
            Methodes.openPlanetGui(player);
            OxygenSystem.OxygenSystem(player);
            Gravity.Gravity((LivingEntity)player, Gravity.GravityType.PLAYER, world);
            Methodes.DropRocket(player);
            if (player.func_226278_cu_() < 1.0 && !(player.func_184187_bx() instanceof LanderEntity)) {
                Methodes.playerFalltoPlanet(world, player);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingEntityTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        Methodes.EntityOxygen(entity, world);
        Gravity.Gravity(entity, Gravity.GravityType.LIVING, world);
        Methodes.VenusRain(entity, new ResourceLocation("boss_tools", "venus"));
        Methodes.VenusFire(entity, new ResourceLocation("boss_tools", "venus"), new ResourceLocation("boss_tools", "mercury"));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void CameraPos(EntityViewRenderEvent.CameraSetup event) {
        PointOfView pointOfView;
        Entity ridding = event.getInfo().func_216773_g().func_184187_bx();
        if ((Methodes.isRocket(ridding) || ridding instanceof LanderEntity) && ((pointOfView = Minecraft.func_71410_x().field_71474_y.func_243230_g()).equals((Object)PointOfView.THIRD_PERSON_FRONT) || pointOfView.equals((Object)PointOfView.THIRD_PERSON_BACK))) {
            event.getInfo().func_216782_a(-event.getInfo().func_216779_a(9.0), 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void render(RenderPlayerEvent event) {
        if (event.getEntity().func_184187_bx() instanceof LanderEntity) {
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void setupPlayerAngles(SetupLivingBipedAnimEvent.Post event) {
        if (event.getLivingEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getLivingEntity();
            BipedModel model = event.getModel();
            if (Methodes.isRocket(player.func_184187_bx())) {
                model.field_178721_j.field_78795_f = (float)Math.toRadians(0.0);
                model.field_178722_k.field_78795_f = (float)Math.toRadians(0.0);
                model.field_178722_k.field_78796_g = (float)Math.toRadians(3.0);
                model.field_178721_j.field_78796_g = (float)Math.toRadians(3.0);
                model.field_178724_i.field_78795_f = -0.07f;
                model.field_178723_h.field_78795_f = -0.07f;
            }
            if (!Methodes.isRocket(player.func_184187_bx())) {
                Item item1 = player.func_184614_ca().func_77973_b();
                Item item2 = player.func_184592_cb().func_77973_b();
                if (item1 == ModInnet.TIER_1_ROCKET_ITEM.get() || item1 == ModInnet.TIER_2_ROCKET_ITEM.get() || item1 == ModInnet.TIER_3_ROCKET_ITEM.get() || item1 == ModInnet.ROVER_ITEM.get() || item2 == ModInnet.TIER_1_ROCKET_ITEM.get() || item2 == ModInnet.TIER_2_ROCKET_ITEM.get() || item2 == ModInnet.TIER_3_ROCKET_ITEM.get() || item2 == ModInnet.ROVER_ITEM.get()) {
                    model.field_178723_h.field_78795_f = 10.0f;
                    model.field_178724_i.field_78795_f = 10.0f;
                    model.field_178724_i.field_78808_h = 0.0f;
                    model.field_178723_h.field_78808_h = 0.0f;
                    model.field_178723_h.field_78796_g = 0.0f;
                    model.field_178724_i.field_78796_g = 0.0f;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void ItemRender(RenderHandItemEvent.Pre event) {
        if (event.getLivingEntity() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getLivingEntity();
            if (Methodes.isRocket(player.func_184187_bx())) {
                event.setCanceled(true);
            }
            Item item1 = player.func_184614_ca().func_77973_b();
            Item item2 = player.func_184592_cb().func_77973_b();
            if ((item1 == ModInnet.TIER_1_ROCKET_ITEM.get() || item1 == ModInnet.TIER_2_ROCKET_ITEM.get() || item1 == ModInnet.TIER_3_ROCKET_ITEM.get() || item1 == ModInnet.ROVER_ITEM.get()) && event.getHandSide() == HandSide.LEFT) {
                event.setCanceled(true);
            }
            if ((item2 == ModInnet.TIER_1_ROCKET_ITEM.get() || item2 == ModInnet.TIER_2_ROCKET_ITEM.get() || item2 == ModInnet.TIER_3_ROCKET_ITEM.get() || item2 == ModInnet.ROVER_ITEM.get()) && event.getHandSide() == HandSide.RIGHT) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            World world = event.world;
            RegistryKey world2 = world.func_234923_W_();
            if (world2 == RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("boss_tools", "moon")) || world2 == RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("boss_tools", "moon_orbit")) || world2 == RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("boss_tools", "mars")) || world2 == RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("boss_tools", "mars_orbit")) || world2 == RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("boss_tools", "mercury")) || world2 == RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("boss_tools", "mercury_orbit")) || world2 == RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("boss_tools", "venus_orbit")) || world2 == RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("boss_tools", "overworld_orbit"))) {
                world.field_73017_q = 0.0f;
                world.field_73004_o = 0.0f;
            }
            if (world2 == RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("boss_tools", "venus"))) {
                world.field_73017_q = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingAttackEvent event) {
        PlayerEntity entity;
        if (event != null && event.getEntity() instanceof PlayerEntity && Methodes.nethriteSpaceSuitCheck((LivingEntity)(entity = (PlayerEntity)event.getEntity())) && event.getSource().func_76347_k()) {
            entity.func_241209_g_(0);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void FishingBobberTick(ProjectileImpactEvent.FishingBobber event) {
        Entity entity;
        if (event.getRayTraceResult().func_216346_c() == RayTraceResult.Type.ENTITY && Methodes.AllVehiclesOr(entity = ((EntityRayTraceResult)event.getRayTraceResult()).func_216348_a())) {
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void SpaceSounds(PlaySoundEvent event) {
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.field_70170_p != null && Minecraft.func_71410_x().field_71462_r == null && Methodes.isSpaceWorld(Minecraft.func_71410_x().field_71439_g.field_70170_p)) {
            event.setResultSound((ISound)new SpaceSoundSystem(event.getSound()));
        }
    }
}

