/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.events;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.mrscauthd.boss_tools.events.Methodes;
import net.mrscauthd.boss_tools.events.forgeevents.LivingGravityEvent;

public class Gravity {
    public static void Gravity(LivingEntity entity, GravityType type, World world) {
        double moon = 0.03;
        double mars = 0.04;
        double mercury = 0.03;
        double venus = 0.04;
        double orbit = 0.02;
        if (Methodes.isWorld(world, new ResourceLocation("boss_tools", "moon"))) {
            Gravity.gravityMath(type, entity, moon, -2.5f);
        }
        if (Methodes.isWorld(world, new ResourceLocation("boss_tools", "mars"))) {
            Gravity.gravityMath(type, entity, mars, -2.0f);
        }
        if (Methodes.isWorld(world, new ResourceLocation("boss_tools", "mercury"))) {
            Gravity.gravityMath(type, entity, mercury, -2.5f);
        }
        if (Methodes.isWorld(world, new ResourceLocation("boss_tools", "venus"))) {
            Gravity.gravityMath(type, entity, venus, -2.0f);
        }
        if (Methodes.isOrbitWorld(world)) {
            Gravity.gravityMath(type, entity, orbit, -2.5f);
        }
    }

    public static boolean playerGravityCheck(PlayerEntity player) {
        return !player.field_71075_bZ.field_75100_b && !player.func_184613_cA() && !player.func_70090_H() && !player.func_180799_ab() && !player.func_189652_ae();
    }

    public static boolean livingGravityCheck(LivingEntity entity) {
        return !entity.func_184613_cA() && !entity.func_70090_H() && !entity.func_180799_ab() && !entity.func_189652_ae() && !(entity instanceof PlayerEntity) && !Methodes.AllVehiclesOr((Entity)entity);
    }

    public static void gravityMath(GravityType type, LivingEntity entity, double gravity, float fallDistance) {
        if (!Gravity.checkType(type, entity)) {
            return;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new LivingGravityEvent(entity))) {
            return;
        }
        entity.func_213293_j(entity.func_213322_ci().func_82615_a(), entity.func_213322_ci().func_82617_b() / 0.98 + 0.08 - gravity, entity.func_213322_ci().func_82616_c());
        Gravity.fallDamage(entity, fallDistance);
    }

    public static boolean checkType(GravityType type, LivingEntity entity) {
        if (type == GravityType.PLAYER && Gravity.playerGravityCheck((PlayerEntity)entity)) {
            return true;
        }
        return type == GravityType.LIVING && Gravity.livingGravityCheck(entity);
    }

    public static void fallDamage(LivingEntity entity, float fallDistance) {
        if (entity.func_213322_ci().func_82617_b() < -0.1) {
            entity.field_70143_R = (float)entity.func_213322_ci().func_82617_b() * fallDistance;
        }
    }

    public static enum GravityType {
        PLAYER,
        LIVING;

    }
}

