/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.events;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.mrscauthd.boss_tools.ModInnet;
import net.mrscauthd.boss_tools.capability.IOxygenStorage;
import net.mrscauthd.boss_tools.capability.OxygenUtil;
import net.mrscauthd.boss_tools.entity.LanderEntity;
import net.mrscauthd.boss_tools.entity.RocketTier1Entity;
import net.mrscauthd.boss_tools.entity.RocketTier2Entity;
import net.mrscauthd.boss_tools.entity.RocketTier3Entity;
import net.mrscauthd.boss_tools.entity.RoverEntity;
import net.mrscauthd.boss_tools.events.Config;
import net.mrscauthd.boss_tools.events.forgeevents.LivingSetFireInHotPlanetEvent;
import net.mrscauthd.boss_tools.events.forgeevents.LivingSetVenusRainEvent;
import net.mrscauthd.boss_tools.gui.screens.planetselection.PlanetSelectionGui;

public class Methodes {
    public static void worldTeleport(PlayerEntity entity, ResourceLocation Planet, double high) {
        if (!entity.field_70170_p.field_72995_K) {
            RegistryKey destinationType = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)Planet);
            ServerWorld nextWorld = entity.func_184102_h().func_71218_a(destinationType);
            if (nextWorld != null) {
                ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241768_e_, 0.0f));
                ((ServerPlayerEntity)entity).func_200619_a(nextWorld, entity.func_226277_ct_(), high, entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
                ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(entity.field_71075_bZ));
                for (EffectInstance effectinstance : entity.func_70651_bq()) {
                    ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(entity.func_145782_y(), effectinstance));
                }
            }
        }
    }

    public static boolean nethriteSpaceSuitCheck(LivingEntity entity) {
        Boolean item3 = Methodes.checkArmor(entity, 3, (Item)ModInnet.NETHERITE_OXYGEN_MASK.get());
        Boolean item2 = Methodes.checkArmor(entity, 2, (Item)ModInnet.NETHERITE_SPACE_SUIT.get());
        Boolean item1 = Methodes.checkArmor(entity, 1, (Item)ModInnet.NETHERITE_SPACE_PANTS.get());
        Boolean item0 = Methodes.checkArmor(entity, 0, (Item)ModInnet.NETHERITE_SPACE_BOOTS.get());
        return item0 != false && item1 != false && item2 != false && item3 != false;
    }

    public static boolean spaceSuitCheck(LivingEntity entity) {
        Boolean item3 = Methodes.checkArmor(entity, 3, (Item)ModInnet.OXYGEN_MASK.get());
        Boolean item2 = Methodes.checkArmor(entity, 2, (Item)ModInnet.SPACE_SUIT.get());
        Boolean item1 = Methodes.checkArmor(entity, 1, (Item)ModInnet.SPACE_PANTS.get());
        Boolean item0 = Methodes.checkArmor(entity, 0, (Item)ModInnet.SPACE_BOOTS.get());
        return item0 != false && item1 != false && item2 != false && item3 != false;
    }

    public static boolean spaceSuitCheckBoth(LivingEntity entity) {
        Boolean item3 = Methodes.checkArmor(entity, 3, (Item)ModInnet.OXYGEN_MASK.get());
        Boolean item2 = Methodes.checkArmor(entity, 2, (Item)ModInnet.SPACE_SUIT.get());
        Boolean item1 = Methodes.checkArmor(entity, 1, (Item)ModInnet.SPACE_PANTS.get());
        Boolean item0 = Methodes.checkArmor(entity, 0, (Item)ModInnet.SPACE_BOOTS.get());
        Boolean item3_2 = Methodes.checkArmor(entity, 3, (Item)ModInnet.NETHERITE_OXYGEN_MASK.get());
        Boolean item2_2 = Methodes.checkArmor(entity, 2, (Item)ModInnet.NETHERITE_SPACE_SUIT.get());
        Boolean item1_2 = Methodes.checkArmor(entity, 1, (Item)ModInnet.NETHERITE_SPACE_PANTS.get());
        Boolean item0_2 = Methodes.checkArmor(entity, 0, (Item)ModInnet.NETHERITE_SPACE_BOOTS.get());
        Boolean check3 = false;
        Boolean check2 = false;
        Boolean check1 = false;
        Boolean check0 = false;
        if (item3.booleanValue() || item3_2.booleanValue()) {
            check3 = true;
        }
        if (item2.booleanValue() || item2_2.booleanValue()) {
            check2 = true;
        }
        if (item1.booleanValue() || item1_2.booleanValue()) {
            check1 = true;
        }
        if (item0.booleanValue() || item0_2.booleanValue()) {
            check0 = true;
        }
        return check0 != false && check1 != false && check2 != false && check3 != false;
    }

    public static boolean checkArmor(LivingEntity entity, int number, Item item) {
        return entity.func_184582_a(EquipmentSlotType.func_220318_a((EquipmentSlotType.Group)EquipmentSlotType.Group.ARMOR, (int)number)).func_77973_b() == item;
    }

    public static boolean isSpaceWorld(World world) {
        return Methodes.isWorld(world, new ResourceLocation("boss_tools", "moon")) || Methodes.isWorld(world, new ResourceLocation("boss_tools", "moon_orbit")) || Methodes.isWorld(world, new ResourceLocation("boss_tools", "mars")) || Methodes.isWorld(world, new ResourceLocation("boss_tools", "mars_orbit")) || Methodes.isWorld(world, new ResourceLocation("boss_tools", "mercury")) || Methodes.isWorld(world, new ResourceLocation("boss_tools", "mercury_orbit")) || Methodes.isWorld(world, new ResourceLocation("boss_tools", "venus")) || Methodes.isWorld(world, new ResourceLocation("boss_tools", "venus_orbit")) || Methodes.isWorld(world, new ResourceLocation("boss_tools", "overworld_orbit"));
    }

    public static boolean isOrbitWorld(World world) {
        return Methodes.isWorld(world, new ResourceLocation("boss_tools", "overworld_orbit")) || Methodes.isWorld(world, new ResourceLocation("boss_tools", "moon_orbit")) || Methodes.isWorld(world, new ResourceLocation("boss_tools", "mars_orbit")) || Methodes.isWorld(world, new ResourceLocation("boss_tools", "mercury_orbit")) || Methodes.isWorld(world, new ResourceLocation("boss_tools", "venus_orbit"));
    }

    public static boolean isWorld(World world, ResourceLocation loc) {
        RegistryKey world2 = world.func_234923_W_();
        return world2 == RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)loc);
    }

    public static void OxygenDamage(LivingEntity entity) {
        entity.func_70097_a(ModInnet.DAMAGE_SOURCE_OXYGEN, 1.0f);
    }

    public static boolean isRocket(Entity entity) {
        return entity instanceof RocketTier1Entity || entity instanceof RocketTier2Entity || entity instanceof RocketTier3Entity;
    }

    public static boolean AllVehiclesOr(Entity entity) {
        return entity instanceof RocketTier1Entity || entity instanceof RocketTier2Entity || entity instanceof RocketTier3Entity || entity instanceof LanderEntity || entity instanceof RoverEntity;
    }

    public static void RocketSounds(Entity entity, World world) {
        world.func_217384_a(null, entity, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("boss_tools", "rocket_fly")), SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    public static void DropRocket(PlayerEntity player) {
        Item item1 = player.func_184614_ca().func_77973_b();
        Item item2 = player.func_184592_cb().func_77973_b();
        ArrayList<IForgeRegistryEntry> items = new ArrayList<IForgeRegistryEntry>();
        items.add(ModInnet.TIER_1_ROCKET_ITEM.get());
        items.add(ModInnet.TIER_2_ROCKET_ITEM.get());
        items.add(ModInnet.TIER_3_ROCKET_ITEM.get());
        items.add(ModInnet.ROVER_ITEM.get());
        if (items.contains(item1) && items.contains(item2)) {
            ItemEntity spawn = new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), new ItemStack((IItemProvider)item2));
            spawn.func_174867_a(0);
            player.field_70170_p.func_217376_c((Entity)spawn);
            player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(capability -> capability.extractItem(40, 1, false));
        }
    }

    public static void VenusFire(LivingEntity entity, ResourceLocation planet1, ResourceLocation planet2) {
        RegistryKey key = entity.field_70170_p.func_234923_W_();
        if (!(key != RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)planet1) && key != RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)planet2) || Methodes.nethriteSpaceSuitCheck(entity) || MinecraftForge.EVENT_BUS.post((Event)new LivingSetFireInHotPlanetEvent(entity)) || Methodes.tagCheck((Entity)entity, "boss_tools:entities/venus_fire"))) {
            entity.func_70015_d(10);
        }
    }

    public static void VenusRain(LivingEntity entity, ResourceLocation planet) {
        if (entity.field_70170_p.func_234923_W_() == RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)planet) && entity.field_70170_p.func_72912_H().func_76059_o() && (double)entity.field_70170_p.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (int)Math.floor(entity.func_226277_ct_()), (int)Math.floor(entity.func_226281_cx_())) <= Math.floor(entity.func_226278_cu_()) + 1.0 && !MinecraftForge.EVENT_BUS.post((Event)new LivingSetVenusRainEvent(entity)) && !Methodes.tagCheck((Entity)entity, "boss_tools:entities/venus_rain")) {
            entity.func_70097_a(ModInnet.DAMAGE_SOURCE_ACID_RAIN, 1.0f);
        }
    }

    public static void EntityOxygen(LivingEntity entity, World world) {
        if (Config.EntityOxygenSystem && Methodes.isSpaceWorld(world) && Methodes.tagCheck((Entity)entity, "boss_tools:entities/oxygen") && !entity.func_70644_a((Effect)ModInnet.OXYGEN_EFFECT.get())) {
            entity.getPersistentData().func_74780_a("boss_tools:oxygen_tick", entity.getPersistentData().func_74769_h("boss_tools:oxygen_tick") + 1.0);
            if (entity.getPersistentData().func_74769_h("boss_tools:oxygen_tick") > 15.0) {
                if (!world.field_72995_K) {
                    Methodes.OxygenDamage(entity);
                }
                entity.getPersistentData().func_74780_a("boss_tools:oxygen_tick", 0.0);
            }
        }
    }

    public static void vehicleRotation(LivingEntity vehicle, float roation) {
        vehicle.field_70177_z += roation;
        vehicle.func_181013_g(vehicle.field_70177_z);
        vehicle.field_70126_B = vehicle.field_70177_z;
        vehicle.field_70760_ar = vehicle.field_70177_z;
    }

    public static void noFuelMessage(PlayerEntity player) {
        if (!player.field_70170_p.func_201670_d()) {
            player.func_146105_b((ITextComponent)new StringTextComponent("\u00a7cNO FUEL! \u00a77Fill the Rocket with \u00a7cFuel\u00a77. (\u00a76Sneak and Right Click\u00a77)"), false);
        }
    }

    public static boolean tagCheck(Entity entity, String tag) {
        return EntityTypeTags.func_219762_a().func_241834_b(new ResourceLocation(tag.toLowerCase(Locale.ENGLISH))).func_230235_a_((Object)entity.func_200600_R());
    }

    public static boolean tagCheck(Fluid fluid, ResourceLocation tag) {
        return FluidTags.func_226157_a_().func_241834_b(tag).func_230235_a_((Object)fluid);
    }

    public static void landerTeleport(PlayerEntity player, ResourceLocation newPlanet) {
        LanderEntity lander = (LanderEntity)player.func_184187_bx();
        if (player.func_226278_cu_() < 1.0) {
            ItemStack slot_0 = lander.getInventory().getStackInSlot(0);
            ItemStack slot_1 = lander.getInventory().getStackInSlot(1);
            lander.func_70106_y();
            Methodes.worldTeleport(player, newPlanet, 700.0);
            World newWorld = player.field_70170_p;
            if (!player.field_70170_p.func_201670_d()) {
                LanderEntity entityToSpawn = new LanderEntity((EntityType<LanderEntity>)((EntityType)ModInnet.LANDER.get()), newWorld);
                entityToSpawn.func_70012_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0f, 0.0f);
                entityToSpawn.func_213386_a((IServerWorld)((ServerWorld)newWorld), newWorld.func_175649_E(entityToSpawn.func_233580_cy_()), SpawnReason.MOB_SUMMONED, null, null);
                newWorld.func_217376_c((Entity)entityToSpawn);
                entityToSpawn.getInventory().setStackInSlot(0, slot_0);
                entityToSpawn.getInventory().setStackInSlot(1, slot_1);
                player.func_184220_m((Entity)entityToSpawn);
            }
        }
    }

    public static void rocketTeleport(PlayerEntity player, ResourceLocation planet, ItemStack rocketItem, Boolean SpaceStation) {
        RegistryKey dim = player.field_70170_p.func_234923_W_();
        if (dim != RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)planet)) {
            Methodes.worldTeleport(player, planet, 700.0);
        } else {
            player.func_70634_a(player.func_226277_ct_(), 700.0, player.func_226281_cx_());
            if (player instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)player).field_71135_a.func_147364_a(player.func_226277_ct_(), 700.0, player.func_226281_cx_(), player.field_70177_z, player.field_70125_A);
            }
        }
        World world = player.field_70170_p;
        if (!world.func_201670_d()) {
            LanderEntity landerSpawn = new LanderEntity((EntityType<LanderEntity>)((EntityType)ModInnet.LANDER.get()), world);
            landerSpawn.func_70012_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0f, 0.0f);
            landerSpawn.func_213386_a((IServerWorld)((ServerWorld)world), world.func_175649_E(landerSpawn.func_233580_cy_()), SpawnReason.MOB_SUMMONED, null, null);
            world.func_217376_c((Entity)landerSpawn);
            String itemId = player.getPersistentData().func_74779_i("boss_tools:slot0");
            landerSpawn.getInventory().setStackInSlot(0, new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId)), 1));
            landerSpawn.getInventory().setStackInSlot(1, rocketItem);
            if (SpaceStation.booleanValue()) {
                Methodes.createSpaceStation(player, (ServerWorld)world);
            }
            Methodes.cleanUpPlayerNBT(player);
            player.func_184220_m((Entity)landerSpawn);
        }
    }

    public static void createSpaceStation(PlayerEntity player, ServerWorld serverWorld) {
        BlockPos pos = new BlockPos(player.func_226277_ct_() - 15.5, 100.0, player.func_226281_cx_() - 15.5);
        serverWorld.func_184163_y().func_200219_b(new ResourceLocation("boss_tools", "space_station")).func_237144_a_((IServerWorld)serverWorld, pos, new PlacementSettings(), serverWorld.field_73012_v);
    }

    public static void cleanUpPlayerNBT(PlayerEntity player) {
        player.getPersistentData().func_74757_a("boss_tools:planet_selection_gui_open", false);
        player.getPersistentData().func_74778_a("boss_tools:rocket_type", "");
        player.getPersistentData().func_74778_a("boss_tools:slot0", "");
    }

    public static void openPlanetGui(PlayerEntity player) {
        if (!(player.field_71070_bA instanceof PlanetSelectionGui.GuiContainer) && player.getPersistentData().func_74767_n("boss_tools:planet_selection_gui_open") && player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return new StringTextComponent("Planet Selection");
                }

                public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
                    PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
                    packetBuffer.func_180714_a(player.getPersistentData().func_74779_i("boss_tools:rocket_type"));
                    return new PlanetSelectionGui.GuiContainer(id, inventory, packetBuffer);
                }
            }, buf -> buf.func_180714_a(player.getPersistentData().func_74779_i("boss_tools:rocket_type")));
        }
    }

    public static void teleportButton(PlayerEntity player, ResourceLocation planet, Boolean SpaceStation) {
        ItemStack itemStack = new ItemStack((IItemProvider)Items.field_190931_a, 1);
        if (player.getPersistentData().func_74779_i("boss_tools:rocket_type").equals("entity.boss_tools.rocket_t1")) {
            itemStack = new ItemStack((IItemProvider)ModInnet.TIER_1_ROCKET_ITEM.get(), 1);
        }
        if (player.getPersistentData().func_74779_i("boss_tools:rocket_type").equals("entity.boss_tools.rocket_t2")) {
            itemStack = new ItemStack((IItemProvider)ModInnet.TIER_2_ROCKET_ITEM.get(), 1);
        }
        if (player.getPersistentData().func_74779_i("boss_tools:rocket_type").equals("entity.boss_tools.rocket_t3")) {
            itemStack = new ItemStack((IItemProvider)ModInnet.TIER_3_ROCKET_ITEM.get(), 1);
        }
        Methodes.rocketTeleport(player, planet, itemStack, SpaceStation);
    }

    public static void landerTeleportOrbit(PlayerEntity player, World world) {
        if (Methodes.isWorld(world, new ResourceLocation("boss_tools", "overworld_orbit"))) {
            Methodes.landerTeleport(player, new ResourceLocation("minecraft:overworld"));
        }
        if (Methodes.isWorld(world, new ResourceLocation("boss_tools", "moon_orbit"))) {
            Methodes.landerTeleport(player, new ResourceLocation("boss_tools", "moon"));
        }
        if (Methodes.isWorld(world, new ResourceLocation("boss_tools", "mars_orbit"))) {
            Methodes.landerTeleport(player, new ResourceLocation("boss_tools", "mars"));
        }
        if (Methodes.isWorld(world, new ResourceLocation("boss_tools", "mercury_orbit"))) {
            Methodes.landerTeleport(player, new ResourceLocation("boss_tools", "mercury"));
        }
        if (Methodes.isWorld(world, new ResourceLocation("boss_tools", "venus_orbit"))) {
            Methodes.landerTeleport(player, new ResourceLocation("boss_tools", "venus"));
        }
    }

    public static void playerFalltoPlanet(World world, PlayerEntity player) {
        ResourceLocation planet;
        RegistryKey world2 = world.func_234923_W_();
        if (world2 == RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("boss_tools", "overworld_orbit"))) {
            planet = new ResourceLocation("overworld");
            Methodes.worldTeleport(player, planet, 450.0);
        }
        if (world2 == RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("boss_tools", "moon_orbit"))) {
            planet = new ResourceLocation("boss_tools", "moon");
            Methodes.worldTeleport(player, planet, 450.0);
        }
        if (world2 == RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("boss_tools", "mars_orbit"))) {
            planet = new ResourceLocation("boss_tools", "mars");
            Methodes.worldTeleport(player, planet, 450.0);
        }
        if (world2 == RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("boss_tools", "mercury_orbit"))) {
            planet = new ResourceLocation("boss_tools", "mercury");
            Methodes.worldTeleport(player, planet, 450.0);
        }
        if (world2 == RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation("boss_tools", "venus_orbit"))) {
            planet = new ResourceLocation("boss_tools", "venus");
            Methodes.worldTeleport(player, planet, 450.0);
        }
    }

    public static void extractArmorOxygenUsingTimer(ItemStack itemstack, PlayerEntity player) {
        if (!player.field_71075_bZ.field_75098_d && !player.func_175149_v() && Methodes.spaceSuitCheckBoth((LivingEntity)player) && Config.PlayerOxygenSystem) {
            IOxygenStorage oxygenStorage = OxygenUtil.getItemStackOxygenStorage(itemstack);
            CompoundNBT persistentData = player.getPersistentData();
            String key = "boss_tools:oxygen_timer";
            int oxygenTimer = persistentData.func_74762_e(key);
            if (oxygenStorage.getOxygenStored() > 0 && ++oxygenTimer > 3 && !player.func_70644_a((Effect)ModInnet.OXYGEN_EFFECT.get())) {
                oxygenStorage.extractOxygen(1, false);
                oxygenTimer = 0;
            }
            persistentData.func_74768_a(key, oxygenTimer);
        }
    }
}

