/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.flag;

import com.mojang.authlib.GameProfile;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.mrscauthd.boss_tools.flag.FlagTileEntity;

public class FlagBlock
extends Block
implements IWaterLoggable {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public FlagBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        Vector3d offset = state.func_191059_e(world, pos);
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            switch ((Direction)state.func_177229_b((Property)FACING)) {
                default: {
                    return VoxelShapes.func_197872_a((VoxelShape)FlagBlock.func_208617_a((double)14.5, (double)0.0, (double)9.0, (double)12.5, (double)1.0, (double)7.0), (VoxelShape)FlagBlock.func_208617_a((double)14.0, (double)1.0, (double)8.5, (double)13.0, (double)16.0, (double)7.5)).func_197751_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
                }
                case NORTH: {
                    return VoxelShapes.func_197872_a((VoxelShape)FlagBlock.func_208617_a((double)1.5, (double)0.0, (double)7.0, (double)3.5, (double)1.0, (double)9.0), (VoxelShape)FlagBlock.func_208617_a((double)2.0, (double)1.0, (double)7.5, (double)3.0, (double)16.0, (double)8.5)).func_197751_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
                }
                case EAST: {
                    return VoxelShapes.func_197872_a((VoxelShape)FlagBlock.func_208617_a((double)9.0, (double)0.0, (double)1.5, (double)7.0, (double)1.0, (double)3.5), (VoxelShape)FlagBlock.func_208617_a((double)8.5, (double)1.0, (double)2.0, (double)7.5, (double)16.0, (double)3.0)).func_197751_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
                }
                case WEST: 
            }
            return VoxelShapes.func_197872_a((VoxelShape)FlagBlock.func_208617_a((double)7.0, (double)0.0, (double)14.5, (double)9.0, (double)1.0, (double)12.5), (VoxelShape)FlagBlock.func_208617_a((double)7.5, (double)1.0, (double)14.0, (double)8.5, (double)16.0, (double)13.0)).func_197751_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
        }
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            default: {
                return VoxelShapes.func_197872_a((VoxelShape)FlagBlock.func_208617_a((double)14.0, (double)0.0, (double)8.5, (double)13.0, (double)16.0, (double)7.5), (VoxelShape)FlagBlock.func_208617_a((double)14.0, (double)7.0, (double)8.5, (double)1.0, (double)15.0, (double)7.5)).func_197751_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
            }
            case NORTH: {
                return VoxelShapes.func_197872_a((VoxelShape)FlagBlock.func_208617_a((double)2.0, (double)0.0, (double)7.5, (double)3.0, (double)16.0, (double)8.5), (VoxelShape)FlagBlock.func_208617_a((double)2.0, (double)7.0, (double)7.5, (double)15.0, (double)15.0, (double)8.5)).func_197751_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
            }
            case EAST: {
                return VoxelShapes.func_197872_a((VoxelShape)FlagBlock.func_208617_a((double)8.5, (double)0.0, (double)2.0, (double)7.5, (double)16.0, (double)3.0), (VoxelShape)FlagBlock.func_208617_a((double)8.5, (double)7.0, (double)2.0, (double)7.5, (double)15.0, (double)15.0)).func_197751_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
            }
            case WEST: 
        }
        return VoxelShapes.func_197872_a((VoxelShape)FlagBlock.func_208617_a((double)7.5, (double)0.0, (double)14.0, (double)8.5, (double)16.0, (double)13.0), (VoxelShape)FlagBlock.func_208617_a((double)7.5, (double)7.0, (double)14.0, (double)8.5, (double)15.0, (double)1.0)).func_197751_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)stateIn.func_177229_b(HALF);
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        if (facing.func_176740_k() == Direction.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            return facingState.func_203425_a((Block)this) && facingState.func_177229_b(HALF) != doubleblockhalf ? (BlockState)stateIn.func_206870_a((Property)FACING, facingState.func_177229_b((Property)FACING)) : Blocks.field_150350_a.func_176223_P();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!worldIn.field_72995_K && player.func_184812_l_()) {
            FlagBlock.removeBottomHalf(worldIn, pos, state, player);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    protected static void removeBottomHalf(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.func_177229_b(HALF);
        if (doubleblockhalf == DoubleBlockHalf.UPPER && (blockstate = world.func_180495_p(blockpos = pos.func_177977_b())).func_177230_c() == state.func_177230_c() && blockstate.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            world.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        if (blockpos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(blockpos.func_177984_a()).func_196953_a(context)) {
            boolean flag = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
            return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f())).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }
        return null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)state.func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        TileEntity tileentity = worldIn.func_175625_s(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()));
        if (tileentity instanceof FlagTileEntity) {
            FlagTileEntity flagtileentity = (FlagTileEntity)tileentity;
            CompoundNBT compoundnbt = new CompoundNBT();
            NBTUtil.func_180708_a((CompoundNBT)compoundnbt, (GameProfile)new GameProfile(placer.func_110124_au(), placer.func_200200_C_().getString()));
            flagtileentity.getTileData().func_218657_a("FlagOwner", (INBT)compoundnbt);
            if (placer instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)placer;
                flagtileentity.setPlayerProfile(player.func_146103_bH());
            }
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FlagTileEntity();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ISkullType getSkullType() {
        return Types.PLAYER;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        return state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? blockstate.func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP) : blockstate.func_203425_a((Block)this);
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(BlockState state, BlockPos pos) {
        return MathHelper.func_180187_c((int)pos.func_177958_n(), (int)pos.func_177979_c(state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).func_177956_o(), (int)pos.func_177952_p());
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HALF, FACING, WATERLOGGED});
    }

    public static enum Types implements ISkullType
    {
        PLAYER;

    }

    public static interface ISkullType {
    }
}

