/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.flag;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.StringUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.mrscauthd.boss_tools.ModInnet;

public class FlagTileEntity
extends TileEntity {
    @Nullable
    private static PlayerProfileCache profileCache;
    @Nullable
    private static MinecraftSessionService sessionService;
    @Nullable
    private GameProfile playerProfile;

    public FlagTileEntity() {
        super((TileEntityType)ModInnet.FLAG.get());
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.playerProfile != null) {
            CompoundNBT compoundnbt = new CompoundNBT();
            NBTUtil.func_180708_a((CompoundNBT)compoundnbt, (GameProfile)this.playerProfile);
            compound.func_218657_a("FlagOwner", (INBT)compoundnbt);
        }
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        String s;
        super.func_230337_a_(state, nbt);
        if (nbt.func_150297_b("FlagOwner", 10)) {
            this.setPlayerProfile(NBTUtil.func_152459_a((CompoundNBT)nbt.func_74775_l("FlagOwner")));
        } else if (nbt.func_150297_b("ExtraType", 8) && !StringUtils.func_151246_b((String)(s = nbt.func_74779_i("ExtraType")))) {
            this.setPlayerProfile(new GameProfile((UUID)null, s));
        }
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public GameProfile getPlayerProfile() {
        return this.playerProfile;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 4, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public void setPlayerProfile(@Nullable GameProfile p_195485_1_) {
        this.playerProfile = p_195485_1_;
        this.updatePlayerProfile();
    }

    private void updatePlayerProfile() {
        this.playerProfile = FlagTileEntity.updateGameProfile(this.playerProfile);
        this.func_70296_d();
    }

    @Nullable
    public static GameProfile updateGameProfile(@Nullable GameProfile input) {
        if (input != null && !StringUtils.func_151246_b((String)input.getName())) {
            if (input.isComplete() && input.getProperties().containsKey((Object)"textures")) {
                return input;
            }
            if (profileCache != null && sessionService != null) {
                GameProfile gameprofile = profileCache.func_152655_a(input.getName());
                if (gameprofile == null) {
                    return input;
                }
                Property property = (Property)Iterables.getFirst((Iterable)gameprofile.getProperties().get((Object)"textures"), (Object)null);
                if (property == null) {
                    gameprofile = sessionService.fillProfileProperties(gameprofile, true);
                }
                return gameprofile;
            }
            return input;
        }
        return input;
    }
}

