/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.fluid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidUtil2 {
    public static final int BUCKET_SIZE = 1000;
    private static final Map<Item, Fluid> fluidCacheds = new HashMap<Item, Fluid>();

    public static Fluid findBucketFluid(Item item) {
        if (item == Items.field_190931_a) {
            return null;
        }
        return fluidCacheds.computeIfAbsent(item, FluidUtil2::findBucketFluidInternal);
    }

    private static Fluid findBucketFluidInternal(Item item) {
        return ForgeRegistries.FLUIDS.getValues().stream().filter(f -> f.func_207193_c(f.func_207188_f()) && f.func_204524_b() == item).findFirst().orElse(null);
    }

    public static boolean isEquivalentTo(FluidStack left, Fluid right) {
        if (left.isEmpty()) {
            return right == Fluids.field_204541_a;
        }
        if (right == Fluids.field_204541_a) {
            return false;
        }
        return left.getFluid().func_207187_a(right);
    }

    public static boolean isEquivalentTo(FluidStack left, FluidStack right) {
        if (left.isEmpty()) {
            return right.isEmpty();
        }
        if (right.isEmpty()) {
            return false;
        }
        return left.getFluid().func_207187_a(right.getFluid()) && FluidStack.areFluidStackTagsEqual((FluidStack)left, (FluidStack)right);
    }

    @Nullable
    public static Fluid getFluid(FluidStack stack) {
        return Optional.ofNullable(stack).map(fs -> fs.getFluid()).orElse(null);
    }

    public static IFluidHandlerItem getItemStackFluidHandler(ItemStack itemStack) {
        return (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse(null);
    }

    public static boolean canFill(ItemStack itemStack, Fluid fluid) {
        if (itemStack.func_190926_b() || fluid == null) {
            return false;
        }
        if (itemStack.func_77973_b() == Items.field_151133_ar) {
            return fluid.func_204524_b() != Items.field_190931_a;
        }
        IFluidHandlerItem handlerInItemStack = FluidUtil2.getItemStackFluidHandler(itemStack);
        return handlerInItemStack != null && handlerInItemStack.fill(new FluidStack(fluid, 1), IFluidHandler.FluidAction.SIMULATE) > 0;
    }

    public static boolean canDrain(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        if (FluidUtil2.findBucketFluid(itemStack.func_77973_b()) != null) {
            return true;
        }
        IFluidHandlerItem handlerInItemStack = FluidUtil2.getItemStackFluidHandler(itemStack);
        return handlerInItemStack != null && !handlerInItemStack.drain(1, IFluidHandler.FluidAction.SIMULATE).isEmpty();
    }

    public static boolean canDrain(ItemStack itemStack, Fluid fluid) {
        if (itemStack.func_190926_b() || fluid == null) {
            return false;
        }
        if (itemStack.func_77973_b() == fluid.func_204524_b()) {
            return true;
        }
        IFluidHandlerItem handlerInItemStack = FluidUtil2.getItemStackFluidHandler(itemStack);
        return handlerInItemStack != null && !handlerInItemStack.drain(new FluidStack(fluid, 1), IFluidHandler.FluidAction.SIMULATE).isEmpty();
    }

    public static int getMaxCapacity(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return 0;
        }
        if (itemStack.func_77973_b() == Items.field_151133_ar) {
            return 1000;
        }
        IFluidHandlerItem handlerInItemStack = FluidUtil2.getItemStackFluidHandler(itemStack);
        if (handlerInItemStack != null) {
            return FluidUtil2.getMaxCapacity((IFluidHandler)handlerInItemStack);
        }
        return 0;
    }

    public static int getMaxCapacity(IFluidHandler fluidHandler) {
        int capacity = 0;
        for (int i = 0; i < fluidHandler.getTanks(); ++i) {
            capacity = Math.max(capacity, fluidHandler.getTankCapacity(i));
        }
        return capacity;
    }

    public static ItemStack makeEmpty(ItemStack itemStack, Fluid fluid) {
        if (itemStack.func_190926_b()) {
            return itemStack;
        }
        if (itemStack.func_77973_b() == fluid.func_204524_b()) {
            return new ItemStack((IItemProvider)Items.field_151133_ar);
        }
        IFluidHandlerItem handlerInItemStack = FluidUtil2.getItemStackFluidHandler(itemStack);
        if (handlerInItemStack != null) {
            FluidStack fluidStack = new FluidStack(fluid, FluidUtil2.getMaxCapacity((IFluidHandler)handlerInItemStack));
            handlerInItemStack.drain(fluidStack, IFluidHandler.FluidAction.EXECUTE);
        }
        return itemStack;
    }

    public static ItemStack makeFull(ItemStack itemStack, Fluid fluid) {
        if (itemStack.func_190926_b()) {
            return itemStack;
        }
        if (itemStack.func_77973_b() == Items.field_151133_ar && fluid.func_204524_b() != null) {
            return new ItemStack((IItemProvider)fluid.func_204524_b());
        }
        IFluidHandlerItem handlerInItemStack = FluidUtil2.getItemStackFluidHandler(itemStack);
        if (handlerInItemStack != null) {
            FluidStack fluidStack = new FluidStack(fluid, FluidUtil2.getMaxCapacity((IFluidHandler)handlerInItemStack));
            handlerInItemStack.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
        }
        return itemStack;
    }

    public static List<FluidStack> getFluidStacks(ItemStack itemStack) {
        ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
        if (itemStack.func_190926_b()) {
            return fluidStacks;
        }
        Item item = itemStack.func_77973_b();
        if (item == Items.field_151133_ar) {
            fluidStacks.add(new FluidStack(Fluids.field_204541_a, 0));
        } else {
            IFluidHandlerItem handlerInItemStack = FluidUtil2.getItemStackFluidHandler(itemStack);
            if (handlerInItemStack != null) {
                for (int i = 0; i < handlerInItemStack.getTanks(); ++i) {
                    fluidStacks.add(handlerInItemStack.getFluidInTank(i));
                }
            } else {
                Fluid fluid = FluidUtil2.findBucketFluid(item);
                if (fluid != null) {
                    fluidStacks.add(new FluidStack(fluid, 1000));
                }
            }
        }
        return fluidStacks;
    }

    public static boolean fillSink(IItemHandlerModifiable itemHandler, int sinkItemSlot, IFluidHandler source, int transfer) {
        ItemStack sinkItemStack = itemHandler.getStackInSlot(sinkItemSlot);
        if (FluidUtil2.fillSinkBucket(itemHandler, sinkItemSlot, source, sinkItemStack)) {
            return true;
        }
        return !FluidUtil2.fillSinkCapability(source, sinkItemStack, transfer).isEmpty();
    }

    public static FluidStack fillSinkCapability(IFluidHandler source, ItemStack sinkItemStack, int transfer) {
        IFluidHandlerItem sink = FluidUtil2.getItemStackFluidHandler(sinkItemStack);
        return FluidUtil2.tryTransfer((IFluidHandler)sink, source, transfer);
    }

    public static boolean fillSinkBucket(IItemHandlerModifiable itemHandler, int sinkItemSlot, IFluidHandler source, ItemStack itemStack) {
        int size;
        FluidStack fluidStack;
        if (itemStack.func_77973_b() == Items.field_151133_ar && (fluidStack = source.drain(size = 1000, IFluidHandler.FluidAction.SIMULATE)).getAmount() == size) {
            source.drain(size, IFluidHandler.FluidAction.EXECUTE);
            itemHandler.setStackInSlot(sinkItemSlot, new ItemStack((IItemProvider)fluidStack.getFluid().func_204524_b()));
            return true;
        }
        return false;
    }

    public static boolean drainSource(IItemHandlerModifiable itemHandler, int sourceItemSlot, IFluidHandler sink, int transfer) {
        ItemStack sourceItemStack = itemHandler.getStackInSlot(sourceItemSlot);
        if (FluidUtil2.drainSourceBucket(itemHandler, sourceItemSlot, sink, sourceItemStack)) {
            return true;
        }
        return !FluidUtil2.drainSourceCapability(sink, sourceItemStack, transfer).isEmpty();
    }

    public static boolean drainSourceBucket(IItemHandlerModifiable itemHandler, int itemSlot, IFluidHandler sink, ItemStack sourceItemStack) {
        FluidStack fluidStack;
        Item sourceItem = sourceItemStack.func_77973_b();
        Fluid sourceFluid = FluidUtil2.findBucketFluid(sourceItem);
        if (sourceFluid != null && sink.fill(fluidStack = new FluidStack(sourceFluid, 1000), IFluidHandler.FluidAction.SIMULATE) == fluidStack.getAmount()) {
            sink.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            itemHandler.setStackInSlot(itemSlot, new ItemStack((IItemProvider)Items.field_151133_ar));
            return true;
        }
        return false;
    }

    public static FluidStack drainSourceCapability(IFluidHandler sink, ItemStack sourceItemStack, int transfer) {
        IFluidHandlerItem source = FluidUtil2.getItemStackFluidHandler(sourceItemStack);
        return FluidUtil2.tryTransfer(sink, (IFluidHandler)source, transfer);
    }

    public static FluidStack tryTransfer(IFluidHandler sink, IFluidHandler source, int transfer) {
        if (sink != null && source != null && transfer > 0) {
            return FluidUtil.tryFluidTransfer((IFluidHandler)sink, (IFluidHandler)source, (int)transfer, (boolean)true);
        }
        return FluidStack.EMPTY;
    }

    private FluidUtil2() {
    }
}

