/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.gauge;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.mrscauthd.boss_tools.gauge.GaugeTextHelper;
import net.mrscauthd.boss_tools.gauge.GaugeValueSerializer;
import net.mrscauthd.boss_tools.gauge.IGaugeValue;
import net.mrscauthd.boss_tools.gui.helper.GuiHelper;
import net.mrscauthd.boss_tools.util.Rectangle2d;
import org.lwjgl.opengl.GL11;

public abstract class AbstractGaugeDataRenderer {
    private final IGaugeValue value;

    public AbstractGaugeDataRenderer(IGaugeValue value) {
        this.value = value;
    }

    public void toBytes(PacketBuffer buffer) {
        GaugeValueSerializer.Serializer.write(this.getValue(), buffer);
    }

    public void render(MatrixStack matrixStack, int left, int top) {
        this.drawBorder(matrixStack, left, top);
        int width = this.getWidth();
        int height = this.getHeight();
        int padding = this.getBorderWidth();
        Rectangle2d innerBounds = new Rectangle2d(left + padding, top + padding, width - padding * 2, height - padding * 2);
        this.drawBackground(matrixStack, innerBounds);
        this.drawContents(matrixStack, innerBounds);
        this.drawGaugeText(matrixStack, innerBounds);
    }

    protected void drawContents(MatrixStack matrixStack, Rectangle2d innerBounds) {
    }

    @Nullable
    public ITextComponent getGaugeText() {
        return GaugeTextHelper.getValueText(this.getValue()).build();
    }

    protected void drawGaugeText(MatrixStack matrixStack, Rectangle2d innerBounds) {
        ITextComponent text = this.getGaugeText();
        if (text != null) {
            int color = this.getTextColor();
            int textPadding = 2;
            Rectangle2d textBounds = new Rectangle2d(innerBounds.getX() + textPadding, innerBounds.getY(), innerBounds.getWidth() - textPadding, innerBounds.getHeight());
            this.drawText(matrixStack, textBounds, text, color);
        }
    }

    protected void drawText(MatrixStack matrixStack, Rectangle2d bounds, ITextComponent text, int color) {
        this.drawText(Minecraft.func_71410_x(), matrixStack, bounds, text, color);
    }

    protected void drawText(Minecraft minecraft, MatrixStack matrixStack, Rectangle2d bounds, ITextComponent text, int color) {
        FontRenderer fontRenderer = minecraft.field_71466_p;
        int textWidth = fontRenderer.func_238414_a_((ITextProperties)text);
        float scale = Math.min(1.0f, (float)bounds.getWidth() / (float)textWidth);
        float offsetX = 0.0f;
        float f = bounds.getHeight();
        fontRenderer.getClass();
        float offsetY = (f - (float)(9 - 1) * scale) / 2.0f;
        float scaledX = ((float)bounds.getX() + offsetX) / scale;
        float scaledY = ((float)bounds.getY() + offsetY) / scale;
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(scale, scale, scale);
        fontRenderer.func_243248_b(matrixStack, text, scaledX, scaledY, color);
        matrixStack.func_227865_b_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawBackground(MatrixStack matrixStack, Rectangle2d innerBounds) {
        IGaugeValue value = this.getValue();
        int tileColor = value.getColor();
        double displayRatio = value.getDisplayRatio();
        try {
            ResourceLocation texture;
            RenderSystem.enableBlend();
            RenderSystem.enableAlphaTest();
            GuiHelper.setGLColorFromInt(tileColor);
            TextureAtlasSprite tileTexture = this.getBackgroundTileTexture();
            if (tileTexture != null) {
                int tileWidth = this.getBackgroundTileWidth();
                int tileHeight = this.getBackgroundTileHeight();
                int ratioWidth = (int)Math.ceil((double)innerBounds.getWidth() * displayRatio);
                GuiHelper.drawTiledSprite(matrixStack, innerBounds.getX(), innerBounds.getY(), ratioWidth, innerBounds.getHeight(), tileTexture, tileWidth, tileHeight);
            }
            if ((texture = this.getBackgroundTexture()) != null) {
                GuiHelper.drawHorizontal(matrixStack, innerBounds.getX(), innerBounds.getY(), innerBounds.getWidth(), innerBounds.getHeight(), texture, displayRatio);
            }
        }
        finally {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableAlphaTest();
            RenderSystem.disableBlend();
        }
    }

    protected void drawBorder(MatrixStack matrixStack, int left, int top) {
        int width = this.getWidth();
        int height = this.getHeight();
        int borderColor = this.getBorderColor();
        int padding = this.getBorderWidth();
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)left, (int)top, (int)(left + width - padding), (int)(top + padding), (int)borderColor);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)left, (int)top, (int)(left + padding), (int)(top + height - padding), (int)borderColor);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(left + width - padding), (int)top, (int)(left + width), (int)(top + height - padding), (int)borderColor);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)left, (int)(top + height - padding), (int)(left + width), (int)(top + height), (int)borderColor);
    }

    public int getTextColor() {
        return -1;
    }

    @Nullable
    public TextureAtlasSprite getBackgroundTileTexture() {
        return null;
    }

    @Nullable
    public ResourceLocation getBackgroundTexture() {
        return null;
    }

    public int getBackgroundTileWidth() {
        return 16;
    }

    public int getBackgroundTileHeight() {
        return 16;
    }

    public int getBorderWidth() {
        return 1;
    }

    public int getBorderColor() {
        return -16777216;
    }

    public int getWidth() {
        return 100;
    }

    public int getHeight() {
        return 13;
    }

    public IGaugeValue getValue() {
        return this.value;
    }
}

