/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.gauge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.mrscauthd.boss_tools.gauge.IGaugeValue;
import org.apache.commons.lang3.StringUtils;

public class GaugeTextBuilder {
    private final IGaugeValue value;
    private final String translationKey;
    private final List<Object> extraValues;
    private final Map<Integer, Style> extraStyles;
    private Style textStyle;
    private Style amountStyle;
    private Style capacityStyle;
    private Style unitStyle;
    private String unitSuffix;

    public GaugeTextBuilder(IGaugeValue value, String translationKey, List<Object> extraValues) {
        this.value = value;
        this.translationKey = translationKey;
        this.extraValues = Collections.unmodifiableList(extraValues);
        this.extraStyles = new HashMap<Integer, Style>();
        this.setTextStyle(Style.field_240709_b_);
        this.setAmountStyle(Style.field_240709_b_);
        this.setCapacityStyle(Style.field_240709_b_);
        this.setUnitStyle(Style.field_240709_b_);
        this.setUnitSuffix("");
    }

    public IFormattableTextComponent build() {
        IGaugeValue value = this.getValue();
        ITextComponent displayName = value.getDisplayName();
        int amount = value.getAmount();
        int capacity = value.getCapacity();
        String unit = value.getUnit();
        ArrayList<IFormattableTextComponent> list = new ArrayList<IFormattableTextComponent>();
        list.add(this.format(displayName, this.getTextStyle()));
        list.add(this.format(String.valueOf(amount), this.getAmountStyle(), unit, this.getUnitStyle()));
        list.add(this.format(String.valueOf(capacity), this.getCapacityStyle(), unit, this.getUnitStyle()));
        for (int i = 0; i < this.getExtraValues().size(); ++i) {
            Object extraValue = this.getExtraValues().get(i);
            Style extraStyle = this.getExtraStyle(i);
            list.add(new TranslationTextComponent("%s", new Object[]{extraValue}).func_230530_a_(extraStyle));
        }
        return new TranslationTextComponent(this.getTranslationKey(), list.toArray()).func_230530_a_(this.getTextStyle());
    }

    public IFormattableTextComponent format(String valueText, Style valueStyle, String unitText, Style unitStyle) {
        if (!StringUtils.isEmpty((CharSequence)unitText)) {
            return this.format(valueText, valueStyle).func_240702_b_(" ").func_230529_a_((ITextComponent)this.format(unitText + this.getUnitSuffix(), unitStyle));
        }
        return this.format(valueText, valueStyle);
    }

    public IFormattableTextComponent format(String text, Style style) {
        return new StringTextComponent(text).func_230530_a_(style);
    }

    public IFormattableTextComponent format(ITextComponent text, Style style) {
        return new StringTextComponent("").func_230529_a_(text).func_230530_a_(style);
    }

    public final IGaugeValue getValue() {
        return this.value;
    }

    public final String getTranslationKey() {
        return this.translationKey;
    }

    public final List<Object> getExtraValues() {
        return this.extraValues;
    }

    public final Map<Integer, Style> getExtraStyles() {
        return this.extraStyles;
    }

    public Style getTextStyle() {
        return this.textStyle;
    }

    public GaugeTextBuilder setTextStyle(Style textStyle) {
        this.textStyle = textStyle;
        return this;
    }

    public Style getAmountStyle() {
        return this.amountStyle;
    }

    public GaugeTextBuilder setAmountStyle(Style amountStyle) {
        this.amountStyle = amountStyle;
        return this;
    }

    public Style getCapacityStyle() {
        return this.capacityStyle;
    }

    public GaugeTextBuilder setCapacityStyle(Style capacityStyle) {
        this.capacityStyle = capacityStyle;
        return this;
    }

    public Style getUnitStyle() {
        return this.unitStyle;
    }

    public GaugeTextBuilder setUnitStyle(Style unitStyle) {
        this.unitStyle = unitStyle;
        return this;
    }

    public String getUnitSuffix() {
        return this.unitSuffix;
    }

    public GaugeTextBuilder setUnitSuffix(String unitSuffix) {
        this.unitSuffix = unitSuffix;
        return this;
    }

    public GaugeTextBuilder setExtraStyle(int index, Style style) {
        this.getExtraStyles().put(index, style);
        return this;
    }

    public Style getExtraStyle(int index) {
        return this.getExtraStyles().getOrDefault(index, Style.field_240709_b_);
    }
}

