/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.gauge;

import com.google.common.collect.Lists;
import java.text.NumberFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.mrscauthd.boss_tools.capability.IOxygenStorage;
import net.mrscauthd.boss_tools.gauge.GaugeTextBuilder;
import net.mrscauthd.boss_tools.gauge.GaugeValueHelper;
import net.mrscauthd.boss_tools.gauge.IGaugeValue;

public class GaugeTextHelper {
    public static final ResourceLocation USING_NAME = new ResourceLocation("boss_tools", "using");
    public static final ResourceLocation USING2_NAME = new ResourceLocation("boss_tools", "using2");
    public static final ResourceLocation GENERATING_NAME = new ResourceLocation("boss_tools", "generating");
    public static final ResourceLocation MAXGENERATION_NAME = new ResourceLocation("boss_tools", "maxgeneration");
    public static final ResourceLocation TOTAL_NAME = new ResourceLocation("boss_tools", "total");
    public static final ResourceLocation STORED_NAME = new ResourceLocation("boss_tools", "stored");
    public static final ResourceLocation CAPACITY_NAME = new ResourceLocation("boss_tools", "capacity");
    public static final ResourceLocation TRANSFER_NAME = new ResourceLocation("boss_tools", "transfer");
    public static final String USING_KEY = GaugeTextHelper.makeTranslationKey(USING_NAME);
    public static final String USING2_KEY = GaugeTextHelper.makeTranslationKey(USING2_NAME);
    public static final String GENERATING_KEY = GaugeTextHelper.makeTranslationKey(GENERATING_NAME);
    public static final String MAXGNERATION_KEY = GaugeTextHelper.makeTranslationKey(MAXGENERATION_NAME);
    public static final String TOTAL_KEY = GaugeTextHelper.makeTranslationKey(TOTAL_NAME);
    public static final String STORED_KEY = GaugeTextHelper.makeTranslationKey(STORED_NAME);
    public static final String CAPACITY_KEY = GaugeTextHelper.makeTranslationKey(CAPACITY_NAME);
    public static final String TRANSFER_KEY = GaugeTextHelper.makeTranslationKey(TRANSFER_NAME);
    public static final String PER_TICK_UNIT_SUFFIX = "/t";

    public static String makeTranslationKey(ResourceLocation name) {
        return "gauge_text." + name.func_110624_b() + "." + name.func_110623_a();
    }

    public static GaugeTextBuilder getText(IGaugeValue value, String key, Object ... values) {
        return new GaugeTextBuilder(value, key, Lists.newArrayList((Object[])values));
    }

    public static GaugeTextBuilder getValueText(IGaugeValue value) {
        return GaugeTextHelper.getText(value, "%1$s: %2$s", new Object[0]);
    }

    public static GaugeTextBuilder getStorageText(IGaugeValue value) {
        return GaugeTextHelper.getText(value, "%1$s: %2$s \u00a78| %3$s", new Object[0]);
    }

    public static GaugeTextBuilder getPercentText(IGaugeValue value, int decimals) {
        NumberFormat numberInstance = NumberFormat.getNumberInstance();
        numberInstance.setMaximumFractionDigits(decimals);
        return GaugeTextHelper.getText(value, "%1$s: %4$s", numberInstance.format(value.getDisplayRatio() * 100.0) + "%");
    }

    public static GaugeTextBuilder getPercentText(IGaugeValue value) {
        return GaugeTextHelper.getPercentText(value, 0);
    }

    public static GaugeTextBuilder getUsingText(IGaugeValue value) {
        return GaugeTextHelper.getText(value, USING_KEY, new Object[0]);
    }

    public static GaugeTextBuilder getUsingPerTickText(IGaugeValue value) {
        return GaugeTextHelper.getUsingText(value).setUnitSuffix(PER_TICK_UNIT_SUFFIX);
    }

    public static GaugeTextBuilder getUsingText2(IGaugeValue value, int interval) {
        return GaugeTextHelper.getText(value, USING2_KEY, String.valueOf(interval));
    }

    public static GaugeTextBuilder getTotalText(IGaugeValue value) {
        return GaugeTextHelper.getText(value, TOTAL_KEY, new Object[0]);
    }

    public static GaugeTextBuilder getGeneratingText(IGaugeValue value) {
        return GaugeTextHelper.getText(value, GENERATING_KEY, new Object[0]);
    }

    public static GaugeTextBuilder getGeneratingPerTickText(IGaugeValue value) {
        return GaugeTextHelper.getGeneratingText(value).setUnitSuffix(PER_TICK_UNIT_SUFFIX);
    }

    public static GaugeTextBuilder getMaxGenerationText(IGaugeValue value) {
        return GaugeTextHelper.getText(value, MAXGNERATION_KEY, new Object[0]);
    }

    public static GaugeTextBuilder getMaxGenerationPerTickText(IGaugeValue value) {
        return GaugeTextHelper.getMaxGenerationText(value).setUnitSuffix(PER_TICK_UNIT_SUFFIX);
    }

    public static GaugeTextBuilder getStoredText(IGaugeValue value) {
        return GaugeTextHelper.getText(value, STORED_KEY, new Object[0]);
    }

    public static GaugeTextBuilder getCapacityText(IGaugeValue value) {
        return GaugeTextHelper.getText(value, CAPACITY_KEY, new Object[0]);
    }

    public static GaugeTextBuilder getTransferText(IGaugeValue value) {
        return GaugeTextHelper.getText(value, TRANSFER_KEY, new Object[0]);
    }

    public static GaugeTextBuilder getTransferPerTickText(IGaugeValue value) {
        return GaugeTextHelper.getTransferText(value).setUnitSuffix(PER_TICK_UNIT_SUFFIX);
    }

    public static IFormattableTextComponent buildSpacesuitOxygenTooltip(IGaugeValue value) {
        GaugeTextBuilder builder = GaugeTextHelper.getText(value, "%1$s: %2$s \u00a78| %3$s", new Object[0]);
        builder.setTextStyle(Style.field_240709_b_.func_240712_a_(TextFormatting.BLUE));
        builder.setAmountStyle(Style.field_240709_b_.func_240712_a_(TextFormatting.GOLD));
        builder.setCapacityStyle(Style.field_240709_b_.func_240712_a_(TextFormatting.RED));
        return builder.build();
    }

    public static IFormattableTextComponent buildSpacesuitOxygenTooltip(IOxygenStorage oxygenStorage) {
        IGaugeValue oxygen = oxygenStorage != null ? GaugeValueHelper.getOxygen(oxygenStorage.getOxygenStored(), oxygenStorage.getMaxOxygenStored()) : GaugeValueHelper.getOxygen(0, 0);
        return GaugeTextHelper.buildSpacesuitOxygenTooltip(oxygen);
    }

    public static IFormattableTextComponent buildBlockTooltip(GaugeTextBuilder builder, TextFormatting color) {
        builder.setTextStyle(Style.field_240709_b_.func_240712_a_(TextFormatting.BLUE));
        builder.setAmountStyle(Style.field_240709_b_.func_240712_a_(color));
        builder.setCapacityStyle(Style.field_240709_b_.func_240712_a_(color));
        builder.setExtraStyle(0, Style.field_240709_b_.func_240712_a_(color));
        return builder.build();
    }

    public static IFormattableTextComponent buildBlockTooltip(GaugeTextBuilder builder) {
        return GaugeTextHelper.buildBlockTooltip(builder, TextFormatting.GRAY);
    }
}

