/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.gauge;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.mrscauthd.boss_tools.gauge.IGaugeValue;

public class GaugeValueFluidStack
implements IGaugeValue {
    private FluidStack stack;
    private int capacity;

    public GaugeValueFluidStack() {
    }

    public GaugeValueFluidStack(FluidStack stack, int capacity) {
        this.setStack(stack);
        this.setCapacity(capacity);
    }

    public void deserializeNBT(CompoundNBT compound) {
        this.setStack(FluidStack.loadFluidStackFromNBT((CompoundNBT)compound.func_74775_l("stack")));
        this.setCapacity(compound.func_74762_e("capacity"));
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        CompoundNBT stackCompound = new CompoundNBT();
        this.getStack().writeToNBT(stackCompound);
        compound.func_218657_a("stack", (INBT)stackCompound);
        compound.func_74768_a("capacity", this.getCapacity());
        return compound;
    }

    @Override
    public int getColor() {
        FluidStack fluidStack = this.getStack();
        FluidAttributes attributes = fluidStack.getFluid().getAttributes();
        return attributes.getColor(fluidStack);
    }

    public FluidStack getStack() {
        return this.stack;
    }

    public void setStack(FluidStack stack) {
        this.stack = stack;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.getStack().getDisplayName();
    }

    @Override
    public String getUnit() {
        return "mB";
    }

    @Override
    public int getAmount() {
        return this.getStack().getAmount();
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public boolean isReverse() {
        return false;
    }
}

