/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.gauge;

import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.mrscauthd.boss_tools.capability.IOxygenStorage;
import net.mrscauthd.boss_tools.gauge.GaugeValueFluidStack;
import net.mrscauthd.boss_tools.gauge.GaugeValueSimple;
import net.mrscauthd.boss_tools.gauge.IGaugeValue;
import net.mrscauthd.boss_tools.machines.tile.AbstractMachineTileEntity;
import net.mrscauthd.boss_tools.machines.tile.PowerSystemFuelBurnTime;

public class GaugeValueHelper {
    public static final ResourceLocation ENERGY_NAME = new ResourceLocation("boss_tools", "energy");
    public static final ResourceLocation OXYGEN_NAME = new ResourceLocation("boss_tools", "oxygen");
    public static final ResourceLocation FLUID_NAME = new ResourceLocation("boss_tools", "fluid");
    public static final ResourceLocation FUEL_NAME = new ResourceLocation("boss_tools", "fuel");
    public static final ResourceLocation BURNTIME_NAME = new ResourceLocation("boss_tools", "burntime");
    public static final ResourceLocation COOKTIME_NAME = new ResourceLocation("boss_tools", "cooktime");
    public static final int ENERGY_COLOR = -1593884597;
    public static final int OXYGEN_COLOR = -1610547201;
    public static final int FUEL_COLOR = -1600546499;
    public static final int BURNTIME_COLOR = -1593884928;
    public static final int COOKTIME_COLOR = -1593835521;
    public static final String ENERGY_UNIT = "FE";
    public static final String OXYGEN_UNIT = "mB";
    public static final String FLUID_UNIT = "mB";

    public static String makeTranslationKey(ResourceLocation name) {
        return "gauge." + name.func_110624_b() + "." + name.func_110623_a();
    }

    public static IGaugeValue getFluid(int amount) {
        return GaugeValueHelper.getFluid(amount, 0);
    }

    public static IGaugeValue getFluid(int amount, int capacity) {
        return new GaugeValueSimple(FLUID_NAME, amount, capacity, null, "mB");
    }

    public static IGaugeValue getFluid(Fluid fluid, int amount) {
        return GaugeValueHelper.getFluid(new FluidStack(fluid, amount));
    }

    public static IGaugeValue getFluid(Fluid fluid, int amount, int capacity) {
        return GaugeValueHelper.getFluid(new FluidStack(fluid, amount), capacity);
    }

    public static IGaugeValue getFluid(FluidStack stack) {
        return GaugeValueHelper.getFluid(stack, 0);
    }

    public static IGaugeValue getFluid(FluidStack stack, int capacity) {
        return new GaugeValueFluidStack(stack, capacity);
    }

    public static IGaugeValue getFluid(IFluidTank tank) {
        return GaugeValueHelper.getFluid(tank.getFluid(), tank.getCapacity());
    }

    public static IGaugeValue getEnergy(int amount) {
        return GaugeValueHelper.getEnergy(amount, 0);
    }

    public static IGaugeValue getEnergy(int stored, int capacity) {
        return new GaugeValueSimple(ENERGY_NAME, stored, capacity, null, ENERGY_UNIT).color(-1593884597);
    }

    public static IGaugeValue getEnergy(IEnergyStorage energyStorage) {
        return GaugeValueHelper.getEnergy(energyStorage.getEnergyStored(), energyStorage.getMaxEnergyStored());
    }

    public static IGaugeValue getEnergy(AbstractMachineTileEntity machineTileEntity) {
        return GaugeValueHelper.getEnergy(machineTileEntity.getPrimaryEnergyStorage());
    }

    public static IGaugeValue getOxygen(int amount) {
        return GaugeValueHelper.getOxygen(amount, 0);
    }

    public static IGaugeValue getOxygen(int amount, int capacity) {
        return new GaugeValueSimple(OXYGEN_NAME, amount, capacity, null, "mB").color(-1610547201);
    }

    public static IGaugeValue getOxygen(IOxygenStorage oxygenStorage) {
        return GaugeValueHelper.getOxygen(oxygenStorage.getOxygenStored(), oxygenStorage.getMaxOxygenStored());
    }

    public static IGaugeValue getBurnTime(int amount) {
        return GaugeValueHelper.getBurnTime(amount, 0);
    }

    public static IGaugeValue getBurnTime(int amount, int capacity) {
        return new GaugeValueSimple(BURNTIME_NAME, amount, capacity).color(-1593884928);
    }

    public static IGaugeValue getBurnTime(PowerSystemFuelBurnTime fuelPowerSystem) {
        return GaugeValueHelper.getBurnTime(fuelPowerSystem.getStored(), fuelPowerSystem.getCapacity());
    }

    public static IGaugeValue getCookTime(int timer, int maxTimer) {
        return new GaugeValueSimple(COOKTIME_NAME, maxTimer - timer, maxTimer).color(-1593835521).reverse(true);
    }

    public static IGaugeValue getFuel(int amount) {
        return GaugeValueHelper.getFuel(amount, 0);
    }

    public static IGaugeValue getFuel(int amount, int capacity) {
        return new GaugeValueSimple(FUEL_NAME, amount, capacity, null, "mB").color(-1600546499);
    }
}

