/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.gauge;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.crash.CrashReport;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;
import net.mrscauthd.boss_tools.gauge.GaugeValueFluidStack;
import net.mrscauthd.boss_tools.gauge.GaugeValueSimple;
import net.mrscauthd.boss_tools.gauge.IGaugeValue;

public class GaugeValueSerializer<T extends INBTSerializable<CompoundNBT>> {
    public static final GaugeValueSerializer<IGaugeValue> Serializer = new GaugeValueSerializer();
    private final Map<ResourceLocation, Class<? extends T>> location_class_map = new LinkedHashMap<ResourceLocation, Class<? extends T>>();
    private final Map<Class<? extends T>, ResourceLocation> class_location_map = new LinkedHashMap<Class<? extends T>, ResourceLocation>();

    private GaugeValueSerializer() {
    }

    public T deserialize(CompoundNBT compound) {
        String locationToString = compound.func_74779_i("location");
        CompoundNBT valueNBT = compound.func_74775_l("value");
        Class<T> clazz = this.location_class_map.get(new ResourceLocation(locationToString));
        INBTSerializable format = null;
        try {
            format = (INBTSerializable)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            format.deserializeNBT((INBT)valueNBT);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            new CrashReport("deserialize exception", (Throwable)e).func_71502_e();
        }
        return (T)format;
    }

    public T read(PacketBuffer buffer) {
        return this.deserialize(buffer.func_150793_b());
    }

    public CompoundNBT serialize(T format) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("location", this.class_location_map.get(format.getClass()).toString());
        compound.func_218657_a("value", format.serializeNBT());
        return compound;
    }

    public void write(T format, PacketBuffer buffer) {
        buffer.func_150786_a(this.serialize(format));
    }

    public void addCodec(ResourceLocation location, Class<? extends T> clazz) {
        this.location_class_map.put(location, clazz);
        this.class_location_map.put(clazz, location);
    }

    static {
        Serializer.addCodec(new ResourceLocation("boss_tools", "fluidstack"), GaugeValueFluidStack.class);
        Serializer.addCodec(new ResourceLocation("boss_tools", "simple"), GaugeValueSimple.class);
    }
}

