/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.gauge;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.mrscauthd.boss_tools.gauge.GaugeValueHelper;
import net.mrscauthd.boss_tools.gauge.IGaugeValue;

public class GaugeValueSimple
implements IGaugeValue {
    public static final int FALLBACK_COLOR = -1593835521;
    private ResourceLocation name;
    private int amount;
    private int capacity;
    private ITextComponent displayeName;
    private String unit;
    private int color;
    private boolean reverse;
    private ITextComponent displayNameCache;

    public GaugeValueSimple() {
        this(null);
    }

    public GaugeValueSimple(@Nonnull ResourceLocation name) {
        this(name, 0, 0);
    }

    public GaugeValueSimple(@Nonnull ResourceLocation name, int amount, int capacity) {
        this(name, amount, capacity, null);
    }

    public GaugeValueSimple(@Nonnull ResourceLocation name, int amount, int capacity, @Nullable ITextComponent displayeName) {
        this(name, amount, capacity, displayeName, "");
    }

    public GaugeValueSimple(@Nonnull ResourceLocation name, int amount, int capacity, @Nullable ITextComponent displayeName, @Nonnull String unit) {
        this(name, amount, capacity, displayeName, unit, -1593835521);
    }

    public GaugeValueSimple(@Nonnull ResourceLocation name, int amount, int capacity, @Nullable ITextComponent displayeName, @Nonnull String unit, int color) {
        this.name = name;
        this.amount = amount;
        this.capacity = capacity;
        this.displayeName = displayeName;
        this.unit = unit;
        this.color = color;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("name", this.getName().toString());
        compound.func_74768_a("amount", this.getAmount());
        compound.func_74768_a("capacity", this.getCapacity());
        if (this.getDisplayName() != null) {
            compound.func_74778_a("displayName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.getDisplayName()));
        }
        compound.func_74778_a("unit", this.getUnit());
        compound.func_74768_a("color", this.getColor());
        compound.func_74757_a("reverse", this.isReverse());
        return compound;
    }

    public void deserializeNBT(CompoundNBT compound) {
        this.name(new ResourceLocation(compound.func_74779_i("name")));
        this.amount(compound.func_74762_e("amount"));
        this.capacity(compound.func_74762_e("capacity"));
        if (compound.func_74764_b("displayName")) {
            this.displayeName((ITextComponent)ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("displayName")));
        }
        this.unit(compound.func_74779_i("unit"));
        this.color(compound.func_74762_e("color"));
        this.reverse(compound.func_74767_n("reverse"));
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public GaugeValueSimple name(@Nonnull ResourceLocation name) {
        this.name = name;
        return this;
    }

    @Override
    @Nullable
    public ITextComponent getDisplayName() {
        if (this.displayeName != null) {
            return this.displayeName.func_230531_f_();
        }
        if (this.displayNameCache == null) {
            this.displayNameCache = this.createDefaultTextComponent();
        }
        return this.displayNameCache;
    }

    protected TranslationTextComponent createDefaultTextComponent() {
        return new TranslationTextComponent(GaugeValueHelper.makeTranslationKey(this.getName()));
    }

    public GaugeValueSimple displayeName(@Nullable ITextComponent displayeName) {
        this.displayeName = displayeName;
        return this;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    public GaugeValueSimple unit(@Nonnull String unit) {
        this.unit = unit;
        return this;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    public GaugeValueSimple amount(int amount) {
        this.amount = amount;
        return this;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    public GaugeValueSimple capacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    public GaugeValueSimple color(int color) {
        this.color = color;
        return this;
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }

    public GaugeValueSimple reverse(boolean reverse) {
        this.reverse = reverse;
        return this;
    }
}

