/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.gui.helper;

import java.util.List;
import java.util.function.Function;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.mrscauthd.boss_tools.gui.helper.IMergeItemStack;

public class ContainerHelper {
    public static void addInventorySlots(Container container, PlayerInventory inv, int left, int top, Function<Slot, Slot> addSlot) {
        ContainerHelper.addInventorySlots(container, inv, left, top, top + 58, addSlot);
    }

    public static void addInventorySlots(Container container, PlayerInventory inv, int left, int top, int hotbarY, Function<Slot, Slot> addSlot) {
        int rows = 3;
        int cols = 9;
        int offsetX = 18;
        int offsetY = 18;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                addSlot.apply(new Slot((IInventory)inv, col + (row + 1) * cols, left + col * offsetX, top + row * offsetY));
            }
        }
        for (int col = 0; col < cols; ++col) {
            addSlot.apply(new Slot((IInventory)inv, col, left + col * offsetX, hotbarY));
        }
    }

    public static ItemStack transferStackInSlot(Container container, PlayerEntity player, int slotNumber, int containerIndex, IInventory inventory, IMergeItemStack mergeItemStack) {
        int containerSize = inventory.func_70302_i_();
        return ContainerHelper.transferStackInSlot(container, player, slotNumber, containerIndex, containerSize, mergeItemStack);
    }

    public static ItemStack transferStackInSlot(Container container, PlayerEntity player, int slotNumber, int containerIndex, int containerSize, IMergeItemStack mergeItemStack) {
        ItemStack itemStack = ItemStack.field_190927_a;
        List inventorySlots = container.field_75151_b;
        Slot slot = (Slot)inventorySlots.get(slotNumber);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            itemStack = slotStack.func_77946_l();
            int playerInventoryStartIndex = containerIndex + containerSize;
            if (slotNumber < playerInventoryStartIndex ? !mergeItemStack.mergeItemStack(slotStack, playerInventoryStartIndex, inventorySlots.size(), true) : !mergeItemStack.mergeItemStack(slotStack, containerIndex, playerInventoryStartIndex, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemStack;
    }

    public static ItemStack transferStackInSlot(Container container, PlayerEntity player, int slotNumber, IInventory inventory, IMergeItemStack mergeItemStack) {
        return ContainerHelper.transferStackInSlot(container, player, slotNumber, 0, inventory, mergeItemStack);
    }
}

