/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.gui.helper;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.mrscauthd.boss_tools.capability.IOxygenStorage;
import net.mrscauthd.boss_tools.fluid.FluidUtil2;
import net.mrscauthd.boss_tools.util.Rectangle2d;

public class GuiHelper {
    public static final ResourceLocation FIRE_PATH = new ResourceLocation("boss_tools", "textures/fire_on.png");
    public static final int FIRE_WIDTH = 14;
    public static final int FIRE_HEIGHT = 14;
    public static final ResourceLocation ARROW_PATH = new ResourceLocation("boss_tools", "textures/animated_arrow_full.png");
    public static final int ARROW_WIDTH = 24;
    public static final int ARROW_HEIGHT = 17;
    public static final ResourceLocation OXYGEN_CONTENT_PATH = new ResourceLocation("boss_tools", "textures/oxygen.png");
    public static final ResourceLocation OXYGEN_TANK_PATH = new ResourceLocation("boss_tools", "textures/fluid_tank_fore.png");
    public static final int OXYGEN_TANK_WIDTH = 14;
    public static final int OXYGEN_TANK_HEIGHT = 48;
    public static final ResourceLocation ENERGY_PATH = new ResourceLocation("boss_tools", "textures/energy_full.png");
    public static final int ENERGY_WIDTH = 24;
    public static final int ENERGY_HEIGHT = 48;
    public static final int FUEL_WIDTH = 48;
    public static final int FUEL_HEIGHT = 48;
    public static final ResourceLocation FLUID_TANK_PATH = new ResourceLocation("boss_tools", "textures/fluid_tank_fore.png");
    public static final int FLUID_TANK_WIDTH = 14;
    public static final int FLUID_TANK_HEIGHT = 48;

    public static boolean isHover(Rectangle2d bounds, double x, double y) {
        int left = bounds.getX();
        int right = left + bounds.getWidth();
        int top = bounds.getY();
        int bottom = top + bounds.getHeight();
        return (double)left <= x && x < (double)right && (double)top <= y && y < (double)bottom;
    }

    public static void drawArrow(MatrixStack matrixStack, int left, int top, double ratio) {
        GuiHelper.drawHorizontal(matrixStack, left, top, 24, 17, ARROW_PATH, ratio);
    }

    public static Rectangle2d getArrowBounds(int left, int top) {
        return new Rectangle2d(left, top, 24, 17);
    }

    public static void drawFire(MatrixStack matrixStack, int left, int top, double ratio) {
        GuiHelper.drawVertical(matrixStack, left, top, 14, 14, FIRE_PATH, ratio);
    }

    public static Rectangle2d getFireBounds(int left, int top) {
        return new Rectangle2d(left, top, 14, 14);
    }

    public static void drawOxygenTank(MatrixStack matrixStack, int left, int top, IOxygenStorage oxygenStorage) {
        GuiHelper.drawOxygenTank(matrixStack, left, top, oxygenStorage.getOxygenStoredRatio());
    }

    public static void drawOxygenTank(MatrixStack matrixStack, int left, int top, double ratio) {
        int maxHeight = 48;
        int scaledHeight = (int)Math.ceil((double)maxHeight * ratio);
        int offset = maxHeight - scaledHeight;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(OXYGEN_CONTENT_PATH);
        GuiHelper.drawTiledSprite(matrixStack, left, top + offset, 14, scaledHeight, 16, 16, 0.0f, 1.0f, 0.0f, 1.0f);
        GuiHelper.drawFluidTankOverlay(matrixStack, left, top);
    }

    public static Rectangle2d getOxygenTankBounds(int left, int top) {
        return new Rectangle2d(left, top, 14, 48);
    }

    public static void drawEnergy(MatrixStack matrixStack, int left, int top, IEnergyStorage energyStorage) {
        GuiHelper.drawEnergy(matrixStack, left, top, (double)energyStorage.getEnergyStored() / (double)energyStorage.getMaxEnergyStored());
    }

    public static void drawEnergy(MatrixStack matrixStack, int left, int top, double ratio) {
        GuiHelper.drawVertical(matrixStack, left, top, 24, 48, ENERGY_PATH, ratio);
    }

    public static void drawFuel(MatrixStack matrixStack, int left, int top, double ratio) {
        ResourceLocation full = new ResourceLocation("boss_tools", "textures/rocket_fuel_bar_full.png");
        GuiHelper.drawVertical(matrixStack, left, top, 48, 48, full, ratio);
    }

    public static Rectangle2d getEnergyBounds(int left, int top) {
        return new Rectangle2d(left, top, 24, 48);
    }

    public static Rectangle2d getBounds(int left, int top, int width, int height) {
        return new Rectangle2d(left, top, width, height);
    }

    public static void drawFluidTank(MatrixStack matrixStack, int left, int top, IFluidTank tank) {
        GuiHelper.drawFluidTank(matrixStack, left, top, tank.getFluid(), tank.getCapacity());
    }

    public static void drawFluidTank(MatrixStack matrixStack, int left, int top, FluidStack stack, int capacity) {
        if (stack != null && !stack.isEmpty() && capacity > 0) {
            int maxHeight = 48;
            int scaledHeight = (int)Math.ceil((double)maxHeight * ((double)stack.getAmount() / (double)capacity));
            int offset = maxHeight - scaledHeight;
            GuiHelper.drawFluid(matrixStack, left, top + offset, 14, scaledHeight, stack);
        }
        GuiHelper.drawFluidTankOverlay(matrixStack, left, top);
    }

    public static void drawFluidTankOverlay(MatrixStack matrixStack, int left, int top) {
        GuiHelper.drawVertical(matrixStack, left, top, 14, 48, FLUID_TANK_PATH, 1.0);
    }

    public static void drawFluid(MatrixStack matrixStack, int left, int top, int width, int height, FluidStack stack) {
        Fluid fluid = FluidUtil2.getFluid(stack);
        if (fluid == null) {
            return;
        }
        TextureAtlasSprite fluidStillSprite = GuiHelper.getStillFluidSprite(stack);
        FluidAttributes attributes = fluid.getAttributes();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        GuiHelper.setGLColorFromInt(attributes.getColor(stack));
        GuiHelper.drawTiledSprite(matrixStack, left, top, width, height, fluidStillSprite, 16, 16);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public static void drawRocketFluidTank(MatrixStack matrixStack, int left, int top, FluidStack stack, int capacity, int amount) {
        if (stack != null && !stack.isEmpty() && capacity > 0) {
            int maxHeight = 46;
            int scaledHeight = (int)Math.ceil((double)maxHeight * ((double)amount / (double)capacity));
            int offset = maxHeight - scaledHeight;
            GuiHelper.drawFluid(matrixStack, left, top + offset, 46, scaledHeight, stack);
        }
    }

    public static void drawFluidHorizontal(MatrixStack matrixStack, int left, int top, int width, int height, FluidStack stack, int capacity) {
        Fluid fluid = FluidUtil2.getFluid(stack);
        if (fluid == null) {
            return;
        }
        double ratio = (double)stack.getAmount() / (double)capacity;
        GuiHelper.drawFluid(matrixStack, left, top, (int)Math.ceil((double)width * ratio), height, stack);
    }

    public static void drawFluidVertical(MatrixStack matrixStack, int left, int top, int width, int height, FluidStack stack, int capacity) {
        Fluid fluid = FluidUtil2.getFluid(stack);
        if (fluid == null) {
            return;
        }
        double ratio = (double)stack.getAmount() / (double)capacity;
        int scaledHeight = (int)Math.ceil((double)height * ratio);
        int offset = height - scaledHeight;
        GuiHelper.drawFluid(matrixStack, left, top + offset, scaledHeight, height, stack);
    }

    public static void drawTiledSprite(MatrixStack matrixStack, int left, int top, int width, int height, TextureAtlasSprite sprite, int tileWidth, int tileHeight) {
        float uMin = sprite.func_94209_e();
        float uMax = sprite.func_94212_f();
        float vMin = sprite.func_94206_g();
        float vMax = sprite.func_94210_h();
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        GuiHelper.drawTiledSprite(matrixStack, left, top, width, height, tileWidth, tileHeight, uMin, uMax, vMin, vMax);
    }

    public static void drawTiledSprite(MatrixStack matrixStack, int left, int top, int width, int height, int tileWidth, int tileHeight, float uMin, float uMax, float vMin, float vMax) {
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        int xTileCount = width / tileWidth;
        int xRemainder = width - xTileCount * tileWidth;
        int yTileCount = height / tileWidth;
        int yRemainder = height - yTileCount * tileWidth;
        int yStart = top + height;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int tiledWidth = xTile == xTileCount ? xRemainder : tileWidth;
                int tiledHeight = yTile == yTileCount ? yRemainder : tileWidth;
                int x = left + xTile * tileWidth;
                int y = yStart - (yTile + 1) * tileHeight;
                if (tiledWidth <= 0 || tiledHeight <= 0) continue;
                int maskRight = tileWidth - tiledWidth;
                int maskTop = tileHeight - tiledHeight;
                GuiHelper.drawTextureWithMasking(matrix, x, y, tileWidth, tileHeight, maskTop, maskRight, 0.0f, uMin, uMax, vMin, vMax);
            }
        }
    }

    public static void drawTextureWithMasking(Matrix4f matrix, float left, float top, float tileWidth, float tileHeight, int maskTop, int maskRight, float zLevel, float uMin, float uMax, float vMin, float vMax) {
        uMax -= (float)maskRight / tileWidth * (uMax - uMin);
        vMax -= (float)maskTop / tileHeight * (vMax - vMin);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_227888_a_(matrix, left, top + tileHeight, zLevel).func_225583_a_(uMin, vMax).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, left + tileWidth - (float)maskRight, top + tileHeight, zLevel).func_225583_a_(uMax, vMax).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, left + tileWidth - (float)maskRight, top + (float)maskTop, zLevel).func_225583_a_(uMax, vMin).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, left, top + (float)maskTop, zLevel).func_225583_a_(uMin, vMin).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static TextureAtlasSprite getStillFluidSprite(FluidStack stack) {
        Fluid fluid = stack.getFluid();
        FluidAttributes attributes = fluid.getAttributes();
        ResourceLocation fluidStill = attributes.getStillTexture(stack);
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluidStill);
    }

    public static Rectangle2d getFluidTankBounds(int left, int top) {
        return new Rectangle2d(left, top, 14, 48);
    }

    public static Rectangle2d getRocketFluidTankBounds(int left, int top) {
        return new Rectangle2d(left, top, 48, 48);
    }

    public static void drawVertical(MatrixStack matrixStack, int left, int top, int width, int height, ResourceLocation resource, double ratio) {
        int ratioHeight = (int)Math.ceil((double)height * ratio);
        int remainHeight = height - ratioHeight;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resource);
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)left, (int)(top + remainHeight), (float)0.0f, (float)remainHeight, (int)width, (int)ratioHeight, (int)width, (int)height);
    }

    public static void drawVerticalReverse(MatrixStack matrixStack, int left, int top, int width, int height, ResourceLocation resource, double ratio) {
        int ratioHeight = (int)Math.ceil((double)height * ratio);
        int remainHeight = height - ratioHeight;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resource);
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)left, (int)top, (float)0.0f, (float)0.0f, (int)width, (int)remainHeight, (int)width, (int)height);
    }

    public static void drawHorizontal(MatrixStack matrixStack, int left, int top, int width, int height, ResourceLocation resource, double ratio) {
        int ratioWidth = (int)Math.ceil((double)width * ratio);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resource);
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)left, (int)top, (float)0.0f, (float)0.0f, (int)ratioWidth, (int)height, (int)width, (int)height);
    }

    public static void drawHorizontalReverse(MatrixStack matrixStack, int left, int top, int width, int height, ResourceLocation resource, double ratio) {
        int ratioWidth = (int)Math.ceil((double)width * ratio);
        int remainWidth = width - ratioWidth;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resource);
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(left + ratioWidth), (int)top, (float)ratioWidth, (float)0.0f, (int)remainWidth, (int)height, (int)width, (int)height);
    }

    public static void innerBlit(Matrix4f matrix, float x1, float x2, float y1, float y2, int blitOffset, float minU, float maxU, float minV, float maxV) {
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix, x1, y2, (float)blitOffset).func_225583_a_(minU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x2, y2, (float)blitOffset).func_225583_a_(maxU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x2, y1, (float)blitOffset).func_225583_a_(maxU, minV).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x1, y1, (float)blitOffset).func_225583_a_(minU, minV).func_181675_d();
        bufferbuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }

    public static void blit(MatrixStack matrixStack, float x, float y, float width, float height, float uOffset, float vOffset, float uWidth, float vHeight, int textureWidth, int textureHeight) {
        GuiHelper.innerBlit(matrixStack, x, x + width, y, y + height, 0, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    private static void innerBlit(MatrixStack matrixStack, float x1, float x2, float y1, float y2, int blitOffset, float uWidth, float vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight) {
        GuiHelper.innerBlit(matrixStack.func_227866_c_().func_227870_a_(), x1, x2, y1, y2, blitOffset, (uOffset + 0.0f) / (float)textureWidth, (uOffset + uWidth) / (float)textureWidth, (vOffset + 0.0f) / (float)textureHeight, (vOffset + vHeight) / (float)textureHeight);
    }

    public static void blit(MatrixStack matrixStack, float x, float y, float uOffset, float vOffset, float width, float height, int textureWidth, int textureHeight) {
        GuiHelper.blit(matrixStack, x, y, width, height, uOffset, vOffset, width, height, textureWidth, textureHeight);
    }

    private GuiHelper() {
    }
}

