/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.gui.screens.nasaworkbench;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.IContainerFactory;
import net.mrscauthd.boss_tools.ModInnet;
import net.mrscauthd.boss_tools.crafting.RocketPart;
import net.mrscauthd.boss_tools.crafting.WorkbenchingRecipe;
import net.mrscauthd.boss_tools.gui.helper.ContainerHelper;
import net.mrscauthd.boss_tools.gui.helper.GridPlacer;
import net.mrscauthd.boss_tools.gui.helper.RocketPartGridPlacer;
import net.mrscauthd.boss_tools.gui.screens.nasaworkbench.NasaWorkbenchResultSlot;
import net.mrscauthd.boss_tools.inventory.RocketPartsItemHandler;
import net.mrscauthd.boss_tools.machines.NASAWorkbenchBlock;

public class NasaWorkbenchGui {

    public static class GuiContainer
    extends Container {
        private NASAWorkbenchBlock.CustomTileEntity tileEntity;
        private CraftResultInventory resultInventory;
        private Slot resultSlot;
        private int partSlotStart = 0;
        private int partSlotEnd = 0;

        public GuiContainer(int id, PlayerInventory inv, NASAWorkbenchBlock.CustomTileEntity tileEntity) {
            super((ContainerType)ModInnet.NASA_WORKBENCH_GUI.get(), id);
            this.tileEntity = tileEntity;
            this.resultInventory = new CraftResultInventory(){

                public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
                    ItemStack stack = super.func_70298_a(p_70298_1_, p_70298_2_);
                    this.onExtractResult(stack);
                    return stack;
                }

                public ItemStack func_70304_b(int p_70304_1_) {
                    ItemStack stack = super.func_70304_b(p_70304_1_);
                    this.onExtractResult(stack);
                    return stack;
                }
            };
            this.resultSlot = this.func_75146_a(new NasaWorkbenchResultSlot((IInventory)this.resultInventory, 0, 133, 74, tileEntity));
            this.partSlotStart = this.field_75151_b.size();
            RocketPartsItemHandler partsItemHandler = tileEntity.getPartsItemHandler();
            GridPlacer placer = new GridPlacer();
            RocketPartGridPlacer.placeContainer(40, 18, 1, placer::placeBottom, (RocketPart)ModInnet.ROCKET_PART_NOSE.get(), partsItemHandler, arg_0 -> ((GuiContainer)this).func_75146_a(arg_0));
            RocketPartGridPlacer.placeContainer(31, 36, 2, placer::placeBottom, (RocketPart)ModInnet.ROCKET_PART_BODY.get(), partsItemHandler, arg_0 -> ((GuiContainer)this).func_75146_a(arg_0));
            RocketPartGridPlacer.placeContainer(31, 90, 1, placer::placeRight, (RocketPart)ModInnet.ROCKET_PART_TANK.get(), partsItemHandler, arg_0 -> ((GuiContainer)this).func_75146_a(arg_0));
            RocketPartGridPlacer.placeContainer(13, 90, 1, placer::placeBottom, (RocketPart)ModInnet.ROCKET_PART_FIN_LEFT.get(), partsItemHandler, arg_0 -> ((GuiContainer)this).func_75146_a(arg_0));
            RocketPartGridPlacer.placeContainer(67, 90, 1, placer::placeBottom, (RocketPart)ModInnet.ROCKET_PART_FIN_RIGHT.get(), partsItemHandler, arg_0 -> ((GuiContainer)this).func_75146_a(arg_0));
            RocketPartGridPlacer.placeContainer(40, 108, 1, placer::placeBottom, (RocketPart)ModInnet.ROCKET_PART_ENGINE.get(), partsItemHandler, arg_0 -> ((GuiContainer)this).func_75146_a(arg_0));
            this.partSlotEnd = this.field_75151_b.size();
            ContainerHelper.addInventorySlots(this, inv, 8, 142, arg_0 -> ((GuiContainer)this).func_75146_a(arg_0));
        }

        private void onExtractResult(ItemStack stack) {
            NASAWorkbenchBlock.CustomTileEntity tileEntity = this.getTileEntity();
            if (!stack.func_190926_b() && tileEntity.cacheRecipes() != null) {
                tileEntity.consumeIngredient();
            }
        }

        public void func_75142_b() {
            super.func_75142_b();
            WorkbenchingRecipe recipe = this.getTileEntity().cacheRecipes();
            this.resultSlot.func_75215_d(recipe != null ? recipe.getOutput() : ItemStack.field_190927_a);
        }

        public boolean func_75145_c(PlayerEntity player) {
            return !this.getTileEntity().func_145837_r();
        }

        public ItemStack func_82846_b(PlayerEntity playerIn, int slotNumber) {
            if (this.partSlotStart <= slotNumber && slotNumber < this.partSlotEnd) {
                return ContainerHelper.transferStackInSlot((Container)this, playerIn, slotNumber, slotNumber - this.partSlotStart, (IInventory)this.getTileEntity(), (arg_0, arg_1, arg_2, arg_3) -> ((GuiContainer)this).func_75135_a(arg_0, arg_1, arg_2, arg_3));
            }
            if (slotNumber == this.resultSlot.field_75222_d) {
                Slot slot = this.func_75139_a(slotNumber);
                ItemStack prev = slot.func_75211_c().func_77946_l();
                ItemStack itemStack = ContainerHelper.transferStackInSlot(this, playerIn, slotNumber, (IInventory)this.getTileEntity(), (arg_0, arg_1, arg_2, arg_3) -> ((GuiContainer)this).func_75135_a(arg_0, arg_1, arg_2, arg_3));
                if (slotNumber == this.resultSlot.field_75222_d) {
                    ItemStack next = slot.func_75211_c().func_77946_l();
                    if (!prev.func_190926_b()) {
                        int nextSize;
                        int n = nextSize = next.func_190926_b() ? 0 : next.func_190916_E();
                        if (nextSize > 0) {
                            playerIn.func_71019_a(next, false);
                            slot.func_75215_d(ItemStack.field_190927_a);
                        }
                    }
                    this.onExtractResult(prev);
                }
                return itemStack;
            }
            return ContainerHelper.transferStackInSlot(this, playerIn, slotNumber, (IInventory)this.getTileEntity(), (arg_0, arg_1, arg_2, arg_3) -> ((GuiContainer)this).func_75135_a(arg_0, arg_1, arg_2, arg_3));
        }

        public NASAWorkbenchBlock.CustomTileEntity getTileEntity() {
            return this.tileEntity;
        }

        public CraftResultInventory getResultInventory() {
            return this.resultInventory;
        }

        public Slot getResultSlot() {
            return this.resultSlot;
        }
    }

    public static class GuiContainerFactory
    implements IContainerFactory<GuiContainer> {
        public GuiContainer create(int id, PlayerInventory inv, PacketBuffer extraData) {
            BlockPos pos = extraData.func_179259_c();
            NASAWorkbenchBlock.CustomTileEntity tileEntity = (NASAWorkbenchBlock.CustomTileEntity)inv.field_70458_d.field_70170_p.func_175625_s(pos);
            return new GuiContainer(id, inv, tileEntity);
        }
    }
}

