/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.gui.screens.oxygenbubbledistributor;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.NumberFormat;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.IFluidTank;
import net.mrscauthd.boss_tools.BossToolsMod;
import net.mrscauthd.boss_tools.gauge.GaugeTextHelper;
import net.mrscauthd.boss_tools.gauge.GaugeValueHelper;
import net.mrscauthd.boss_tools.gui.helper.GuiHelper;
import net.mrscauthd.boss_tools.gui.helper.ImageButtonPlacer;
import net.mrscauthd.boss_tools.gui.screens.oxygenbubbledistributor.OxygenBubbleDistributorGui;
import net.mrscauthd.boss_tools.machines.OxygenBubbleDistributorBlock;
import net.mrscauthd.boss_tools.util.Rectangle2d;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class OxygenBubbleDistributorGuiWindow
extends ContainerScreen<OxygenBubbleDistributorGui.GuiContainer> {
    public static final ResourceLocation texture = new ResourceLocation("boss_tools", "textures/screens/oxygen_bubble_distributor_gui.png");
    public static final int INPUT_TANK_LEFT = 9;
    public static final int INPUT_TANK_TOP = 21;
    public static final int OUTPUT_TANK_LEFT = 75;
    public static final int OUTPUT_TANK_TOP = 21;
    public static final int ENERGY_LEFT = 144;
    public static final int ENERGY_TOP = 21;
    public static final int ARROW_LEFT = 48;
    public static final int ARROW_TOP = 36;
    private OxygenBubbleDistributorBlock.CustomTileEntity tileEntity;
    private boolean cachedWorkingAreaVisible = true;
    public ImageButtonPlacer workingAreaVisibleButton;
    public ImageButtonPlacer button_plus;
    public ImageButtonPlacer button_minus;
    private static ResourceLocation HideButton = new ResourceLocation("boss_tools", "textures/buttons/technik_button.png");
    private static ResourceLocation Button1 = new ResourceLocation("boss_tools", "textures/buttons/technik_button_plus.png");
    private static ResourceLocation Button2 = new ResourceLocation("boss_tools", "textures/buttons/technik_button_minus.png");

    public OxygenBubbleDistributorGuiWindow(OxygenBubbleDistributorGui.GuiContainer container, PlayerInventory inventory, ITextComponent text) {
        super((Container)container, inventory, text);
        this.tileEntity = container.getTileEntity();
        this.field_146999_f = 177;
        this.field_147000_g = 172;
        this.field_238745_s_ = this.field_147000_g - 92;
    }

    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(ms);
        this.updateWorkingAreaVisibleButton();
        super.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        this.func_230459_a_(ms, mouseX, mouseY);
        OxygenBubbleDistributorBlock.CustomTileEntity tileEntity = this.getTileEntity();
        if (GuiHelper.isHover(this.getInputTankBounds(), mouseX, mouseY)) {
            this.func_238652_a_(ms, (ITextComponent)GaugeTextHelper.getStorageText(GaugeValueHelper.getFluid((IFluidTank)tileEntity.getInputTank())).build(), mouseX, mouseY);
        } else if (GuiHelper.isHover(this.getOutputTankBounds(), mouseX, mouseY)) {
            this.func_238652_a_(ms, (ITextComponent)GaugeTextHelper.getStorageText(GaugeValueHelper.getOxygen(tileEntity.getOutputTank())).build(), mouseX, mouseY);
        } else if (GuiHelper.isHover(this.getEnergyBounds(), mouseX, mouseY)) {
            this.func_238652_a_(ms, (ITextComponent)GaugeTextHelper.getStorageText(GaugeValueHelper.getEnergy(tileEntity)).build(), mouseX, mouseY);
        }
        if (GuiHelper.isHover(this.getButtonBounds(-20, 4, 20, 21), mouseX, mouseY)) {
            this.button_plus.setTexture(new ResourceLocation("boss_tools", "textures/buttons/technik_button_plus_2.png"));
        } else {
            this.button_plus.setTexture(new ResourceLocation("boss_tools", "textures/buttons/technik_button_plus.png"));
        }
        if (GuiHelper.isHover(this.getButtonBounds(-20, 25, 20, 20), mouseX, mouseY)) {
            this.button_minus.setTexture(new ResourceLocation("boss_tools", "textures/buttons/technik_button_minus_2.png"));
        } else {
            this.button_minus.setTexture(new ResourceLocation("boss_tools", "textures/buttons/technik_button_minus.png"));
        }
        if (GuiHelper.isHover(this.getButtonBounds(-20, -22, 34, 20), mouseX, mouseY)) {
            this.workingAreaVisibleButton.setTexture(new ResourceLocation("boss_tools", "textures/buttons/technik_button_2.png"));
        } else {
            this.workingAreaVisibleButton.setTexture(new ResourceLocation("boss_tools", "textures/buttons/technik_button.png"));
        }
    }

    protected void func_230450_a_(MatrixStack ms, float par1, int par2, int par3) {
        OxygenBubbleDistributorBlock.CustomTileEntity tileEntity = this.getTileEntity();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(texture);
        AbstractGui.func_238463_a_((MatrixStack)ms, (int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (int)this.field_146999_f, (int)this.field_147000_g);
        GuiHelper.drawEnergy(ms, this.field_147003_i + 144, this.field_147009_r + 21, tileEntity.getPrimaryEnergyStorage());
        GuiHelper.drawFluidTank(ms, this.field_147003_i + 9, this.field_147009_r + 21, (IFluidTank)tileEntity.getInputTank());
        GuiHelper.drawOxygenTank(ms, this.field_147003_i + 75, this.field_147009_r + 21, tileEntity.getOutputTank());
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.button_plus = (ImageButtonPlacer)this.func_230480_a_((Widget)new ImageButtonPlacer(this.field_147003_i - 20, this.field_147009_r + 5, 20, 20, 0, 0, 0, Button1, 20, 20, p_2130901 -> {
            BlockPos pos = this.getTileEntity().func_174877_v();
            BossToolsMod.PACKET_HANDLER.sendToServer((Object)new OxygenBubbleDistributorBlock.ChangeRangeMessage(pos, true));
        }));
        this.button_minus = (ImageButtonPlacer)this.func_230480_a_((Widget)new ImageButtonPlacer(this.field_147003_i - 20, this.field_147009_r + 25, 20, 20, 0, 0, 0, Button2, 20, 20, p_2130901 -> {
            BlockPos pos = this.getTileEntity().func_174877_v();
            BossToolsMod.PACKET_HANDLER.sendToServer((Object)new OxygenBubbleDistributorBlock.ChangeRangeMessage(pos, false));
        }));
        this.workingAreaVisibleButton = (ImageButtonPlacer)this.func_230480_a_((Widget)new ImageButtonPlacer(this.field_147003_i - 20, this.field_147009_r - 22, 34, 20, 0, 0, 0, HideButton, 34, 20, e -> {
            BlockPos pos = this.getTileEntity().func_174877_v();
            BossToolsMod.PACKET_HANDLER.sendToServer((Object)new OxygenBubbleDistributorBlock.ChangeWorkingAreaVisibleMessage(pos, !this.cachedWorkingAreaVisible));
        }));
    }

    protected void func_230451_b_(MatrixStack ms, int mouseX, int mouseY) {
        super.func_230451_b_(ms, mouseX, mouseY);
        OxygenBubbleDistributorBlock.CustomTileEntity tileEntity = this.getTileEntity();
        double range = tileEntity.getRange();
        NumberFormat numberInstance = NumberFormat.getNumberInstance();
        numberInstance.setMaximumFractionDigits(2);
        String rangeToString = numberInstance.format(range * 2.0 + 1.0);
        TranslationTextComponent workingAreaText = new TranslationTextComponent("gui.boss_tools.oxygen_bubble_distributor.workingarea.text", new Object[]{rangeToString, rangeToString, rangeToString});
        int sideWidth = 2;
        int sidePadding = 2;
        int workingAreaHeight = 25;
        int workingAreaLeft = this.workingAreaVisibleButton.field_230690_l_ + this.workingAreaVisibleButton.func_230998_h_() - this.field_147003_i;
        int workingAreaTop = -workingAreaHeight;
        int workingAreaOffsetX = workingAreaLeft;
        int textwidth = 12;
        if (range * 2.0 + 1.0 > 9.0) {
            this.field_230706_i_.func_110434_K().func_110577_a(new ResourceLocation("boss_tools", "textures/buttons/oxygen_range_layer.png"));
            AbstractGui.func_238463_a_((MatrixStack)ms, (int)(workingAreaOffsetX + 1), (int)workingAreaTop, (float)0.0f, (float)0.0f, (int)150, (int)25, (int)150, (int)25);
            textwidth = 13;
        } else {
            this.field_230706_i_.func_110434_K().func_110577_a(new ResourceLocation("boss_tools", "textures/buttons/oxygen_range_small_layer.png"));
            AbstractGui.func_238463_a_((MatrixStack)ms, (int)(workingAreaOffsetX + 1), (int)workingAreaTop, (float)0.0f, (float)0.0f, (int)140, (int)25, (int)140, (int)25);
            textwidth = 17;
        }
        this.field_230712_o_.func_243248_b(ms, (ITextComponent)workingAreaText, (float)(workingAreaLeft + sideWidth + sidePadding + textwidth), (float)(workingAreaTop + 9), 0x339900);
        GL11.glPushMatrix();
        double oyxgenScale = 0.8;
        GL11.glScaled((double)oyxgenScale, (double)oyxgenScale, (double)oyxgenScale);
        IFormattableTextComponent oxygenText = GaugeTextHelper.getUsingText2(GaugeValueHelper.getOxygen(tileEntity.getOxygenUsing(range)), tileEntity.getMaxTimer()).build();
        int oxygenWidth = this.field_230712_o_.func_238414_a_((ITextProperties)oxygenText);
        this.field_230712_o_.func_243248_b(ms, (ITextComponent)oxygenText, (float)((int)((double)(this.field_146999_f - 5) / oyxgenScale) - oxygenWidth), (float)((int)((double)this.field_238745_s_ / oyxgenScale)), 0x333333);
        GL11.glPopMatrix();
        String prefix = "gui.boss_tools.oxygen_bubble_distributor.workingarea.";
        String method = this.cachedWorkingAreaVisible ? "hide" : "show";
        this.field_230712_o_.func_243248_b(ms, (ITextComponent)new TranslationTextComponent(prefix + method), (float)(workingAreaLeft + sideWidth + sidePadding + (this.cachedWorkingAreaVisible ? -30 : -32)), (float)(workingAreaTop + 9), 0x339900);
    }

    private void updateWorkingAreaVisibleButton() {
        boolean next = this.getTileEntity().isWorkingAreaVisible();
        if (this.cachedWorkingAreaVisible != next) {
            this.cachedWorkingAreaVisible = next;
        }
    }

    public OxygenBubbleDistributorBlock.CustomTileEntity getTileEntity() {
        return this.tileEntity;
    }

    public Rectangle2d getInputTankBounds() {
        return GuiHelper.getFluidTankBounds(this.field_147003_i + 9, this.field_147009_r + 21);
    }

    public Rectangle2d getOutputTankBounds() {
        return GuiHelper.getFluidTankBounds(this.field_147003_i + 75, this.field_147009_r + 21);
    }

    public Rectangle2d getEnergyBounds() {
        return GuiHelper.getEnergyBounds(this.field_147003_i + 144, this.field_147009_r + 21);
    }

    public Rectangle2d getButtonBounds(int left, int top, int width, int height) {
        return GuiHelper.getBounds(this.field_147003_i + left, this.field_147009_r + top, width, height);
    }
}

