/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.util.ThreeConsumer;
import net.minecraftforge.registries.ForgeRegistries;
import net.mrscauthd.boss_tools.ModInnet;
import net.mrscauthd.boss_tools.capability.OxygenUtil;
import net.mrscauthd.boss_tools.crafting.BlastingRecipe;
import net.mrscauthd.boss_tools.crafting.BossToolsRecipeTypes;
import net.mrscauthd.boss_tools.crafting.CompressingRecipe;
import net.mrscauthd.boss_tools.crafting.FuelRefiningRecipe;
import net.mrscauthd.boss_tools.crafting.GeneratingRecipe;
import net.mrscauthd.boss_tools.crafting.OxygenBubbleDistributorRecipe;
import net.mrscauthd.boss_tools.crafting.OxygenLoaderRecipe;
import net.mrscauthd.boss_tools.crafting.RocketPart;
import net.mrscauthd.boss_tools.crafting.WorkbenchingRecipe;
import net.mrscauthd.boss_tools.events.Methodes;
import net.mrscauthd.boss_tools.fluid.FluidUtil2;
import net.mrscauthd.boss_tools.gauge.GaugeTextHelper;
import net.mrscauthd.boss_tools.gauge.GaugeValueHelper;
import net.mrscauthd.boss_tools.gui.helper.GridPlacer;
import net.mrscauthd.boss_tools.gui.helper.GuiHelper;
import net.mrscauthd.boss_tools.gui.helper.IPlacer;
import net.mrscauthd.boss_tools.gui.helper.RocketPartGridPlacer;
import net.mrscauthd.boss_tools.gui.screens.blastfurnace.BlastFurnaceGui;
import net.mrscauthd.boss_tools.gui.screens.blastfurnace.BlastFurnaceGuiWindow;
import net.mrscauthd.boss_tools.gui.screens.coalgenerator.CoalGeneratorGui;
import net.mrscauthd.boss_tools.gui.screens.coalgenerator.CoalGeneratorGuiWindow;
import net.mrscauthd.boss_tools.gui.screens.compressor.CompressorGui;
import net.mrscauthd.boss_tools.gui.screens.compressor.CompressorGuiWindow;
import net.mrscauthd.boss_tools.gui.screens.fuelrefinery.FuelRefineryGui;
import net.mrscauthd.boss_tools.gui.screens.fuelrefinery.FuelRefineryGuiWindow;
import net.mrscauthd.boss_tools.gui.screens.nasaworkbench.NasaWorkbenchGui;
import net.mrscauthd.boss_tools.gui.screens.nasaworkbench.NasaWorkbenchGuiWindow;
import net.mrscauthd.boss_tools.gui.screens.oxygenbubbledistributor.OxygenBubbleDistributorGui;
import net.mrscauthd.boss_tools.gui.screens.oxygenbubbledistributor.OxygenBubbleDistributorGuiWindow;
import net.mrscauthd.boss_tools.gui.screens.oxygenloader.OxygenLoaderGui;
import net.mrscauthd.boss_tools.gui.screens.oxygenloader.OxygenLoaderGuiWindow;
import net.mrscauthd.boss_tools.gui.screens.planetselection.PlanetSelectionGuiWindow;
import net.mrscauthd.boss_tools.gui.screens.rocket.RocketGui;
import net.mrscauthd.boss_tools.jei.jeiguihandlers.BlastFurnaceGuiContainerHandler;
import net.mrscauthd.boss_tools.jei.jeiguihandlers.CoalGeneratorGuiContainerHandler;
import net.mrscauthd.boss_tools.jei.jeiguihandlers.CompressorGuiContainerHandler;
import net.mrscauthd.boss_tools.jei.jeiguihandlers.PlanetSlecetionGuiJeiHandler;
import net.mrscauthd.boss_tools.machines.NASAWorkbenchBlock;
import net.mrscauthd.boss_tools.util.Rectangle2d;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    public static IJeiHelpers jeiHelper;
    private Map<Fluid, List<ItemStack>> fluidFullItemStacks;
    private List<ItemStack> oxygenFullItemStacks;
    private List<Fluid> fuelTagFluids;

    public List<ItemStack> getFluidFullItemStacks(Fluid fluid) {
        return this.fluidFullItemStacks.computeIfAbsent(fluid, this::generateFluidFullIngredients);
    }

    public List<ItemStack> getFluidFullItemStacks(Collection<Fluid> fluids) {
        return fluids.stream().flatMap(f -> this.getFluidFullItemStacks((Fluid)f).stream()).collect(Collectors.toList());
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("boss_tools", "default");
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        int inventorySlotCount = 36;
        registration.addRecipeTransferHandler(OxygenLoaderGui.GuiContainer.class, OxygenLoaderJeiCategory.Uid, 0, 1, 0, inventorySlotCount);
        registration.addRecipeTransferHandler(OxygenBubbleDistributorGui.GuiContainer.class, OxygenBubbleDistributorJeiCategory.Uid, 0, 1, 0, inventorySlotCount);
        registration.addRecipeTransferHandler(CoalGeneratorGui.GuiContainer.class, CoalGeneratorJeiCategory.Uid, 0, 1, 1, inventorySlotCount);
        int blastInventoryStartIndex = 3;
        registration.addRecipeTransferHandler(BlastFurnaceGui.GuiContainer.class, BlastingFurnaceJeiCategory.Uid, 0, 1, blastInventoryStartIndex, inventorySlotCount);
        registration.addRecipeTransferHandler(BlastFurnaceGui.GuiContainer.class, VanillaRecipeCategoryUid.FUEL, 2, 1, blastInventoryStartIndex, inventorySlotCount);
        registration.addRecipeTransferHandler(CompressorGui.GuiContainer.class, CompressorJeiCategory.Uid, 0, 1, 2, inventorySlotCount);
        int workbenchPartSlotStart = 1;
        int workbenchPartSlotCount = NASAWorkbenchBlock.getBasicPartSlots();
        registration.addRecipeTransferHandler(NasaWorkbenchGui.GuiContainer.class, NASAWorkbenchJeiCategory.Uid, workbenchPartSlotStart, workbenchPartSlotCount, workbenchPartSlotStart + workbenchPartSlotCount, inventorySlotCount);
        registration.addRecipeTransferHandler(FuelRefineryGui.GuiContainer.class, FuelRefineryJeiCategory.Uid, 0, 1, 0, inventorySlotCount);
        registration.addRecipeTransferHandler(RocketGui.GuiContainer.class, Tier1RocketJeiCategory.Uid, 0, 1, 0, inventorySlotCount);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(NasaWorkbenchGuiWindow.class, 108, 49, 14, 14, new ResourceLocation[]{NASAWorkbenchJeiCategory.Uid});
        registration.addGuiContainerHandler(CoalGeneratorGuiWindow.class, (IGuiContainerHandler)new CoalGeneratorGuiContainerHandler());
        registration.addRecipeClickArea(FuelRefineryGuiWindow.class, 48, 36, 24, 17, new ResourceLocation[]{FuelRefineryJeiCategory.Uid});
        registration.addGuiContainerHandler(BlastFurnaceGuiWindow.class, (IGuiContainerHandler)new BlastFurnaceGuiContainerHandler());
        registration.addGuiContainerHandler(CompressorGuiWindow.class, (IGuiContainerHandler)new CompressorGuiContainerHandler());
        registration.addRecipeClickArea(OxygenLoaderGuiWindow.class, 48, 36, 24, 17, new ResourceLocation[]{OxygenLoaderJeiCategory.Uid});
        registration.addRecipeClickArea(OxygenBubbleDistributorGuiWindow.class, 48, 36, 24, 17, new ResourceLocation[]{OxygenBubbleDistributorJeiCategory.Uid});
        registration.addGuiContainerHandler(PlanetSelectionGuiWindow.class, (IGuiContainerHandler)new PlanetSlecetionGuiJeiHandler());
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        jeiHelper = registration.getJeiHelpers();
        registration.addRecipeCategories(new IRecipeCategory[]{new OxygenLoaderJeiCategory(this, jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new OxygenBubbleDistributorJeiCategory(this, jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CoalGeneratorJeiCategory(jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new NASAWorkbenchJeiCategory(jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new BlastingFurnaceJeiCategory(jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new Tier1RocketJeiCategory(jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new Tier2RocketJeiCategory(jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new Tier3RocketJeiCategory(jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CompressorJeiCategory(jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new FuelRefineryJeiCategory(this, jeiHelper.getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RoverJeiCategory(jeiHelper.getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.fluidFullItemStacks = new HashMap<Fluid, List<ItemStack>>();
        this.oxygenFullItemStacks = this.generateOxygenLoadingItems();
        this.fuelTagFluids = this.generateFuelTagFluids();
        List<FuelLoadingRecipe> fuelLoadingRecipes = this.generateFuelLoadingRecipes();
        registration.addRecipes(this.generateOxygenLoaderRecipes(), OxygenLoaderJeiCategory.Uid);
        registration.addRecipes(this.generateOxygenBubbleDistributorRecipes(), OxygenBubbleDistributorJeiCategory.Uid);
        registration.addRecipes(this.generateGeneratorRecipes(), CoalGeneratorJeiCategory.Uid);
        registration.addRecipes(this.generateWorkbenchRecipes(), NASAWorkbenchJeiCategory.Uid);
        registration.addRecipes(this.generateBlastingFurnaceRecipes(), BlastingFurnaceJeiCategory.Uid);
        registration.addRecipes(fuelLoadingRecipes, Tier1RocketJeiCategory.Uid);
        registration.addRecipes(fuelLoadingRecipes, Tier2RocketJeiCategory.Uid);
        registration.addRecipes(fuelLoadingRecipes, Tier3RocketJeiCategory.Uid);
        registration.addRecipes(fuelLoadingRecipes, RoverJeiCategory.Uid);
        registration.addRecipes(this.generateCompressingRecipes(), CompressorJeiCategory.Uid);
        registration.addRecipes(this.generateFuelMakerRecipes(), FuelRefineryJeiCategory.Uid);
        String oilDescriptionKey = "jei.tooltip.boss_tools.oil";
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)ModInnet.OIL_BUCKET.get(), 1), VanillaTypes.ITEM, new String[]{oilDescriptionKey});
        registration.addIngredientInfo((Object)new FluidStack((Fluid)ModInnet.OIL_STILL.get(), 1000), VanillaTypes.FLUID, new String[]{oilDescriptionKey});
    }

    private List<ItemStack> generateOxygenLoadingItems() {
        return ForgeRegistries.ITEMS.getValues().stream().map(ItemStack::new).filter(OxygenUtil::canReceive).map(OxygenUtil::makeFull).collect(Collectors.toList());
    }

    private List<OxygenLoaderRecipe> generateOxygenLoaderRecipes() {
        return BossToolsRecipeTypes.OXYGENLOADER.getRecipes((World)Minecraft.func_71410_x().field_71441_e);
    }

    private List<OxygenBubbleDistributorRecipe> generateOxygenBubbleDistributorRecipes() {
        return BossToolsRecipeTypes.OXYGENBUBBLEDISTRIBUTOR.getRecipes((World)Minecraft.func_71410_x().field_71441_e);
    }

    private List<GeneratingRecipe> generateGeneratorRecipes() {
        return BossToolsRecipeTypes.GENERATING.getRecipes((World)Minecraft.func_71410_x().field_71441_e);
    }

    private List<WorkbenchingRecipe> generateWorkbenchRecipes() {
        return BossToolsRecipeTypes.WORKBENCHING.getRecipes((World)Minecraft.func_71410_x().field_71441_e);
    }

    private List<BlastingRecipe> generateBlastingFurnaceRecipes() {
        return BossToolsRecipeTypes.BLASTING.getRecipes((World)Minecraft.func_71410_x().field_71441_e);
    }

    private List<CompressingRecipe> generateCompressingRecipes() {
        return BossToolsRecipeTypes.COMPRESSING.getRecipes((World)Minecraft.func_71410_x().field_71441_e);
    }

    private List<ItemStack> generateFluidFullIngredients(Fluid fluid) {
        return ForgeRegistries.ITEMS.getValues().stream().map(i -> new ItemStack((IItemProvider)i)).filter(is -> FluidUtil2.canFill(is, fluid)).map(is -> FluidUtil2.makeFull(is, fluid)).collect(Collectors.toList());
    }

    private List<FuelRefiningRecipe> generateFuelMakerRecipes() {
        return BossToolsRecipeTypes.FUELREFINING.getRecipes((World)Minecraft.func_71410_x().field_71441_e);
    }

    private List<Fluid> generateFuelTagFluids() {
        return ForgeRegistries.FLUIDS.getValues().stream().filter(f -> f.func_207193_c(f.func_207188_f()) && Methodes.tagCheck(f, ModInnet.FLUID_VEHICLE_FUEL_TAG)).collect(Collectors.toList());
    }

    private List<FuelLoadingRecipe> generateFuelLoadingRecipes() {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (Fluid fluid : this.fuelTagFluids) {
            itemStacks.add(new ItemStack((IItemProvider)fluid.func_204524_b()));
        }
        FuelLoadingRecipe recipe = new FuelLoadingRecipe(itemStacks, this.fuelTagFluids);
        ArrayList<FuelLoadingRecipe> recipes = new ArrayList<FuelLoadingRecipe>();
        recipes.add(recipe);
        return recipes;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModInnet.OXYGEN_LOADER_BLOCK.get()), new ResourceLocation[]{OxygenLoaderJeiCategory.Uid});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModInnet.OXYGEN_BUBBLE_DISTRIBUTOR_BLOCK.get()), new ResourceLocation[]{OxygenBubbleDistributorJeiCategory.Uid});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModInnet.COAL_GENERATOR_BLOCK.get()), new ResourceLocation[]{CoalGeneratorJeiCategory.Uid});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModInnet.NASA_WORKBENCH_ITEM.get()), new ResourceLocation[]{NASAWorkbenchJeiCategory.Uid});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModInnet.BLAST_FURNACE_BLOCK.get()), new ResourceLocation[]{BlastingFurnaceJeiCategory.Uid, VanillaRecipeCategoryUid.FUEL});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModInnet.TIER_1_ROCKET_ITEM.get()), new ResourceLocation[]{Tier1RocketJeiCategory.Uid});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModInnet.TIER_2_ROCKET_ITEM.get()), new ResourceLocation[]{Tier2RocketJeiCategory.Uid});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModInnet.TIER_3_ROCKET_ITEM.get()), new ResourceLocation[]{Tier3RocketJeiCategory.Uid});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModInnet.COMPRESSOR_BLOCK.get()), new ResourceLocation[]{CompressorJeiCategory.Uid});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModInnet.FUEL_REFINERY_BLOCK.get()), new ResourceLocation[]{FuelRefineryJeiCategory.Uid});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModInnet.ROVER_ITEM.get()), new ResourceLocation[]{RoverJeiCategory.Uid});
    }

    public static int placeRcketParts(int slot, int left, int top, int mod, IPlacer placer, RocketPart part, IRecipeLayout iRecipeLayout, WorkbenchingRecipe recipe) {
        IGuiItemStackGroup stacks = iRecipeLayout.getItemStacks();
        List<Ingredient> ingredients = recipe.getParts().get((Object)part);
        return RocketPartGridPlacer.place(slot, left, top, mod, placer, part, (ThreeConsumer<Integer, Integer, Rectangle2d>)((ThreeConsumer)(i, s, bounds) -> {
            Ingredient ingredient = ingredients != null && i < ingredients.size() ? (Ingredient)ingredients.get((int)i) : Ingredient.field_193370_a;
            stacks.init(s.intValue(), true, bounds.getX(), bounds.getY());
            stacks.set(s.intValue(), (List)Lists.newArrayList((Object[])ingredient.func_193365_a()));
        }));
    }

    public static IDrawableStatic createFireStatic(IGuiHelper guiHelper) {
        return JeiPlugin.drawableBuilder(guiHelper, GuiHelper.FIRE_PATH, 14, 14).build();
    }

    public static IDrawableAnimated createFireAnimated(IGuiHelper guiHelper) {
        return JeiPlugin.createFireAnimated(guiHelper, 200);
    }

    public static IDrawableAnimated createFireAnimated(IGuiHelper guiHelper, int ticks) {
        return JeiPlugin.createFireAnimated(guiHelper, JeiPlugin.createFireStatic(guiHelper), ticks);
    }

    public static IDrawableAnimated createFireAnimated(IGuiHelper guiHelper, IDrawableStatic fireStatic, int ticks) {
        return guiHelper.createAnimatedDrawable(fireStatic, ticks, IDrawableAnimated.StartDirection.TOP, true);
    }

    public static IDrawableBuilder drawableBuilder(IGuiHelper guiHelper, ResourceLocation path, int width, int height) {
        return guiHelper.drawableBuilder(path, 0, 0, width, height).setTextureSize(width, height);
    }

    public static LoadingCache<Integer, IDrawableAnimated> createFires(final IGuiHelper guiHelper) {
        return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer time) {
                return JeiPlugin.drawableBuilder(guiHelper, GuiHelper.FIRE_PATH, 14, 14).buildAnimated(time.intValue(), IDrawableAnimated.StartDirection.TOP, true);
            }
        });
    }

    public static LoadingCache<Integer, IDrawableAnimated> createArrows(final IGuiHelper guiHelper) {
        return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer time) {
                return JeiPlugin.drawableBuilder(guiHelper, GuiHelper.ARROW_PATH, 24, 17).buildAnimated(time.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public static LoadingCache<Integer, IDrawableAnimated> createEnergies(final IGuiHelper guiHelper, final boolean inverted) {
        return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer time) {
                return JeiPlugin.drawableBuilder(guiHelper, GuiHelper.ENERGY_PATH, 24, 48).buildAnimated(time.intValue(), inverted ? IDrawableAnimated.StartDirection.TOP : IDrawableAnimated.StartDirection.BOTTOM, inverted);
            }
        });
    }

    public static LoadingCache<Integer, IDrawableAnimated> createUsingEnergies(IGuiHelper guiHelper) {
        return JeiPlugin.createEnergies(guiHelper, true);
    }

    public static LoadingCache<Integer, IDrawableAnimated> createGeneratingEnergies(IGuiHelper guiHelper) {
        return JeiPlugin.createEnergies(guiHelper, false);
    }

    public static void drawText(MatrixStack matrixStack, IDrawable background, String text) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int stringWidth = fontRenderer.func_78256_a(text);
        float f = background.getWidth() - 5 - stringWidth;
        int n = background.getHeight();
        fontRenderer.getClass();
        fontRenderer.func_238421_b_(matrixStack, text, f, (float)(n - 9 - 5), 0x808080);
    }

    public static void drawTextTime(MatrixStack matrixStack, IDrawable background, int ticks) {
        NumberFormat numberInstance = NumberFormat.getNumberInstance();
        numberInstance.setMaximumFractionDigits(2);
        String text = numberInstance.format((float)ticks / 20.0f) + "s";
        JeiPlugin.drawText(matrixStack, background, text);
    }

    public static class RoverJeiCategory
    implements IRecipeCategory<FuelLoadingRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("boss_tools", "rovercategory");
        private final String title;
        private final IDrawable background;
        private final IDrawable fluidOverlay;

        public RoverJeiCategory(IGuiHelper guiHelper) {
            this.title = "Rover";
            this.background = guiHelper.createDrawable(new ResourceLocation("boss_tools", "textures/jei/rover_jei.png"), 0, 0, 144, 84);
            this.fluidOverlay = guiHelper.drawableBuilder(GuiHelper.FLUID_TANK_PATH, 0, 0, 14, 48).setTextureSize(14, 48).build();
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends FuelLoadingRecipe> getRecipeClass() {
            return FuelLoadingRecipe.class;
        }

        public String getTitle() {
            return this.title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public int getCapacity() {
            return 3000;
        }

        public void setIngredients(FuelLoadingRecipe recipe, IIngredients iIngredients) {
            iIngredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getItemStacks()));
            iIngredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getFluidStacks(this.getCapacity())));
        }

        public void setRecipe(IRecipeLayout iRecipeLayout, FuelLoadingRecipe recipe, IIngredients iIngredients) {
            IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
            itemStacks.init(0, true, 7, 59);
            itemStacks.set(0, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
            IGuiFluidStackGroup fluidStacks = iRecipeLayout.getFluidStacks();
            fluidStacks.init(0, true, 9, 8, 14, 48, this.getCapacity(), false, this.fluidOverlay);
            fluidStacks.set(0, (List)iIngredients.getInputs(VanillaTypes.FLUID).get(0));
        }
    }

    public static class FuelRefineryJeiCategory
    implements IRecipeCategory<FuelRefiningRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("boss_tools", "fuelmakercategory");
        public static final int INPUT_TANK_LEFT = 8;
        public static final int INPUT_TANK_TOP = 8;
        public static final int OUTPUT_TANK_LEFT = 74;
        public static final int OUTPUT_TANK_TOP = 8;
        public static final int ENERGY_LEFT = 114;
        public static final int ENERGY_TOP = 8;
        private final JeiPlugin plugin;
        private final String title;
        private final IDrawable background;
        private final IDrawable fluidOverlay;
        private final LoadingCache<Integer, IDrawableAnimated> cachedEnergies;

        public FuelRefineryJeiCategory(JeiPlugin plugin, IGuiHelper guiHelper) {
            this.plugin = plugin;
            this.title = new TranslationTextComponent("container.boss_tools.fuel_refinery").getString();
            this.background = guiHelper.createDrawable(new ResourceLocation("boss_tools", "textures/jei/fuel_refinery_jei.png"), 0, 0, 148, 64);
            this.fluidOverlay = guiHelper.drawableBuilder(GuiHelper.FLUID_TANK_PATH, 0, 0, 14, 48).setTextureSize(14, 48).build();
            this.cachedEnergies = JeiPlugin.createUsingEnergies(guiHelper);
        }

        public List<ITextComponent> getTooltipStrings(FuelRefiningRecipe recipe, double mouseX, double mouseY) {
            if (GuiHelper.isHover(this.getEnergyBounds(), mouseX, mouseY)) {
                return Collections.singletonList(GaugeTextHelper.getUsingPerTickText(GaugeValueHelper.getEnergy(1)).build());
            }
            return Collections.emptyList();
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends FuelRefiningRecipe> getRecipeClass() {
            return FuelRefiningRecipe.class;
        }

        public String getTitle() {
            return this.title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public void draw(FuelRefiningRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
            super.draw((Object)recipe, matrixStack, mouseX, mouseY);
            ((IDrawableAnimated)this.cachedEnergies.getUnchecked((Object)200)).draw(matrixStack, 114, 8);
        }

        public void setIngredients(FuelRefiningRecipe recipe, IIngredients iIngredients) {
            iIngredients.setInputs(VanillaTypes.ITEM, this.plugin.getFluidFullItemStacks(recipe.getInput().getFluids()));
            iIngredients.setOutputs(VanillaTypes.ITEM, this.plugin.getFluidFullItemStacks(recipe.getOutput().getFluids()));
            iIngredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getInput().toStacks()));
            iIngredients.setOutputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getOutput().toStacks()));
        }

        public void setRecipe(IRecipeLayout iRecipeLayout, FuelRefiningRecipe recipe, IIngredients iIngredients) {
            IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
            itemStacks.init(0, true, 24, 8);
            itemStacks.init(1, false, 90, 38);
            itemStacks.init(2, false, 24, 38);
            itemStacks.init(3, false, 90, 8);
            itemStacks.set(0, iIngredients.getInputs(VanillaTypes.ITEM).stream().flatMap(i -> i.stream()).collect(Collectors.toList()));
            itemStacks.set(1, iIngredients.getOutputs(VanillaTypes.ITEM).stream().flatMap(i -> i.stream()).collect(Collectors.toList()));
            IGuiFluidStackGroup fluidStacks = iRecipeLayout.getFluidStacks();
            int tanks = 0;
            fluidStacks.init(tanks, true, 8, 8, 14, 48, 1, false, this.fluidOverlay);
            fluidStacks.set(tanks, (List)iIngredients.getInputs(VanillaTypes.FLUID).get(0));
            fluidStacks.init(++tanks, false, 74, 8, 14, 48, 1, false, this.fluidOverlay);
            fluidStacks.set(tanks, (List)iIngredients.getOutputs(VanillaTypes.FLUID).get(0));
            ++tanks;
        }

        public Rectangle2d getInputTankBounds() {
            return GuiHelper.getFluidTankBounds(8, 8);
        }

        public Rectangle2d getOutputTankBounds() {
            return GuiHelper.getFluidTankBounds(74, 8);
        }

        public Rectangle2d getEnergyBounds() {
            return GuiHelper.getEnergyBounds(114, 8);
        }
    }

    public static class CompressorJeiCategory
    implements IRecipeCategory<CompressingRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("boss_tools", "compressorcategory");
        public static final int ARROW_LEFT = 36;
        public static final int ARROW_TOP = 29;
        public static final int ENERGY_LEFT = 103;
        public static final int ENERGY_TOP = 15;
        private final String title = new TranslationTextComponent("container.boss_tools.compressor").getString();
        private final IDrawable background;
        private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;
        private final LoadingCache<Integer, IDrawableAnimated> cachedEnergies;

        public CompressorJeiCategory(IGuiHelper guiHelper) {
            this.background = guiHelper.createDrawable(new ResourceLocation("boss_tools", "textures/jei/compressor_gui_jei.png"), 0, 0, 144, 84);
            this.cachedArrows = JeiPlugin.createArrows(guiHelper);
            this.cachedEnergies = JeiPlugin.createUsingEnergies(guiHelper);
        }

        public List<ITextComponent> getTooltipStrings(CompressingRecipe recipe, double mouseX, double mouseY) {
            if (GuiHelper.isHover(this.getEnergyBounds(), mouseX, mouseY)) {
                ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
                list.add((ITextComponent)GaugeTextHelper.getUsingPerTickText(GaugeValueHelper.getEnergy(1)).build());
                return list;
            }
            return Collections.emptyList();
        }

        private Rectangle2d getEnergyBounds() {
            return GuiHelper.getEnergyBounds(103, 15);
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends CompressingRecipe> getRecipeClass() {
            return CompressingRecipe.class;
        }

        public String getTitle() {
            return this.title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public void draw(CompressingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
            super.draw((Object)recipe, matrixStack, mouseX, mouseY);
            int cookTime = recipe.getCookTime();
            ((IDrawableAnimated)this.cachedArrows.getUnchecked((Object)cookTime)).draw(matrixStack, 36, 29);
            ((IDrawableAnimated)this.cachedEnergies.getUnchecked((Object)cookTime)).draw(matrixStack, 103, 15);
            JeiPlugin.drawTextTime(matrixStack, this.getBackground(), cookTime);
        }

        public IDrawable getIcon() {
            return null;
        }

        public void setIngredients(CompressingRecipe recipe, IIngredients iIngredients) {
            iIngredients.setInputIngredients(recipe.func_192400_c());
            iIngredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutput());
        }

        public void setRecipe(IRecipeLayout iRecipeLayout, CompressingRecipe recipe, IIngredients iIngredients) {
            IGuiItemStackGroup stacks = iRecipeLayout.getItemStacks();
            stacks.init(0, true, 14, 29);
            stacks.init(1, false, 69, 28);
            stacks.set(0, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
            stacks.set(1, (List)iIngredients.getOutputs(VanillaTypes.ITEM).get(0));
        }
    }

    public static class Tier3RocketJeiCategory
    implements IRecipeCategory<FuelLoadingRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("boss_tools", "rocket_t_3_category");
        private final String title;
        private final IDrawable background;

        public Tier3RocketJeiCategory(IGuiHelper guiHelper) {
            this.title = "Tier 3 Rocket";
            this.background = guiHelper.createDrawable(new ResourceLocation("boss_tools", "textures/jei/rocket_gui_jei.png"), 0, 0, 128, 71);
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends FuelLoadingRecipe> getRecipeClass() {
            return FuelLoadingRecipe.class;
        }

        public String getTitle() {
            return this.title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public int getCapacity() {
            return 3000;
        }

        public void setIngredients(FuelLoadingRecipe recipe, IIngredients iIngredients) {
            iIngredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getItemStacks()));
            iIngredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getFluidStacks(this.getCapacity())));
        }

        public void setRecipe(IRecipeLayout iRecipeLayout, FuelLoadingRecipe recipe, IIngredients iIngredients) {
            IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
            itemStacks.init(0, true, 13, 18);
            itemStacks.set(0, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
            IGuiFluidStackGroup fluidStacks = iRecipeLayout.getFluidStacks();
            fluidStacks.init(0, true, 66, 12, 46, 46, this.getCapacity(), false, null);
            fluidStacks.set(0, (List)iIngredients.getInputs(VanillaTypes.FLUID).get(0));
        }
    }

    public static class Tier2RocketJeiCategory
    implements IRecipeCategory<FuelLoadingRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("boss_tools", "rocket_t_2_category");
        private final String title;
        private final IDrawable background;

        public Tier2RocketJeiCategory(IGuiHelper guiHelper) {
            this.title = "Tier 2 Rocket";
            this.background = guiHelper.createDrawable(new ResourceLocation("boss_tools", "textures/jei/rocket_gui_jei.png"), 0, 0, 128, 71);
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends FuelLoadingRecipe> getRecipeClass() {
            return FuelLoadingRecipe.class;
        }

        public String getTitle() {
            return this.title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public int getCapacity() {
            return 3000;
        }

        public void setIngredients(FuelLoadingRecipe recipe, IIngredients iIngredients) {
            iIngredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getItemStacks()));
            iIngredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getFluidStacks(this.getCapacity())));
        }

        public void setRecipe(IRecipeLayout iRecipeLayout, FuelLoadingRecipe recipe, IIngredients iIngredients) {
            IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
            itemStacks.init(0, true, 13, 18);
            itemStacks.set(0, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
            IGuiFluidStackGroup fluidStacks = iRecipeLayout.getFluidStacks();
            fluidStacks.init(0, true, 66, 12, 46, 46, this.getCapacity(), false, null);
            fluidStacks.set(0, (List)iIngredients.getInputs(VanillaTypes.FLUID).get(0));
        }
    }

    public static class Tier1RocketJeiCategory
    implements IRecipeCategory<FuelLoadingRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("boss_tools", "rocket_t_1_category");
        private final String title;
        private final IDrawable background;

        public Tier1RocketJeiCategory(IGuiHelper guiHelper) {
            this.title = "Tier 1 Rocket";
            this.background = guiHelper.createDrawable(new ResourceLocation("boss_tools", "textures/jei/rocket_gui_jei.png"), 0, 0, 128, 71);
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends FuelLoadingRecipe> getRecipeClass() {
            return FuelLoadingRecipe.class;
        }

        public String getTitle() {
            return this.title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public int getCapacity() {
            return 1000;
        }

        public void setIngredients(FuelLoadingRecipe recipe, IIngredients iIngredients) {
            iIngredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getItemStacks()));
            iIngredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getFluidStacks(this.getCapacity())));
        }

        public void setRecipe(IRecipeLayout iRecipeLayout, FuelLoadingRecipe recipe, IIngredients iIngredients) {
            IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
            itemStacks.init(0, true, 13, 18);
            itemStacks.set(0, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
            IGuiFluidStackGroup fluidStacks = iRecipeLayout.getFluidStacks();
            fluidStacks.init(0, true, 66, 12, 46, 46, this.getCapacity(), false, null);
            fluidStacks.set(0, (List)iIngredients.getInputs(VanillaTypes.FLUID).get(0));
        }
    }

    public static class BlastingFurnaceJeiCategory
    implements IRecipeCategory<BlastingRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("boss_tools", "blastingfurnacecategory");
        public static final int FIRE_LEFT = 37;
        public static final int FIRE_TOP = 37;
        public static final int ARROW_LEFT = 55;
        public static final int ARROW_TOP = 35;
        private final String title = new TranslationTextComponent("container.boss_tools.blast_furnace").getString();
        private final IDrawable background;
        private final LoadingCache<Integer, IDrawableAnimated> fire;
        private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

        public BlastingFurnaceJeiCategory(IGuiHelper guiHelper) {
            this.background = guiHelper.createDrawable(new ResourceLocation("boss_tools", "textures/jei/blast_furnace_gui_jei.png"), 0, 0, 144, 84);
            this.fire = JeiPlugin.createFires(guiHelper);
            this.cachedArrows = JeiPlugin.createArrows(guiHelper);
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends BlastingRecipe> getRecipeClass() {
            return BlastingRecipe.class;
        }

        public String getTitle() {
            return this.title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public void draw(BlastingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
            super.draw((Object)recipe, matrixStack, mouseX, mouseY);
            int cookTime = recipe.getCookTime();
            ((IDrawableAnimated)this.fire.getUnchecked((Object)cookTime)).draw(matrixStack, 37, 37);
            ((IDrawableAnimated)this.cachedArrows.getUnchecked((Object)cookTime)).draw(matrixStack, 55, 35);
            JeiPlugin.drawTextTime(matrixStack, this.getBackground(), cookTime);
        }

        public IDrawable getIcon() {
            return null;
        }

        public void setIngredients(BlastingRecipe recipe, IIngredients iIngredients) {
            iIngredients.setInputIngredients(recipe.func_192400_c());
            iIngredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutput());
        }

        public void setRecipe(IRecipeLayout iRecipeLayout, BlastingRecipe recipe, IIngredients iIngredients) {
            IGuiItemStackGroup stacks = iRecipeLayout.getItemStacks();
            stacks.init(0, true, 36, 16);
            stacks.init(1, false, 86, 35);
            stacks.set(0, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
            stacks.set(1, (List)iIngredients.getOutputs(VanillaTypes.ITEM).get(0));
        }
    }

    public static class NASAWorkbenchJeiCategory
    implements IRecipeCategory<WorkbenchingRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("boss_tools", "workbenchcategory");
        private final String title = new TranslationTextComponent("container.boss_tools.nasa_workbench").getString();
        private final IDrawable background;

        public NASAWorkbenchJeiCategory(IGuiHelper guiHelper) {
            this.background = guiHelper.createDrawable(new ResourceLocation("boss_tools", "textures/jei/nasaworkbenchjei.png"), 0, 0, 176, 122);
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends WorkbenchingRecipe> getRecipeClass() {
            return WorkbenchingRecipe.class;
        }

        public String getTitle() {
            return this.title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public void setIngredients(WorkbenchingRecipe recipe, IIngredients iIngredients) {
            iIngredients.setInputIngredients(recipe.func_192400_c());
            iIngredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutput());
        }

        public void setRecipe(IRecipeLayout iRecipeLayout, WorkbenchingRecipe recipe, IIngredients iIngredients) {
            IDrawable background = this.getBackground();
            iRecipeLayout.moveRecipeTransferButton(background.getWidth() - 20, background.getHeight() - 20);
            int slots = 0;
            GridPlacer placer = new GridPlacer();
            slots = JeiPlugin.placeRcketParts(slots, 38, 7, 1, placer::placeBottom, (RocketPart)ModInnet.ROCKET_PART_NOSE.get(), iRecipeLayout, recipe);
            slots = JeiPlugin.placeRcketParts(slots, 29, 25, 2, placer::placeBottom, (RocketPart)ModInnet.ROCKET_PART_BODY.get(), iRecipeLayout, recipe);
            slots = JeiPlugin.placeRcketParts(slots, 29, 79, 1, placer::placeRight, (RocketPart)ModInnet.ROCKET_PART_TANK.get(), iRecipeLayout, recipe);
            slots = JeiPlugin.placeRcketParts(slots, 11, 79, 1, placer::placeBottom, (RocketPart)ModInnet.ROCKET_PART_FIN_LEFT.get(), iRecipeLayout, recipe);
            slots = JeiPlugin.placeRcketParts(slots, 65, 79, 1, placer::placeBottom, (RocketPart)ModInnet.ROCKET_PART_FIN_RIGHT.get(), iRecipeLayout, recipe);
            slots = JeiPlugin.placeRcketParts(slots, 38, 97, 1, placer::placeBottom, (RocketPart)ModInnet.ROCKET_PART_ENGINE.get(), iRecipeLayout, recipe);
            IGuiItemStackGroup stacks = iRecipeLayout.getItemStacks();
            stacks.init(slots, false, 126, 72);
            stacks.set(slots, (List)iIngredients.getOutputs(VanillaTypes.ITEM).get(0));
            ++slots;
        }
    }

    public static class CoalGeneratorJeiCategory
    implements IRecipeCategory<GeneratingRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("boss_tools", "generatorcategory");
        public static final int FIRE_LEFT = 45;
        public static final int FIRE_TOP = 45;
        public static final int ENERGY_LEFT = 103;
        public static final int ENERGY_TOP = 15;
        private final String title = new TranslationTextComponent("container.boss_tools.coal_generator").getString();
        private final IDrawable background;
        private final LoadingCache<Integer, IDrawableAnimated> fires;
        private final LoadingCache<Integer, IDrawableAnimated> energies;

        public CoalGeneratorJeiCategory(IGuiHelper guiHelper) {
            this.background = guiHelper.createDrawable(new ResourceLocation("boss_tools", "textures/jei/generator_gui_jei.png"), 0, 0, 144, 84);
            this.fires = JeiPlugin.createFires(guiHelper);
            this.energies = JeiPlugin.createGeneratingEnergies(guiHelper);
        }

        public List<ITextComponent> getTooltipStrings(GeneratingRecipe recipe, double mouseX, double mouseY) {
            if (GuiHelper.isHover(this.getFireBounds(), mouseX, mouseY)) {
                return Collections.singletonList(GaugeTextHelper.getValueText(GaugeValueHelper.getBurnTime(recipe.getBurnTime())).build());
            }
            if (GuiHelper.isHover(this.getEnergyBounds(), mouseX, mouseY)) {
                ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
                list.add((ITextComponent)GaugeTextHelper.getGeneratingPerTickText(GaugeValueHelper.getEnergy(2)).build());
                return list;
            }
            return Collections.emptyList();
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends GeneratingRecipe> getRecipeClass() {
            return GeneratingRecipe.class;
        }

        public String getTitle() {
            return this.title;
        }

        public Rectangle2d getFireBounds() {
            return GuiHelper.getFireBounds(45, 45);
        }

        public Rectangle2d getEnergyBounds() {
            return GuiHelper.getEnergyBounds(103, 15);
        }

        public void draw(GeneratingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
            super.draw((Object)recipe, matrixStack, mouseX, mouseY);
            int burnTime = recipe.getBurnTime();
            ((IDrawableAnimated)this.fires.getUnchecked((Object)burnTime)).draw(matrixStack, 45, 45);
            ((IDrawableAnimated)this.energies.getUnchecked((Object)200)).draw(matrixStack, 103, 15);
            JeiPlugin.drawTextTime(matrixStack, this.getBackground(), burnTime);
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public void setIngredients(GeneratingRecipe recipe, IIngredients iIngredients) {
            iIngredients.setInputIngredients(recipe.func_192400_c());
        }

        public void setRecipe(IRecipeLayout iRecipeLayout, GeneratingRecipe recipe, IIngredients iIngredients) {
            IGuiItemStackGroup stacks = iRecipeLayout.getItemStacks();
            stacks.init(0, true, 44, 25);
            stacks.set(0, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
        }
    }

    public static class OxygenBubbleDistributorJeiCategory
    implements IRecipeCategory<OxygenBubbleDistributorRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("boss_tools", "oxygen_bubble_distributor");
        public static final int INPUT_TANK_LEFT = 8;
        public static final int INPUT_TANK_TOP = 8;
        public static final int OUTPUT_TANK_LEFT = 74;
        public static final int OUTPUT_TANK_TOP = 8;
        public static final int ENERGY_LEFT = 114;
        public static final int ENERGY_TOP = 8;
        private final JeiPlugin plugin;
        private final String title;
        private final IDrawable background;
        private final IDrawable fluidOverlay;
        private final LoadingCache<Integer, IDrawableAnimated> cachedEnergies;

        public OxygenBubbleDistributorJeiCategory(JeiPlugin plugin, IGuiHelper guiHelper) {
            this.plugin = plugin;
            this.title = new TranslationTextComponent("container.boss_tools.oxygen_bubble_distributor").getString();
            this.background = guiHelper.createDrawable(new ResourceLocation("boss_tools", "textures/jei/oxygen_bubble_distributor_jei.png"), 0, 0, 148, 64);
            this.fluidOverlay = guiHelper.drawableBuilder(GuiHelper.FLUID_TANK_PATH, 0, 0, 14, 48).setTextureSize(14, 48).build();
            this.cachedEnergies = JeiPlugin.createUsingEnergies(guiHelper);
        }

        public List<ITextComponent> getTooltipStrings(OxygenBubbleDistributorRecipe recipe, double mouseX, double mouseY) {
            if (GuiHelper.isHover(this.getEnergyBounds(), mouseX, mouseY)) {
                return Collections.singletonList(GaugeTextHelper.getUsingPerTickText(GaugeValueHelper.getEnergy(1)).build());
            }
            if (GuiHelper.isHover(this.getOutputTankBounds(), mouseX, mouseY)) {
                return Collections.singletonList(GaugeTextHelper.getValueText(GaugeValueHelper.getOxygen(recipe.getOxygen())).build());
            }
            return Collections.emptyList();
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends OxygenBubbleDistributorRecipe> getRecipeClass() {
            return OxygenBubbleDistributorRecipe.class;
        }

        public String getTitle() {
            return this.title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public void draw(OxygenBubbleDistributorRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
            super.draw((Object)recipe, matrixStack, mouseX, mouseY);
            ((IDrawableAnimated)this.cachedEnergies.getUnchecked((Object)200)).draw(matrixStack, 114, 8);
            GuiHelper.drawOxygenTank(matrixStack, 74, 8, 1.0);
        }

        public void setIngredients(OxygenBubbleDistributorRecipe recipe, IIngredients iIngredients) {
            iIngredients.setInputs(VanillaTypes.ITEM, this.plugin.getFluidFullItemStacks(recipe.getInput().getFluids()));
            iIngredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getInput().toStacks()));
        }

        public void setRecipe(IRecipeLayout iRecipeLayout, OxygenBubbleDistributorRecipe recipe, IIngredients iIngredients) {
            IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
            itemStacks.init(0, true, 24, 8);
            itemStacks.init(2, false, 24, 38);
            itemStacks.set(0, iIngredients.getInputs(VanillaTypes.ITEM).stream().flatMap(Collection::stream).collect(Collectors.toList()));
            IGuiFluidStackGroup fluidStacks = iRecipeLayout.getFluidStacks();
            int tanks = 0;
            fluidStacks.init(tanks, true, 8, 8, 14, 48, 1, false, this.fluidOverlay);
            fluidStacks.set(tanks, iIngredients.getInputs(VanillaTypes.FLUID).stream().flatMap(Collection::stream).collect(Collectors.toList()));
            ++tanks;
        }

        public Rectangle2d getInputTankBounds() {
            return GuiHelper.getFluidTankBounds(8, 8);
        }

        public Rectangle2d getOutputTankBounds() {
            return GuiHelper.getFluidTankBounds(74, 8);
        }

        public Rectangle2d getEnergyBounds() {
            return GuiHelper.getEnergyBounds(114, 8);
        }
    }

    public static class OxygenLoaderJeiCategory
    implements IRecipeCategory<OxygenLoaderRecipe> {
        public static final ResourceLocation Uid = new ResourceLocation("boss_tools", "oxygen_loader");
        public static final int INPUT_TANK_LEFT = 8;
        public static final int INPUT_TANK_TOP = 8;
        public static final int OUTPUT_TANK_LEFT = 74;
        public static final int OUTPUT_TANK_TOP = 8;
        public static final int ENERGY_LEFT = 114;
        public static final int ENERGY_TOP = 8;
        private final JeiPlugin plugin;
        private final String title;
        private final IDrawable background;
        private final IDrawable fluidOverlay;
        private final LoadingCache<Integer, IDrawableAnimated> cachedEnergies;

        public OxygenLoaderJeiCategory(JeiPlugin plugin, IGuiHelper guiHelper) {
            this.plugin = plugin;
            this.title = new TranslationTextComponent("container.boss_tools.oxygen_loader").getString();
            this.background = guiHelper.createDrawable(new ResourceLocation("boss_tools", "textures/jei/oxygen_loader_jei.png"), 0, 0, 148, 64);
            this.fluidOverlay = guiHelper.drawableBuilder(GuiHelper.FLUID_TANK_PATH, 0, 0, 14, 48).setTextureSize(14, 48).build();
            this.cachedEnergies = JeiPlugin.createUsingEnergies(guiHelper);
        }

        public List<ITextComponent> getTooltipStrings(OxygenLoaderRecipe recipe, double mouseX, double mouseY) {
            if (GuiHelper.isHover(this.getEnergyBounds(), mouseX, mouseY)) {
                return Collections.singletonList(GaugeTextHelper.getUsingPerTickText(GaugeValueHelper.getEnergy(1)).build());
            }
            if (GuiHelper.isHover(this.getOutputTankBounds(), mouseX, mouseY)) {
                return Collections.singletonList(GaugeTextHelper.getValueText(GaugeValueHelper.getOxygen(recipe.getOxygen())).build());
            }
            return Collections.emptyList();
        }

        public ResourceLocation getUid() {
            return Uid;
        }

        public Class<? extends OxygenLoaderRecipe> getRecipeClass() {
            return OxygenLoaderRecipe.class;
        }

        public String getTitle() {
            return this.title;
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return null;
        }

        public void draw(OxygenLoaderRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
            super.draw((Object)recipe, matrixStack, mouseX, mouseY);
            ((IDrawableAnimated)this.cachedEnergies.getUnchecked((Object)200)).draw(matrixStack, 114, 8);
            GuiHelper.drawOxygenTank(matrixStack, 74, 8, 1.0);
        }

        public void setIngredients(OxygenLoaderRecipe recipe, IIngredients iIngredients) {
            iIngredients.setInputs(VanillaTypes.ITEM, this.plugin.getFluidFullItemStacks(recipe.getInput().getFluids()));
            iIngredients.setOutputs(VanillaTypes.ITEM, this.plugin.oxygenFullItemStacks);
            iIngredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getInput().toStacks()));
        }

        public void setRecipe(IRecipeLayout iRecipeLayout, OxygenLoaderRecipe recipe, IIngredients iIngredients) {
            IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
            itemStacks.init(0, true, 24, 8);
            itemStacks.init(1, false, 90, 38);
            itemStacks.init(2, false, 24, 38);
            itemStacks.init(3, false, 90, 8);
            itemStacks.set(0, iIngredients.getInputs(VanillaTypes.ITEM).stream().flatMap(Collection::stream).collect(Collectors.toList()));
            itemStacks.set(1, iIngredients.getOutputs(VanillaTypes.ITEM).stream().flatMap(Collection::stream).collect(Collectors.toList()));
            IGuiFluidStackGroup fluidStacks = iRecipeLayout.getFluidStacks();
            int tanks = 0;
            fluidStacks.init(tanks, true, 8, 8, 14, 48, 1, false, this.fluidOverlay);
            fluidStacks.set(tanks, iIngredients.getInputs(VanillaTypes.FLUID).stream().flatMap(Collection::stream).collect(Collectors.toList()));
            ++tanks;
        }

        public Rectangle2d getInputTankBounds() {
            return GuiHelper.getFluidTankBounds(8, 8);
        }

        public Rectangle2d getOutputTankBounds() {
            return GuiHelper.getFluidTankBounds(74, 8);
        }

        public Rectangle2d getEnergyBounds() {
            return GuiHelper.getEnergyBounds(114, 8);
        }
    }

    public static class FuelLoadingRecipe {
        private final List<ItemStack> itemStacks;
        private final List<Fluid> fluids;

        public FuelLoadingRecipe(List<ItemStack> itemStacks, List<Fluid> fluids) {
            this.itemStacks = Collections.unmodifiableList(itemStacks);
            this.fluids = Collections.unmodifiableList(fluids);
        }

        public List<ItemStack> getItemStacks() {
            return this.itemStacks;
        }

        public List<FluidStack> getFluidStacks(int amount) {
            return this.getFluid().stream().map(f -> new FluidStack(f, amount)).collect(Collectors.toList());
        }

        public List<Fluid> getFluid() {
            return this.fluids;
        }
    }
}

