/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.machines;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.mrscauthd.boss_tools.ModInnet;
import net.mrscauthd.boss_tools.crafting.BossToolsRecipeType;
import net.mrscauthd.boss_tools.crafting.BossToolsRecipeTypes;
import net.mrscauthd.boss_tools.crafting.FluidIngredient;
import net.mrscauthd.boss_tools.crafting.FuelRefiningRecipe;
import net.mrscauthd.boss_tools.fluid.FluidUtil2;
import net.mrscauthd.boss_tools.gui.screens.fuelrefinery.FuelRefineryGui;
import net.mrscauthd.boss_tools.inventory.StackCacher;
import net.mrscauthd.boss_tools.machines.tile.AbstractMachineTileEntity;
import net.mrscauthd.boss_tools.machines.tile.NamedComponentRegistry;
import net.mrscauthd.boss_tools.machines.tile.PowerSystemEnergyCommon;
import net.mrscauthd.boss_tools.machines.tile.PowerSystemRegistry;

public class FuelRefineryBlock {
    public static final int ENERGY_PER_TICK = 1;
    public static final int TANK_CAPACITY = 3000;
    public static final int TRANSFER_PER_TICK = 256;
    public static final ResourceLocation TANK_INPUT = new ResourceLocation("boss_tools", "input");
    public static final ResourceLocation TANK_OUTPUT = new ResourceLocation("boss_tools", "output");
    public static final int SLOT_INPUT_SOURCE = 0;
    public static final int SLOT_OUTPUT_SINK = 1;
    public static final int SLOT_INPUT_SINK = 2;
    public static final int SLOT_OUTPUT_SOURCE = 3;

    public static class CustomTileEntity
    extends AbstractMachineTileEntity {
        private FluidTank inputTank;
        private FluidTank outputTank;
        private StackCacher recipeCacher = new StackCacher();
        private FuelRefiningRecipe cachedRecipe = null;

        public CustomTileEntity() {
            super((TileEntityType)ModInnet.FUEL_REFINERY.get());
        }

        @Override
        protected void createEnergyStorages(NamedComponentRegistry<IEnergyStorage> registry) {
            super.createEnergyStorages(registry);
            registry.put(this.createEnergyStorageCommon());
        }

        @Override
        protected void createFluidHandlers(NamedComponentRegistry<IFluidHandler> registry) {
            super.createFluidHandlers(registry);
            this.inputTank = (FluidTank)registry.computeIfAbsent(this.getInputTankName(), k -> this.creatTank((ResourceLocation)k));
            this.outputTank = (FluidTank)registry.computeIfAbsent(this.getOutputTankName(), k -> this.creatTank((ResourceLocation)k));
        }

        protected int getInitialTankCapacity(ResourceLocation name) {
            return 3000;
        }

        protected FluidTank creatTank(ResourceLocation name) {
            return new FluidTank(this.getInitialTankCapacity(name)){

                protected void onContentsChanged() {
                    super.onContentsChanged();
                    this.func_70296_d();
                }
            };
        }

        @Override
        protected void createPowerSystems(PowerSystemRegistry map) {
            super.createPowerSystems(map);
            map.put(new PowerSystemEnergyCommon(this){

                @Override
                public int getBasePowerForOperation() {
                    return this.getBasePowerForOperation();
                }
            });
        }

        public int getBasePowerForOperation() {
            return 1;
        }

        public int func_70297_j_() {
            return 1;
        }

        public Container func_213906_a(int id, PlayerInventory player) {
            return new FuelRefineryGui.GuiContainer(id, player, this);
        }

        @Override
        protected void tickProcessing() {
            this.drainSources();
            this.consumeIngredients();
            this.fillSinks();
        }

        public boolean consumeIngredients() {
            FluidIngredient recipeOutput;
            FuelRefiningRecipe recipe = this.cacheRecipe();
            if (recipe != null && this.hasSpaceInOutput(recipeOutput = recipe.getOutput()) && this.consumePowerForOperation() != null) {
                this.getInputTank().drain(recipe.getInput().getAmount(), IFluidHandler.FluidAction.EXECUTE);
                this.getOutputTank().fill(recipeOutput.toStack(), IFluidHandler.FluidAction.EXECUTE);
                this.setProcessedInThisTick();
                return true;
            }
            return false;
        }

        protected void drainSources() {
            IItemHandlerModifiable itemHandler = this.getItemHandler();
            int transferPerTick = this.getTransferPerTick();
            FluidUtil2.drainSource(itemHandler, this.getInputSourceSlot(), (IFluidHandler)this.getInputTank(), transferPerTick);
            FluidUtil2.drainSource(itemHandler, this.getOutputSourceSlot(), (IFluidHandler)this.getOutputTank(), transferPerTick);
        }

        protected void fillSinks() {
            IItemHandlerModifiable itemHandler = this.getItemHandler();
            int transferPerTick = this.getTransferPerTick();
            FluidUtil2.fillSink(itemHandler, this.getInputSinkSlot(), (IFluidHandler)this.getInputTank(), transferPerTick);
            FluidUtil2.fillSink(itemHandler, this.getOutputSinkSlot(), (IFluidHandler)this.getOutputTank(), transferPerTick);
        }

        @Override
        public <T> LazyOptional<T> getCapabilityFluidHandler(Capability<T> capability, @Nullable Direction facing) {
            if (facing == Direction.DOWN || facing == null) {
                return LazyOptional.of(this::getOutputTank).cast();
            }
            return LazyOptional.of(this::getInputTank).cast();
        }

        @Override
        protected void getSlotsForFace(Direction direction, List<Integer> slots) {
            super.getSlotsForFace(direction, slots);
            slots.add(this.getOutputSourceSlot());
            slots.add(this.getInputSourceSlot());
            slots.add(this.getOutputSinkSlot());
        }

        @Override
        protected boolean onCanInsertItem(int index, ItemStack stack, Direction direction) {
            if (this.isSourceSlot(index)) {
                return FluidUtil2.canDrain(stack);
            }
            if (this.isSinkSlot(index)) {
                FluidTank tank = this.slotToTank(index);
                return FluidUtil2.canFill(stack, tank.getFluid().getFluid());
            }
            return super.onCanInsertItem(index, stack, direction);
        }

        @Override
        public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
            if (this.isSourceSlot(index)) {
                return !FluidUtil2.canDrain(stack);
            }
            if (this.isSinkSlot(index)) {
                FluidTank tank = this.slotToTank(index);
                return !FluidUtil2.canFill(stack, tank.getFluid().getFluid());
            }
            return super.func_180461_b(index, stack, direction);
        }

        @Override
        public boolean hasSpaceInOutput() {
            FuelRefiningRecipe recipe = this.cacheRecipe();
            return recipe != null && this.hasSpaceInOutput(recipe.getOutput());
        }

        public boolean hasSpaceInOutput(FluidIngredient recipeOutput) {
            return this.hasSpaceInOutput(recipeOutput, (IFluidTank)this.getOutputTank());
        }

        public FuelRefiningRecipe cacheRecipe() {
            FluidStack fluidStack = this.getInputTank().getFluid();
            if (fluidStack.isEmpty()) {
                this.recipeCacher.set(fluidStack);
                this.cachedRecipe = null;
            } else if (!this.recipeCacher.test(fluidStack)) {
                this.recipeCacher.set(fluidStack);
                this.cachedRecipe = this.getRecipeType().findFirst(this.func_145831_w(), r -> r.test(fluidStack));
            }
            return this.cachedRecipe;
        }

        public BossToolsRecipeType<? extends FuelRefiningRecipe> getRecipeType() {
            return BossToolsRecipeTypes.FUELREFINING;
        }

        @Override
        protected int getInitialInventorySize() {
            return super.getInitialInventorySize() + 4;
        }

        public int getInputSourceSlot() {
            return 0;
        }

        public int getInputSinkSlot() {
            return 2;
        }

        public int getOutputSourceSlot() {
            return 3;
        }

        public int getOutputSinkSlot() {
            return 1;
        }

        public boolean isSourceSlot(int slot) {
            return slot == this.getInputSourceSlot() || slot == this.getOutputSourceSlot();
        }

        public boolean isSinkSlot(int slot) {
            return slot == this.getInputSinkSlot() || slot == this.getOutputSinkSlot();
        }

        public FluidTank slotToTank(int slot) {
            if (slot == this.getInputSourceSlot() || slot == this.getInputSinkSlot()) {
                return this.getInputTank();
            }
            if (slot == this.getOutputSourceSlot() || slot == this.getOutputSinkSlot()) {
                return this.getOutputTank();
            }
            return null;
        }

        public ResourceLocation slotToTankName(int slot) {
            if (slot == this.getInputSourceSlot() || slot == this.getInputSinkSlot()) {
                return this.getInputTankName();
            }
            if (slot == this.getOutputSourceSlot() || slot == this.getOutputSinkSlot()) {
                return this.getOutputTankName();
            }
            return null;
        }

        public ResourceLocation getInputTankName() {
            return TANK_INPUT;
        }

        public FluidTank getInputTank() {
            return this.inputTank;
        }

        public ResourceLocation getOutputTankName() {
            return TANK_OUTPUT;
        }

        public FluidTank getOutputTank() {
            return this.outputTank;
        }

        public int getTransferPerTick() {
            return 256;
        }
    }

    public static class CustomBlock
    extends Block {
        public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
        public static final BooleanProperty ACTIAVATED = BlockStateProperties.field_208190_q;

        public CustomBlock() {
            super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200948_a(5.0f, 1.0f).func_235838_a_(s -> 0).harvestLevel(1).harvestTool(ToolType.PICKAXE).func_235861_h_());
            this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)ACTIAVATED, (Comparable)Boolean.valueOf(false)));
        }

        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            builder.func_206894_a(new Property[]{FACING, ACTIAVATED});
        }

        public BlockState func_185499_a(BlockState state, Rotation rot) {
            return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
        }

        public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
            return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
        }

        public BlockState func_196258_a(BlockItemUseContext context) {
            return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
        }

        public PushReaction func_149656_h(BlockState state) {
            return PushReaction.BLOCK;
        }

        public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
            List dropsOriginal = super.func_220076_a(state, builder);
            if (!dropsOriginal.isEmpty()) {
                return dropsOriginal;
            }
            return Collections.singletonList(new ItemStack((IItemProvider)this, 1));
        }

        public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
            return (Boolean)state.func_177229_b((Property)ACTIAVATED) != false ? 12 : 0;
        }

        public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
            return (Boolean)state.func_177229_b((Property)ACTIAVATED) != false ? 12 : 0;
        }

        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity entity, Hand hand, BlockRayTraceResult hit) {
            if (entity instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)entity), (INamedContainerProvider)this.func_220052_b(state, world, pos), (BlockPos)pos);
                return ActionResultType.CONSUME;
            }
            return ActionResultType.SUCCESS;
        }

        public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            return tileEntity instanceof INamedContainerProvider ? (INamedContainerProvider)tileEntity : null;
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new CustomTileEntity();
        }

        public boolean func_189539_a(BlockState state, World world, BlockPos pos, int eventID, int eventParam) {
            super.func_189539_a(state, world, pos, eventID, eventParam);
            TileEntity tileentity = world.func_175625_s(pos);
            return tileentity == null ? false : tileentity.func_145842_c(eventID, eventParam);
        }

        public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
            if (state.func_177230_c() != newState.func_177230_c()) {
                CustomTileEntity tileentity = (CustomTileEntity)world.func_175625_s(pos);
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)tileentity);
                world.func_175666_e(pos, (Block)this);
                super.func_196243_a(state, world, pos, newState, isMoving);
            }
        }

        public boolean func_149740_M(BlockState state) {
            return true;
        }

        public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
            CustomTileEntity tileentity = (CustomTileEntity)world.func_175625_s(pos);
            return Container.func_94526_b((IInventory)tileentity);
        }
    }
}

