/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.machines;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.LootContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.mrscauthd.boss_tools.ModInnet;
import net.mrscauthd.boss_tools.crafting.BossToolsRecipeType;
import net.mrscauthd.boss_tools.crafting.BossToolsRecipeTypes;
import net.mrscauthd.boss_tools.crafting.RocketPart;
import net.mrscauthd.boss_tools.crafting.WorkbenchingRecipe;
import net.mrscauthd.boss_tools.gui.screens.nasaworkbench.NasaWorkbenchGui;
import net.mrscauthd.boss_tools.inventory.ItemHandlerHelper2;
import net.mrscauthd.boss_tools.inventory.RocketPartsItemHandler;
import net.mrscauthd.boss_tools.inventory.StackCacher;
import net.mrscauthd.boss_tools.machines.tile.AbstractMachineTileEntity;

public class NASAWorkbenchBlock {
    public static final int SLOT_PARTS = 0;

    public static List<RocketPart> getBasicPartOrders() {
        ArrayList<RocketPart> parts = new ArrayList<RocketPart>();
        parts.add((RocketPart)ModInnet.ROCKET_PART_NOSE.get());
        parts.add((RocketPart)ModInnet.ROCKET_PART_BODY.get());
        parts.add((RocketPart)ModInnet.ROCKET_PART_TANK.get());
        parts.add((RocketPart)ModInnet.ROCKET_PART_FIN_LEFT.get());
        parts.add((RocketPart)ModInnet.ROCKET_PART_FIN_RIGHT.get());
        parts.add((RocketPart)ModInnet.ROCKET_PART_ENGINE.get());
        return parts;
    }

    public static int getBasicPartSlots() {
        return NASAWorkbenchBlock.getBasicPartOrders().stream().collect(Collectors.summingInt(p -> p.getSlots()));
    }

    public static class CustomTileEntity
    extends AbstractMachineTileEntity {
        private StackCacher itemStackCacher = new StackCacher();
        private WorkbenchingRecipe cachedRecipe = null;
        private List<WorkbenchingRecipe> possibleRecipes = new ArrayList<WorkbenchingRecipe>();
        private Set<ItemStack> invalidCache = new HashSet<ItemStack>();
        private int prevRedstone = 0;
        private int currRedstone = 0;
        private RocketPartsItemHandler partsItemHandler;

        public CustomTileEntity() {
            super((TileEntityType)ModInnet.NASA_WORKBENCH.get());
        }

        public RocketPartsItemHandler getPartsItemHandler() {
            return this.partsItemHandler;
        }

        public List<RocketPart> getPartOrders() {
            return NASAWorkbenchBlock.getBasicPartOrders();
        }

        public int getPartsSlot() {
            return 0;
        }

        @Override
        protected void createItemHandlers() {
            super.createItemHandlers();
            this.partsItemHandler = new RocketPartsItemHandler(this.getItemHandler(), this.getPartsSlot(), this.getPartOrders());
        }

        @Override
        protected int getInitialInventorySize() {
            return super.getInitialInventorySize() + this.getPartsItemHandler().getSlots();
        }

        public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
            super.func_70299_a(p_70299_1_, p_70299_2_);
            this.cacheRecipes();
        }

        public Container func_213906_a(int id, PlayerInventory player) {
            return new NasaWorkbenchGui.GuiContainer(id, player, this);
        }

        @Override
        protected void getSlotsForFace(Direction direction, List<Integer> slots) {
            super.getSlotsForFace(direction, slots);
            RocketPartsItemHandler partsItemHandler = this.getPartsItemHandler();
            for (int i = 0; i < partsItemHandler.getSlots(); ++i) {
                slots.add(partsItemHandler.getParentSlotIndex(i));
            }
        }

        @Override
        protected boolean onCanInsertItem(int index, ItemStack stack, Direction direction) {
            if (super.onCanInsertItem(index, stack, direction)) {
                return true;
            }
            if (direction == null) {
                return true;
            }
            int find = this.findAvailableSlot(stack);
            return find == index;
        }

        public int findAvailableSlot(ItemStack itemStack) {
            this.cacheRecipes();
            ItemStack single = ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)1);
            if (this.invalidCache.contains(single)) {
                return -1;
            }
            for (WorkbenchingRecipe recipe : this.possibleRecipes) {
                int slot = this.findAvailableSlot(recipe, itemStack);
                if (slot == -1) continue;
                return slot;
            }
            this.invalidCache.add(single);
            return -1;
        }

        public int findAvailableSlot(WorkbenchingRecipe recipe, ItemStack itemStack) {
            Map<RocketPart, List<Ingredient>> recipeParts = recipe.getParts();
            RocketPartsItemHandler partsItemHandler = this.getPartsItemHandler();
            for (Map.Entry<RocketPart, IItemHandlerModifiable> entry : partsItemHandler.getSubHandlers().entrySet()) {
                RocketPart part = entry.getKey();
                IItemHandlerModifiable subHandler = entry.getValue();
                List<Ingredient> ingredients = recipeParts.get((Object)part);
                if (ingredients == null) continue;
                for (int i = 0; i < ingredients.size(); ++i) {
                    if (!ingredients.get(i).test(itemStack) || !subHandler.getStackInSlot(i).func_190926_b()) continue;
                    return partsItemHandler.getParentSlotIndex(part, i);
                }
            }
            return -1;
        }

        public WorkbenchingRecipe cacheRecipes() {
            RocketPartsItemHandler partsItemHandler = this.getPartsItemHandler();
            List<ItemStack> stacks = ItemHandlerHelper2.getStacks((IItemHandler)partsItemHandler);
            if (!this.itemStackCacher.test(stacks)) {
                this.itemStackCacher.set(stacks);
                BossToolsRecipeType<WorkbenchingRecipe> recipeType = this.getRecipeType();
                this.cachedRecipe = recipeType.findFirst(this.func_145831_w(), r -> r.test(partsItemHandler, false));
                this.possibleRecipes.clear();
                recipeType.filter(this.func_145831_w(), r -> r.test(partsItemHandler, true)).forEach(this.possibleRecipes::add);
                this.invalidCache.clear();
            }
            return this.cachedRecipe;
        }

        public BossToolsRecipeType<WorkbenchingRecipe> getRecipeType() {
            return BossToolsRecipeTypes.WORKBENCHING;
        }

        @Override
        protected void tickProcessing() {
            this.spawnParticles();
            this.updateRedstoneState();
            if (this.prevRedstone == 0 && this.currRedstone > 0) {
                this.outputToBottom();
            }
        }

        protected void updateRedstoneState() {
            this.prevRedstone = this.currRedstone;
            this.currRedstone = this.func_145831_w().func_175687_A(this.func_174877_v());
        }

        protected void outputToBottom() {
            WorkbenchingRecipe recipe = this.cacheRecipes();
            if (recipe == null) {
                return;
            }
            IItemHandler bottomItemHandler = this.getBottomTileEntityItemHandler();
            if (bottomItemHandler == null) {
                return;
            }
            ItemStack output = recipe.getOutput();
            if (ItemHandlerHelper.insertItem((IItemHandler)bottomItemHandler, (ItemStack)output, (boolean)true).func_190926_b()) {
                ItemHandlerHelper.insertItem((IItemHandler)bottomItemHandler, (ItemStack)output, (boolean)false);
                this.consumeIngredient();
            }
        }

        private IItemHandler getBottomTileEntityItemHandler() {
            TileEntity bottomTileEntity = this.func_145831_w().func_175625_s(this.func_174877_v().func_177977_b());
            if (bottomTileEntity != null) {
                return (IItemHandler)bottomTileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
            }
            return null;
        }

        protected void spawnParticles() {
            World world;
            if (this.possibleRecipes.size() > 0 && !ItemHandlerHelper2.isEmpty((IItemHandler)this.getPartsItemHandler()) && (world = this.func_145831_w()) instanceof ServerWorld) {
                ServerWorld serverWorld = (ServerWorld)world;
                BlockPos pos = this.func_174877_v();
                serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197614_g, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, 10, 0.1, 0.1, 0.1, 0.1);
            }
        }

        public boolean consumeIngredient() {
            WorkbenchingRecipe recipe = this.cacheRecipes();
            if (recipe == null) {
                return false;
            }
            RocketPartsItemHandler partsItemHandler = this.getPartsItemHandler();
            for (RocketPart part : recipe.getParts().keySet()) {
                IItemHandlerModifiable subHandler = partsItemHandler.getSubHandlers().get((Object)part);
                for (int i = 0; i < part.getSlots(); ++i) {
                    subHandler.extractItem(i, 1, false);
                }
            }
            World world = this.func_145831_w();
            if (world instanceof ServerWorld) {
                ServerWorld serverWorld = (ServerWorld)world;
                BlockPos pos = this.func_174877_v();
                serverWorld.func_184133_a(null, pos, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("item.totem.use")), SoundCategory.NEUTRAL, 1.0f, 1.0f);
                serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197604_O, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, 100, 0.1, 0.1, 0.1, 0.7);
            }
            return true;
        }

        @Override
        public boolean hasSpaceInOutput() {
            return true;
        }
    }

    public static class CustomBlock
    extends Block
    implements IWaterLoggable {
        public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
        public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

        public CustomBlock() {
            super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200948_a(5.0f, 1.0f).func_235838_a_(s -> 1).harvestLevel(1).harvestTool(ToolType.PICKAXE).func_235861_h_().func_226896_b_().func_235828_a_((bs, br, bp) -> false));
            this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }

        public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
            return true;
        }

        public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
            Vector3d offset = state.func_191059_e(world, pos);
            switch ((Direction)state.func_177229_b((Property)FACING)) {
                default: {
                    return VoxelShapes.func_216384_a((VoxelShape)CustomBlock.func_208617_a((double)16.0, (double)0.0, (double)16.0, (double)0.0, (double)19.2, (double)0.0), (VoxelShape[])new VoxelShape[0]).func_197751_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
                }
                case NORTH: {
                    return VoxelShapes.func_216384_a((VoxelShape)CustomBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)19.2, (double)16.0), (VoxelShape[])new VoxelShape[0]).func_197751_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
                }
                case EAST: {
                    return VoxelShapes.func_216384_a((VoxelShape)CustomBlock.func_208617_a((double)16.0, (double)0.0, (double)0.0, (double)0.0, (double)19.2, (double)16.0), (VoxelShape[])new VoxelShape[0]).func_197751_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
                }
                case WEST: 
            }
            return VoxelShapes.func_216384_a((VoxelShape)CustomBlock.func_208617_a((double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)19.2, (double)0.0), (VoxelShape[])new VoxelShape[0]).func_197751_a(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
        }

        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            builder.func_206894_a(new Property[]{FACING, WATERLOGGED});
        }

        public BlockState func_185499_a(BlockState state, Rotation rot) {
            return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
        }

        public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
            return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
        }

        public BlockState func_196258_a(BlockItemUseContext context) {
            boolean flag = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        }

        public FluidState func_204507_t(BlockState state) {
            return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
        }

        public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
            if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
                world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
            }
            return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
        }

        public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
            List dropsOriginal = super.func_220076_a(state, builder);
            if (!dropsOriginal.isEmpty()) {
                return dropsOriginal;
            }
            return Collections.singletonList(new ItemStack((IItemProvider)this));
        }

        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity entity, Hand hand, BlockRayTraceResult hit) {
            if (entity instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)entity), (INamedContainerProvider)this.func_220052_b(state, world, pos), (BlockPos)pos);
                return ActionResultType.CONSUME;
            }
            return ActionResultType.SUCCESS;
        }

        public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            return tileEntity instanceof INamedContainerProvider ? (INamedContainerProvider)tileEntity : null;
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new CustomTileEntity();
        }

        public boolean func_189539_a(BlockState state, World world, BlockPos pos, int eventID, int eventParam) {
            super.func_189539_a(state, world, pos, eventID, eventParam);
            TileEntity tileentity = world.func_175625_s(pos);
            return tileentity == null ? false : tileentity.func_145842_c(eventID, eventParam);
        }

        public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
            if (state.func_177230_c() != newState.func_177230_c()) {
                CustomTileEntity tileentity = (CustomTileEntity)world.func_175625_s(pos);
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)tileentity);
                world.func_175666_e(pos, (Block)this);
                super.func_196243_a(state, world, pos, newState, isMoving);
            }
        }

        public boolean func_149740_M(BlockState state) {
            return true;
        }

        public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
            CustomTileEntity tileentity = (CustomTileEntity)world.func_175625_s(pos);
            return tileentity.cacheRecipes() != null ? 15 : 0;
        }
    }
}

