/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.machines;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.mrscauthd.boss_tools.ModInnet;
import net.mrscauthd.boss_tools.capability.IOxygenStorage;
import net.mrscauthd.boss_tools.crafting.BossToolsRecipeType;
import net.mrscauthd.boss_tools.crafting.BossToolsRecipeTypes;
import net.mrscauthd.boss_tools.crafting.OxygenMakingRecipeAbstract;
import net.mrscauthd.boss_tools.gui.screens.oxygenbubbledistributor.OxygenBubbleDistributorGui;
import net.mrscauthd.boss_tools.machines.tile.NamedComponentRegistry;
import net.mrscauthd.boss_tools.machines.tile.OxygenMakingTileEntity;
import net.mrscauthd.boss_tools.machines.tile.PowerSystemEnergyCommon;
import net.mrscauthd.boss_tools.machines.tile.PowerSystemRegistry;

public class OxygenBubbleDistributorBlock {
    public static final int ENERGY_PER_TICK = 1;
    public static final String KEY_TIMER = "timer";
    public static final String KEY_RANGE = "range";
    public static final String KEY_WORKINGAREA_VISIBLE = "workingAreaVisible";
    public static final int RANGE_MAX = 15;
    public static final int RANGE_MIN = 1;
    public static final int MAX_TIMER = 4;

    public static class ChangeWorkingAreaVisibleMessage {
        private BlockPos blockPos = BlockPos.field_177992_a;
        private boolean visible = false;

        public ChangeWorkingAreaVisibleMessage() {
        }

        public ChangeWorkingAreaVisibleMessage(BlockPos pos, boolean visible) {
            this.setBlockPos(pos);
            this.setVisible(visible);
        }

        public ChangeWorkingAreaVisibleMessage(PacketBuffer buffer) {
            this.setBlockPos(buffer.func_179259_c());
            this.setVisible(buffer.readBoolean());
        }

        public BlockPos getBlockPos() {
            return this.blockPos;
        }

        public void setBlockPos(BlockPos blockPos) {
            this.blockPos = blockPos;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public static ChangeWorkingAreaVisibleMessage decode(PacketBuffer buffer) {
            return new ChangeWorkingAreaVisibleMessage(buffer);
        }

        public static void encode(ChangeWorkingAreaVisibleMessage message, PacketBuffer buffer) {
            buffer.func_179255_a(message.getBlockPos());
            buffer.writeBoolean(message.isVisible());
        }

        public static void handle(ChangeWorkingAreaVisibleMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            CustomTileEntity tileEntity = (CustomTileEntity)context.getSender().func_71121_q().func_175625_s(message.getBlockPos());
            tileEntity.setWorkingAreaVisible(message.isVisible());
            context.setPacketHandled(true);
        }
    }

    public static class ChangeRangeMessage {
        private BlockPos blockPos = BlockPos.field_177992_a;
        private boolean direction = false;

        public ChangeRangeMessage() {
        }

        public ChangeRangeMessage(BlockPos pos, boolean direction) {
            this.setBlockPos(pos);
            this.setDirection(direction);
        }

        public ChangeRangeMessage(PacketBuffer buffer) {
            this.setBlockPos(buffer.func_179259_c());
            this.setDirection(buffer.readBoolean());
        }

        public BlockPos getBlockPos() {
            return this.blockPos;
        }

        public void setBlockPos(BlockPos blockPos) {
            this.blockPos = blockPos;
        }

        public boolean getDirection() {
            return this.direction;
        }

        public void setDirection(boolean direction) {
            this.direction = direction;
        }

        public static ChangeRangeMessage decode(PacketBuffer buffer) {
            return new ChangeRangeMessage(buffer);
        }

        public static void encode(ChangeRangeMessage message, PacketBuffer buffer) {
            buffer.func_179255_a(message.getBlockPos());
            buffer.writeBoolean(message.getDirection());
        }

        public static void handle(ChangeRangeMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            CustomTileEntity tileEntity = (CustomTileEntity)context.getSender().func_71121_q().func_175625_s(message.getBlockPos());
            int prev = tileEntity.getRange();
            int next = prev + (message.getDirection() ? 1 : -1);
            tileEntity.setRange(next);
            context.setPacketHandled(true);
        }
    }

    public static class CustomTileEntity
    extends OxygenMakingTileEntity {
        public CustomTileEntity() {
            super((TileEntityType)ModInnet.OXYGEN_BUBBLE_DISTRIBUTOR.get());
            this.setWorkingAreaVisible(false);
        }

        @Override
        protected boolean canActivated() {
            if (this.getOutputTank().getOxygenStored() >= this.getOxygenUsing(this.getRange())) {
                return true;
            }
            return super.canActivated();
        }

        @OnlyIn(value=Dist.CLIENT)
        public double func_145833_n() {
            return 256.0;
        }

        public AxisAlignedBB getRenderBoundingBox() {
            return new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()).func_72314_b(32.0, 32.0, 32.0);
        }

        public Container func_213906_a(int id, PlayerInventory player) {
            return new OxygenBubbleDistributorGui.GuiContainer(id, player, this);
        }

        @Override
        protected void createEnergyStorages(NamedComponentRegistry<IEnergyStorage> registry) {
            super.createEnergyStorages(registry);
            registry.put(this.createEnergyStorageCommon());
        }

        @Override
        protected void tickProcessing() {
            super.tickProcessing();
            this.tickDistributeTimer();
        }

        private void tickDistributeTimer() {
            if (this.getTimer() >= this.getMaxTimer()) {
                this.setTimer(0);
                this.distribute();
            }
            this.setTimer(this.getTimer() + 1);
        }

        private void distribute() {
            double range;
            int oxygenUsing;
            IOxygenStorage oxygenStorage = this.getOutputTank();
            if (oxygenStorage.extractOxygen(oxygenUsing = this.getOxygenUsing(range = (double)this.getRange()), true) == oxygenUsing && (this.isProcessedInThisTick() || this.consumePowerForOperation() != null)) {
                oxygenStorage.extractOxygen(oxygenUsing, false);
                this.spawnOxygenBubble(range);
            }
        }

        private void spawnOxygenBubble(double range) {
            World world = this.func_145831_w();
            List entities = world.func_175647_a(LivingEntity.class, this.getWorkingArea(range), null);
            for (LivingEntity entity : entities) {
                entity.func_195064_c(new EffectInstance((Effect)ModInnet.OXYGEN_EFFECT.get(), 48, 0, false, false));
            }
            if (world instanceof ServerWorld) {
                ServerWorld serverWorld = (ServerWorld)world;
                Vector3d center = new AxisAlignedBB(this.func_174877_v()).func_189972_c();
                serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197613_f, center.field_72450_a, center.field_72448_b + 0.5, center.field_72449_c, 1, 0.1, 0.1, 0.1, 0.001);
            }
            this.setProcessedInThisTick();
        }

        public int getMaxTimer() {
            return 4;
        }

        public int getTimer() {
            return this.getTileData().func_74762_e(OxygenBubbleDistributorBlock.KEY_TIMER);
        }

        public void setTimer(int timer) {
            timer = Math.max(timer, 0);
            if (this.getTimer() != timer) {
                this.getTileData().func_74768_a(OxygenBubbleDistributorBlock.KEY_TIMER, timer);
                this.func_70296_d();
            }
        }

        public int getOxygenUsing(double range) {
            return (int)range + 1;
        }

        public int getRange() {
            return Math.max(this.getTileData().func_74762_e(OxygenBubbleDistributorBlock.KEY_RANGE), 1);
        }

        public void setRange(int range) {
            range = Math.min(Math.max(range, 1), 15);
            if (this.getRange() != range) {
                this.getTileData().func_74768_a(OxygenBubbleDistributorBlock.KEY_RANGE, range);
                this.func_70296_d();
            }
        }

        public boolean isWorkingAreaVisible() {
            return this.getTileData().func_74767_n(OxygenBubbleDistributorBlock.KEY_WORKINGAREA_VISIBLE);
        }

        public void setWorkingAreaVisible(boolean visible) {
            if (this.isWorkingAreaVisible() != visible) {
                this.getTileData().func_74757_a(OxygenBubbleDistributorBlock.KEY_WORKINGAREA_VISIBLE, visible);
                this.func_70296_d();
            }
        }

        public AxisAlignedBB getWorkingArea(double range) {
            return this.getWorkingArea(this.func_174877_v(), range);
        }

        public AxisAlignedBB getWorkingArea(BlockPos pos, double range) {
            return new AxisAlignedBB(pos).func_186662_g(range).func_72317_d(0.0, range, 0.0);
        }

        @Override
        protected BooleanProperty getBlockActivatedProperty() {
            return CustomBlock.ACTIAVATED;
        }

        @Override
        protected void createPowerSystems(PowerSystemRegistry map) {
            super.createPowerSystems(map);
            map.put(new PowerSystemEnergyCommon(this){

                @Override
                public int getBasePowerForOperation() {
                    return this.getBasePowerForOperation();
                }
            });
        }

        public int getBasePowerForOperation() {
            return 1;
        }

        @Override
        public BossToolsRecipeType<? extends OxygenMakingRecipeAbstract> getRecipeType() {
            return BossToolsRecipeTypes.OXYGENBUBBLEDISTRIBUTOR;
        }
    }

    public static class CustomBlock
    extends Block {
        public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
        public static final BooleanProperty ACTIAVATED = BlockStateProperties.field_208190_q;

        public CustomBlock() {
            super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200948_a(5.0f, 1.0f).func_235838_a_(s -> 0).harvestLevel(1).harvestTool(ToolType.PICKAXE).func_235861_h_());
            this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)ACTIAVATED, (Comparable)Boolean.valueOf(false)));
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_190948_a(ItemStack itemstack, IBlockReader world, List<ITextComponent> list, ITooltipFlag flag) {
            super.func_190948_a(itemstack, world, list, flag);
            int min = 3;
            int max = 31;
            list.add((ITextComponent)new TranslationTextComponent("tooltip.boss_tools.oxygen_bubble_distributor", new Object[]{min, max}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY)));
        }

        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            builder.func_206894_a(new Property[]{FACING, ACTIAVATED});
        }

        public BlockState func_185499_a(BlockState state, Rotation rot) {
            return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
        }

        public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
            return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
        }

        public BlockState func_196258_a(BlockItemUseContext context) {
            return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
        }

        public PushReaction func_149656_h(BlockState state) {
            return PushReaction.BLOCK;
        }

        public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
            List dropsOriginal = super.func_220076_a(state, builder);
            if (!dropsOriginal.isEmpty()) {
                return dropsOriginal;
            }
            return Collections.singletonList(new ItemStack((IItemProvider)this, 1));
        }

        public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
            return (Boolean)state.func_177229_b((Property)ACTIAVATED) != false ? 12 : 0;
        }

        public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
            return (Boolean)state.func_177229_b((Property)ACTIAVATED) != false ? 12 : 0;
        }

        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity entity, Hand hand, BlockRayTraceResult hit) {
            if (entity instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)entity), (INamedContainerProvider)this.func_220052_b(state, world, pos), (BlockPos)pos);
                return ActionResultType.CONSUME;
            }
            return ActionResultType.SUCCESS;
        }

        public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            return tileEntity instanceof INamedContainerProvider ? (INamedContainerProvider)tileEntity : null;
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new CustomTileEntity();
        }

        public boolean func_189539_a(BlockState state, World world, BlockPos pos, int eventID, int eventParam) {
            super.func_189539_a(state, world, pos, eventID, eventParam);
            TileEntity tileentity = world.func_175625_s(pos);
            return tileentity == null ? false : tileentity.func_145842_c(eventID, eventParam);
        }

        public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
            if (state.func_177230_c() != newState.func_177230_c()) {
                CustomTileEntity tileentity = (CustomTileEntity)world.func_175625_s(pos);
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)tileentity);
                world.func_175666_e(pos, (Block)this);
                super.func_196243_a(state, world, pos, newState, isMoving);
            }
        }

        public boolean func_149740_M(BlockState state) {
            return true;
        }

        public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
            CustomTileEntity tileentity = (CustomTileEntity)world.func_175625_s(pos);
            return Container.func_94526_b((IInventory)tileentity);
        }
    }
}

