/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.machines;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;
import net.mrscauthd.boss_tools.ModInnet;
import net.mrscauthd.boss_tools.gauge.GaugeTextHelper;
import net.mrscauthd.boss_tools.gauge.GaugeValueHelper;
import net.mrscauthd.boss_tools.gui.screens.solarpanel.SolarPanelGui;
import net.mrscauthd.boss_tools.machines.tile.GeneratorTileEntity;

public class SolarPanelBlock {
    public static final int ENERGY_PER_TICK = 5;

    public static class CustomTileEntity
    extends GeneratorTileEntity {
        public CustomTileEntity() {
            super((TileEntityType)ModInnet.SOLAR_PANEL.get());
        }

        public Container func_213906_a(int id, PlayerInventory player) {
            return new SolarPanelGui.GuiContainer(id, player, this);
        }

        protected int getGenerationInTick() {
            return this.getMaxGeneration();
        }

        @Override
        public int getMaxGeneration() {
            return 5;
        }

        @Override
        protected boolean canGenerateEnergy() {
            World world = this.func_145831_w();
            return world.func_72935_r() && (double)world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (int)Math.floor(this.func_174877_v().func_177958_n()), (int)Math.floor(this.func_174877_v().func_177952_p())) <= Math.floor(this.func_174877_v().func_177956_o()) + 1.0;
        }

        @Override
        protected void generateEnergy() {
            this.generateEnergy(this.getGenerationInTick());
        }

        @Override
        protected List<Direction> getEjectDirections() {
            List<Direction> list = super.getEjectDirections();
            list.addAll(Arrays.stream(Direction.values()).filter(d -> d != Direction.UP).collect(Collectors.toList()));
            return list;
        }
    }

    public static class CustomBlock
    extends Block {
        public CustomBlock() {
            super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200948_a(5.0f, 1.0f).func_235838_a_(s -> 1).harvestLevel(1).harvestTool(ToolType.PICKAXE).func_235861_h_());
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_190948_a(ItemStack itemstack, IBlockReader world, List<ITextComponent> list, ITooltipFlag flag) {
            super.func_190948_a(itemstack, world, list, flag);
            list.add((ITextComponent)GaugeTextHelper.buildBlockTooltip(GaugeTextHelper.getGeneratingPerTickText(GaugeValueHelper.getEnergy(5))));
        }

        public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
            return true;
        }

        public PushReaction func_149656_h(BlockState state) {
            return PushReaction.BLOCK;
        }

        public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
            List dropsOriginal = super.func_220076_a(state, builder);
            if (!dropsOriginal.isEmpty()) {
                return dropsOriginal;
            }
            return Collections.singletonList(new ItemStack((IItemProvider)this, 1));
        }

        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity entity, Hand hand, BlockRayTraceResult hit) {
            if (entity instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)entity), (INamedContainerProvider)this.func_220052_b(state, world, pos), (BlockPos)pos);
                return ActionResultType.CONSUME;
            }
            return ActionResultType.SUCCESS;
        }

        public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            return tileEntity instanceof INamedContainerProvider ? (INamedContainerProvider)tileEntity : null;
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new CustomTileEntity();
        }

        public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
            if (state.func_177230_c() != newState.func_177230_c()) {
                CustomTileEntity tileentity = (CustomTileEntity)world.func_175625_s(pos);
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)tileentity);
                world.func_175666_e(pos, (Block)this);
                super.func_196243_a(state, world, pos, newState, isMoving);
            }
        }

        public boolean func_149740_M(BlockState state) {
            return true;
        }

        public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
            CustomTileEntity tileentity = (CustomTileEntity)world.func_175625_s(pos);
            return Container.func_94526_b((IInventory)tileentity);
        }
    }
}

