/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.machines.tile;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.mrscauthd.boss_tools.capability.EnergyStorageBasic;
import net.mrscauthd.boss_tools.capability.IEnergyStorageHolder;
import net.mrscauthd.boss_tools.crafting.FluidIngredient;
import net.mrscauthd.boss_tools.gauge.GaugeValueHelper;
import net.mrscauthd.boss_tools.gauge.IGaugeValue;
import net.mrscauthd.boss_tools.machines.tile.NamedComponentRegistry;
import net.mrscauthd.boss_tools.machines.tile.PowerSystem;
import net.mrscauthd.boss_tools.machines.tile.PowerSystemFuel;
import net.mrscauthd.boss_tools.machines.tile.PowerSystemRegistry;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractMachineTileEntity
extends LockableLootTileEntity
implements ISidedInventory,
ITickableTileEntity,
IEnergyStorageHolder {
    public static final String KEY_ACTIVATED = "activated";
    private Map<Object, Object> selectedPrimaries = new HashMap<Object, Object>();
    private Map<ResourceLocation, IEnergyStorage> energyStorages;
    private final Map<ResourceLocation, IFluidHandler> fluidHandlers;
    private final Map<ResourceLocation, PowerSystem> powerSystems;
    private NonNullList<ItemStack> stacks = null;
    private final LazyOptional<? extends IItemHandler>[] itemHandlers;
    private boolean processedInThisTick = false;

    public AbstractMachineTileEntity(TileEntityType<?> type) {
        super(type);
        NamedComponentRegistry<IEnergyStorage> energyRegistry = new NamedComponentRegistry<IEnergyStorage>();
        this.createEnergyStorages(energyRegistry);
        this.energyStorages = Collections.unmodifiableMap(energyRegistry);
        NamedComponentRegistry<IFluidHandler> fluidRegistry = new NamedComponentRegistry<IFluidHandler>();
        this.createFluidHandlers(fluidRegistry);
        this.fluidHandlers = Collections.unmodifiableMap(fluidRegistry);
        PowerSystemRegistry powerSystemMap = new PowerSystemRegistry();
        this.createPowerSystems(powerSystemMap);
        this.powerSystems = Collections.unmodifiableMap(powerSystemMap);
        this.itemHandlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])Direction.values());
        this.createItemHandlers();
        this.stacks = NonNullList.func_191197_a((int)this.getInitialInventorySize(), (Object)ItemStack.field_190927_a);
    }

    public ITextComponent func_213907_g() {
        ResourceLocation registryName = this.func_200662_C().getRegistryName();
        return new TranslationTextComponent("container." + registryName.func_110624_b() + "." + registryName.func_110623_a());
    }

    protected void createItemHandlers() {
    }

    public boolean isPowerEnoughForOperation() {
        return this.getPowerSystems().values().stream().allMatch(ps -> ps.isPowerEnoughForOperation());
    }

    @Nullable
    public Map<PowerSystem, Integer> consumePowerForOperation() {
        if (this.isPowerEnoughForOperation()) {
            return this.getPowerSystems().values().stream().collect(Collectors.toMap(ps -> ps, ps -> ps.consumeForOperation()));
        }
        return null;
    }

    public int getPowerPerTick(PowerSystem powerSystem, int base) {
        return base;
    }

    public int getPowerForOperation(PowerSystem powerSystem, int base) {
        return base;
    }

    protected int getInitialInventorySize() {
        return this.getPowerSystems().values().stream().collect(Collectors.summingInt(ps -> ps.getUsingSlots()));
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        super.func_230337_a_(blockState, compound);
        if (!this.func_184283_b(compound)) {
            this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        }
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.stacks);
        this.deserializeCompoents(this.getEnergyStorages(), compound.func_74775_l("energyStorages"));
        this.deserializeCompoents(this.getFluidHandlers(), compound.func_74775_l("fluidHandlers"));
        this.deserializeCompoents(this.getPowerSystems(), compound.func_74775_l("powerSystems"));
    }

    public <T> void deserializeCompoents(Map<ResourceLocation, T> registry, @Nonnull CompoundNBT compound) {
        for (Map.Entry<ResourceLocation, T> entry : registry.entrySet()) {
            INBT nbt = compound.func_74781_a(entry.getKey().toString());
            if (nbt == null) continue;
            this.deserializeComponent(entry.getKey(), entry.getValue(), nbt);
        }
    }

    public <T> void deserializeComponent(ResourceLocation name, @Nonnull T component, @Nonnull INBT nbt) {
        if (component == null || nbt == null) {
            return;
        }
        if (component instanceof INBTSerializable) {
            ((INBTSerializable)component).deserializeNBT(nbt);
        } else if (component instanceof EnergyStorage) {
            CapabilityEnergy.ENERGY.readNBT((Object)((EnergyStorage)component), null, nbt);
        } else if (component instanceof FluidTank) {
            CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.readNBT((Object)((FluidTank)component), null, nbt);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((CompoundNBT)compound, this.stacks);
        }
        compound.func_218657_a("energyStorages", (INBT)this.serializeComponents(this.getEnergyStorages()));
        compound.func_218657_a("fluidHandlers", (INBT)this.serializeComponents(this.getFluidHandlers()));
        compound.func_218657_a("powerSystems", (INBT)this.serializeComponents(this.getPowerSystems()));
        return compound;
    }

    @Nonnull
    public <T> CompoundNBT serializeComponents(Map<ResourceLocation, T> registry) {
        CompoundNBT compound = new CompoundNBT();
        for (Map.Entry<ResourceLocation, T> entry : registry.entrySet()) {
            INBT nbt = this.serializeComponent(entry.getKey(), entry.getValue());
            if (nbt == null) continue;
            compound.func_218657_a(entry.getKey().toString(), nbt);
        }
        return compound;
    }

    @Nullable
    public <T> INBT serializeComponent(ResourceLocation name, @Nonnull T component) {
        if (component == null) {
            return null;
        }
        if (component instanceof INBTSerializable) {
            return ((INBTSerializable)component).serializeNBT();
        }
        if (component instanceof EnergyStorage) {
            return CapabilityEnergy.ENERGY.writeNBT((Object)((EnergyStorage)component), null);
        }
        if (component instanceof FluidTank) {
            return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.writeNBT((Object)((FluidTank)component), null);
        }
        return null;
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.stacks;
    }

    protected void func_199721_a(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    protected void getSlotsForFace(Direction direction, List<Integer> slots) {
        this.getPowerSystems().values().stream().forEach(ps -> ps.getSlotsForFace(direction, slots));
    }

    public int[] func_180463_a(Direction side) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        this.getSlotsForFace(side, slots);
        return Ints.toArray(slots);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.onCanInsertItem(index, stack, null);
    }

    public final boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        ItemStack stackInSlot;
        boolean result = this.onCanInsertItem(index, stack, direction);
        if (result && !(stackInSlot = this.func_70301_a(index)).func_190926_b() && ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)stack)) {
            int limit = Math.min(stack.func_77976_d(), this.func_70297_j_());
            if (stackInSlot.func_190916_E() + stack.func_190916_E() > limit) {
                return false;
            }
        }
        return result;
    }

    protected boolean onCanInsertItem(int index, ItemStack stack, @Nullable Direction direction) {
        return this.getPowerSystems().values().stream().anyMatch(ps -> ps.canInsertItem(direction, index, stack));
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return this.getPowerSystems().values().stream().anyMatch(ps -> ps.canExtractItem(direction, index, stack));
    }

    public <T> LazyOptional<T> getCapabilityItemHandler(Capability<T> capability, @Nullable Direction facing) {
        if (facing != null) {
            return this.itemHandlers[facing.ordinal()].cast();
        }
        return super.getCapability(capability, facing);
    }

    public <T> LazyOptional<T> getCapabilityEnergy(Capability<T> capability, @Nullable Direction facing) {
        IEnergyStorage energyStorage = this.getPrimaryEnergyStorage();
        if (energyStorage != null) {
            return LazyOptional.of(() -> energyStorage).cast();
        }
        return LazyOptional.empty();
    }

    public <T> LazyOptional<T> getCapabilityFluidHandler(Capability<T> capability, @Nullable Direction facing) {
        IFluidHandler fluidHandler = this.getPrimaryFluidHandler();
        if (fluidHandler != null) {
            return LazyOptional.of(() -> fluidHandler).cast();
        }
        return LazyOptional.empty();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f) {
            LazyOptional<T> optional;
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? (optional = this.getCapabilityItemHandler(capability, facing)) != null && optional.isPresent() : (capability == CapabilityEnergy.ENERGY ? (optional = this.getCapabilityEnergy(capability, facing)) != null && optional.isPresent() : capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (optional = this.getCapabilityFluidHandler(capability, facing)) != null && optional.isPresent())) {
                return optional;
            }
            for (PowerSystem powerSystem : this.getPowerSystems().values()) {
                LazyOptional<T> optional2 = powerSystem.getCapability(capability, facing);
                if (optional2 == null || !optional2.isPresent()) continue;
                return optional2;
            }
        }
        return super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        Arrays.stream(this.itemHandlers).forEach(h -> h.invalidate());
    }

    public void func_73660_a() {
        World world = this.func_145831_w();
        if (world.func_201670_d()) {
            return;
        }
        this.onTickProcessingPre();
        if (this.canTickProcessing()) {
            this.tickProcessing();
        }
        this.onTickProcessingPost();
        this.updatePowerSystem();
        this.updateActivated();
        this.refreshBlockActivatedChanged();
    }

    protected void updatePowerSystem() {
        this.getPowerSystems().values().forEach(ps -> ps.update());
    }

    protected BooleanProperty getBlockActivatedProperty() {
        return BlockStateProperties.field_208190_q;
    }

    protected void refreshBlockActivatedChanged() {
        BooleanProperty property = this.getBlockActivatedProperty();
        if (property == null) {
            return;
        }
        World world = this.func_145831_w();
        BlockPos pos = this.func_174877_v();
        BlockState state = this.func_195044_w();
        boolean activated = this.isActivated();
        if (state.func_235901_b_((Property)property) && (Boolean)state.func_177229_b((Property)property) != activated) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)property, (Comparable)Boolean.valueOf(activated)), 3);
        }
    }

    protected void onTickProcessingPre() {
        this.processedInThisTick = false;
    }

    protected boolean canTickProcessing() {
        return true;
    }

    protected abstract void tickProcessing();

    protected void onTickProcessingPost() {
    }

    public void updateActivated() {
        this.setActivated(this.canActivated());
    }

    protected boolean canActivated() {
        PowerSystem primary;
        ArrayList powerSystems = Lists.newArrayList(this.getPowerSystems().values());
        if (powerSystems.size() == 1 && (primary = (PowerSystem)powerSystems.get(0)) instanceof PowerSystemFuel) {
            return primary.isPowerEnoughForOperation();
        }
        return this.processedInThisTick;
    }

    @Nonnull
    protected void createPowerSystems(PowerSystemRegistry map) {
    }

    public Map<ResourceLocation, PowerSystem> getPowerSystems() {
        return this.powerSystems;
    }

    @Nullable
    protected void createFluidHandlers(NamedComponentRegistry<IFluidHandler> registry) {
    }

    public Map<ResourceLocation, IFluidHandler> getFluidHandlers() {
        return this.fluidHandlers;
    }

    public IFluidHandler getPrimaryFluidHandler() {
        return this.getPrimaryComponent(this.getFluidHandlers());
    }

    @Nullable
    protected void createEnergyStorages(NamedComponentRegistry<IEnergyStorage> registry) {
    }

    public Map<ResourceLocation, IEnergyStorage> getEnergyStorages() {
        return this.energyStorages;
    }

    @Nullable
    public IEnergyStorage getPrimaryEnergyStorage() {
        return this.getPrimaryComponent(this.getEnergyStorages());
    }

    protected IEnergyStorage createEnergyStorageCommon() {
        return new EnergyStorageBasic(this, 9000, 200, 200);
    }

    @Nonnull
    public <T> T getPrimaryComponent(Map<ResourceLocation, T> map) {
        return (T)this.selectedPrimaries.computeIfAbsent(map, k -> this.selectPrimaryComponent((Map)k));
    }

    protected <T> T selectPrimaryComponent(Map<ResourceLocation, T> map) {
        if (map.containsKey(NamedComponentRegistry.UNNAMED)) {
            return map.get(NamedComponentRegistry.UNNAMED);
        }
        return map.values().stream().findFirst().orElse(null);
    }

    public IItemHandlerModifiable getItemHandler() {
        return (IItemHandlerModifiable)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).resolve().get();
    }

    public boolean isActivated() {
        return this.getTileData().func_74767_n(KEY_ACTIVATED);
    }

    protected void setActivated(boolean activated) {
        if (this.isActivated() != activated) {
            this.getTileData().func_74757_a(KEY_ACTIVATED, activated);
            this.func_70296_d();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        World world = this.func_145831_w();
        if (world instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)world;
            serverWorld.func_72863_F().func_217217_a(this.func_174877_v());
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    @Override
    public void onEnergyChanged(IEnergyStorage energyStorage, int energyDelta) {
        this.func_70296_d();
    }

    protected boolean isProcessedInThisTick() {
        return this.processedInThisTick;
    }

    protected void setProcessedInThisTick() {
        this.processedInThisTick = true;
    }

    public abstract boolean hasSpaceInOutput();

    public boolean nullOrMatch(@Nullable Direction direction, Direction ... matches) {
        return direction == null || ArrayUtils.contains((Object[])matches, (Object)direction);
    }

    public boolean hasSpaceInOutput(ItemStack recipeOutput, ItemStack output) {
        if (output.func_190926_b()) {
            return true;
        }
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)output, (ItemStack)recipeOutput)) {
            int limit = Math.min(recipeOutput.func_77976_d(), this.func_70297_j_());
            return output.func_190916_E() + recipeOutput.func_190916_E() <= limit;
        }
        return false;
    }

    public boolean hasSpaceInOutput(FluidIngredient recipeOutput, IFluidTank tank) {
        return this.hasSpaceInOutput(recipeOutput, tank.getFluid(), tank.getCapacity());
    }

    public boolean hasSpaceInOutput(FluidIngredient recipeOutput, FluidStack output, int capacity) {
        if (output.isEmpty()) {
            return true;
        }
        if (recipeOutput.testFluid(output.getFluid())) {
            return output.getAmount() + recipeOutput.getAmount() <= capacity;
        }
        return false;
    }

    public List<IGaugeValue> getFluidHandlerGaugeValues(IFluidHandler fluidHandler) {
        ArrayList<IGaugeValue> list = new ArrayList<IGaugeValue>();
        for (int i = 0; i < fluidHandler.getTanks(); ++i) {
            list.add(GaugeValueHelper.getFluid(fluidHandler.getFluidInTank(i), fluidHandler.getTankCapacity(i)));
        }
        return list;
    }

    public List<IGaugeValue> getGaugeValues() {
        ArrayList<IGaugeValue> list = new ArrayList<IGaugeValue>();
        this.getPowerSystems().values().stream().map(PowerSystem::getGaugeValues).forEach(list::addAll);
        return list;
    }
}

