/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.machines.tile;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.mrscauthd.boss_tools.capability.EnergyStorageExtractaOnly;
import net.mrscauthd.boss_tools.machines.tile.AbstractMachineTileEntity;
import net.mrscauthd.boss_tools.machines.tile.NamedComponentRegistry;

public abstract class GeneratorTileEntity
extends AbstractMachineTileEntity {
    public static final String KEY_GENERATING = "generating";
    private IEnergyStorage internalEnergyStorage;
    private IEnergyStorage energyStorage;
    private int generatingCache;

    protected GeneratorTileEntity(TileEntityType<?> type) {
        super(type);
    }

    @Override
    protected void onTickProcessingPost() {
        super.onTickProcessingPost();
        this.setGenerating(this.generatingCache);
        this.generatingCache = 0;
    }

    @Override
    protected void tickProcessing() {
        if (this.canGenerateEnergy() && this.hasSpaceInOutput() && this.consumePowerForOperation() != null) {
            this.generateEnergy();
        }
        this.ejectEnergy();
    }

    protected abstract boolean canGenerateEnergy();

    protected abstract void generateEnergy();

    protected void generateEnergy(int energy) {
        this.generatingCache += this.getInternalEnergyStorage().receiveEnergy(energy, false);
        this.setProcessedInThisTick();
    }

    @Override
    protected void createEnergyStorages(NamedComponentRegistry<IEnergyStorage> registry) {
        super.createEnergyStorages(registry);
        this.internalEnergyStorage = this.createGeneratingEnergyStorage();
        this.energyStorage = new EnergyStorageExtractaOnly(this.internalEnergyStorage, this.internalEnergyStorage.getMaxEnergyStored());
        registry.put(this.internalEnergyStorage);
    }

    protected IEnergyStorage createGeneratingEnergyStorage() {
        return this.createEnergyStorageCommon();
    }

    protected void ejectEnergy() {
        IEnergyStorage source = this.getGeneratingEnergyStorage();
        int ejectingEnergy = source.extractEnergy(this.getEjectingExtractEnergy(), true);
        List<IEnergyStorage> sinks = this.findNearEnergyStorages();
        ArrayList<EjectingTuple> tuples = new ArrayList<EjectingTuple>();
        for (int i = 0; i < sinks.size(); ++i) {
            IEnergyStorage sink = sinks.get(i);
            EjectingTuple e = new EjectingTuple(sink);
            e.receivable = sink.receiveEnergy(ejectingEnergy, true);
            e.receiving = 0;
            tuples.add(e);
        }
        ejectingEnergy = this.calculateBalance(ejectingEnergy, tuples);
        ejectingEnergy = this.calculateRemained(ejectingEnergy, tuples);
        for (EjectingTuple tuple : tuples) {
            int extracted = source.extractEnergy(tuple.receiving, false);
            tuple.energyStorage.receiveEnergy(extracted, false);
        }
    }

    private int calculateRemained(int energy, List<EjectingTuple> tuples) {
        int fullCount;
        int tuplesSize = tuples.size();
        int remainCount = tuplesSize - (fullCount = (int)tuples.stream().filter(EjectingTuple::isFull).count());
        if (remainCount > 0) {
            int divided = (int)Math.ceil((double)energy / (double)remainCount);
            for (int i = 0; i < tuplesSize; ++i) {
                EjectingTuple tuple = tuples.get(i);
                if (tuple.isFull()) continue;
                if (energy <= 0) break;
                int give = Math.min(divided, energy);
                tuple.receiving += give;
                energy -= give;
                int over = tuple.receiving - tuple.receivable;
                if (over < 0) continue;
                energy += over;
            }
        }
        return energy;
    }

    private int calculateBalance(int energy, List<EjectingTuple> tuples) {
        ArrayList<EjectingTuple> orderedReceivables = new ArrayList<EjectingTuple>(tuples);
        orderedReceivables.sort((o1, o2) -> o1.receivable - o2.receivable);
        for (int i = 0; i < orderedReceivables.size(); ++i) {
            int amount;
            int n = amount = i == 0 ? ((EjectingTuple)orderedReceivables.get((int)i)).receivable : ((EjectingTuple)orderedReceivables.get((int)i)).receivable - ((EjectingTuple)orderedReceivables.get((int)(i - 1))).receivable;
            if (amount <= 0) continue;
            int amountSum = 0;
            int receiveCount = 0;
            for (int j = 0; j < tuples.size(); ++j) {
                if (tuples.get(j).isFull()) continue;
                amountSum += amount;
                ++receiveCount;
            }
            if (receiveCount == 0) break;
            int give = 0;
            give = amountSum > energy ? Math.floorDiv(energy, receiveCount) : amount;
            for (int j = 0; j < tuples.size(); ++j) {
                EjectingTuple tuple = tuples.get(j);
                if (tuple.isFull()) continue;
                tuple.receiving += give;
                energy -= give;
                int over = tuple.receiving - tuple.receivable;
                if (over < 0) continue;
                energy += over;
            }
        }
        return energy;
    }

    protected List<IEnergyStorage> findNearEnergyStorages() {
        ArrayList<IEnergyStorage> energyStorages = new ArrayList<IEnergyStorage>();
        for (Direction direction : this.getEjectDirections()) {
            LazyOptional capability;
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
            if (tileEntity == null || (capability = tileEntity.getCapability(CapabilityEnergy.ENERGY, direction.func_176734_d())) == null || !capability.isPresent()) continue;
            energyStorages.add((IEnergyStorage)capability.resolve().get());
        }
        return energyStorages;
    }

    protected int getEjectingExtractEnergy() {
        return this.getMaxGeneration();
    }

    protected List<Direction> getEjectDirections() {
        return new ArrayList<Direction>();
    }

    @Override
    public boolean hasSpaceInOutput() {
        return this.getInternalEnergyStorage().receiveEnergy(1, true) > 0;
    }

    @Override
    public IEnergyStorage getPrimaryEnergyStorage() {
        return this.getGeneratingEnergyStorage();
    }

    protected IEnergyStorage getInternalEnergyStorage() {
        return this.internalEnergyStorage;
    }

    public IEnergyStorage getGeneratingEnergyStorage() {
        return this.energyStorage;
    }

    public int getGenerating() {
        return this.getTileData().func_74762_e(KEY_GENERATING);
    }

    public void setGenerating(int generating) {
        generating = Math.max(generating, 0);
        if (this.getGenerating() != generating) {
            this.getTileData().func_74768_a(KEY_GENERATING, generating);
            this.func_70296_d();
        }
    }

    public double getGeneratingRatio() {
        return (double)this.getGenerating() / (double)this.getMaxGeneration();
    }

    public abstract int getMaxGeneration();

    public class EjectingTuple {
        public final IEnergyStorage energyStorage;
        public int receivable;
        public int receiving;

        public EjectingTuple(IEnergyStorage energyStorage) {
            this.energyStorage = energyStorage;
        }

        public boolean isFull() {
            return this.receiving >= this.receivable;
        }
    }
}

