/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.machines.tile;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.mrscauthd.boss_tools.capability.CapabilityOxygen;
import net.mrscauthd.boss_tools.capability.IOxygenStorage;
import net.mrscauthd.boss_tools.capability.IOxygenStorageHolder;
import net.mrscauthd.boss_tools.capability.OxygenStorage;
import net.mrscauthd.boss_tools.compat.CompatibleManager;
import net.mrscauthd.boss_tools.compat.mekanism.MekanismHelper;
import net.mrscauthd.boss_tools.compat.mekanism.OxygenStorageGasAdapter;
import net.mrscauthd.boss_tools.crafting.BossToolsRecipeType;
import net.mrscauthd.boss_tools.crafting.OxygenMakingRecipeAbstract;
import net.mrscauthd.boss_tools.fluid.FluidUtil2;
import net.mrscauthd.boss_tools.gauge.GaugeValueHelper;
import net.mrscauthd.boss_tools.gauge.IGaugeValue;
import net.mrscauthd.boss_tools.inventory.StackCacher;
import net.mrscauthd.boss_tools.machines.tile.AbstractMachineTileEntity;
import net.mrscauthd.boss_tools.machines.tile.NamedComponentRegistry;

public abstract class OxygenMakingTileEntity
extends AbstractMachineTileEntity {
    public static final int TANK_CAPACITY = 3000;
    public static final int TRANSFER_PER_TICK = 256;
    public static final ResourceLocation TANK_INPUT = new ResourceLocation("boss_tools", "input");
    public static final ResourceLocation TANK_OUTPUT = new ResourceLocation("boss_tools", "output");
    public static final int SLOT_INPUT_SOURCE = 0;
    public static final int SLOT_INPUT_SINK = 1;
    private FluidTank inputTank;
    private OxygenStorage outputTank;
    private StackCacher recipeCacher = new StackCacher();
    private OxygenMakingRecipeAbstract cachedRecipe = null;

    public OxygenMakingTileEntity(TileEntityType<?> type) {
        super(type);
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT compound) {
        super.func_230337_a_(blockState, compound);
        CapabilityOxygen.OXYGEN.readNBT((Object)this.getOutputTank(), null, (INBT)compound.func_74775_l("outputTank"));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("outputTank", CapabilityOxygen.OXYGEN.writeNBT((Object)this.getOutputTank(), null));
        return compound;
    }

    @Override
    public List<IGaugeValue> getGaugeValues() {
        List<IGaugeValue> list = super.getGaugeValues();
        if (!CompatibleManager.MEKANISM.isLoaded()) {
            list.add(GaugeValueHelper.getOxygen(this.getOutputTank()));
        }
        return list;
    }

    @Override
    protected void createFluidHandlers(NamedComponentRegistry<IFluidHandler> registry) {
        super.createFluidHandlers(registry);
        this.inputTank = (FluidTank)registry.computeIfAbsent(this.getInputTankName(), k -> this.creatFluidTank((ResourceLocation)k));
        this.outputTank = this.createOxygenTank(this.getOutputTankName());
    }

    protected int getInitialTankCapacity(ResourceLocation name) {
        return 3000;
    }

    protected FluidTank creatFluidTank(ResourceLocation name) {
        return new FluidTank(this.getInitialTankCapacity(name)){

            protected void onContentsChanged() {
                super.onContentsChanged();
                OxygenMakingTileEntity.this.func_70296_d();
            }
        };
    }

    protected OxygenStorage createOxygenTank(ResourceLocation name) {
        return new OxygenStorage(new IOxygenStorageHolder(){

            @Override
            public void onOxygenChanged(IOxygenStorage oxygenStorage, int oxygenDelta) {
                OxygenMakingTileEntity.this.func_70296_d();
            }
        }, this.getInitialTankCapacity(name));
    }

    @Override
    protected void tickProcessing() {
        this.drainSources();
        this.consumeIngredients();
        this.fillSinks();
    }

    public boolean consumeIngredients() {
        int oxygen;
        OxygenMakingRecipeAbstract recipe = this.cacheRecipe();
        if (recipe != null && this.hasSpaceInOutput(oxygen = recipe.getOxygen()) && this.consumePowerForOperation() != null) {
            this.getInputTank().drain(recipe.getInput().getAmount(), IFluidHandler.FluidAction.EXECUTE);
            this.getOutputTank().receiveOxygen(oxygen, false);
            this.setProcessedInThisTick();
            return true;
        }
        return false;
    }

    protected void drainSources() {
        FluidUtil2.drainSource(this.getItemHandler(), this.getInputSourceSlot(), (IFluidHandler)this.getInputTank(), this.getTransferPerTick());
    }

    protected void fillSinks() {
        FluidUtil2.fillSink(this.getItemHandler(), this.getInputSinkSlot(), (IFluidHandler)this.getInputTank(), this.getTransferPerTick());
    }

    @Override
    public <T> LazyOptional<T> getCapabilityFluidHandler(Capability<T> capability, @Nullable Direction facing) {
        return LazyOptional.of(this::getInputTank).cast();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (CompatibleManager.MEKANISM.isLoaded() && capability == MekanismHelper.getGasHandlerCapability()) {
            return LazyOptional.of(() -> new OxygenStorageGasAdapter(this.getOutputTank(), true, true)).cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected void getSlotsForFace(Direction direction, List<Integer> slots) {
        super.getSlotsForFace(direction, slots);
        slots.add(this.getInputSourceSlot());
    }

    @Override
    protected boolean onCanInsertItem(int index, ItemStack stack, Direction direction) {
        if (index == this.getInputSourceSlot()) {
            return FluidUtil2.canDrain(stack);
        }
        if (index == this.getInputSinkSlot()) {
            FluidTank tank = this.slotToFluidTank(index);
            return FluidUtil2.canFill(stack, tank.getFluid().getFluid());
        }
        return super.onCanInsertItem(index, stack, direction);
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        if (index == this.getInputSourceSlot()) {
            return !FluidUtil2.canDrain(stack);
        }
        if (index == this.getInputSinkSlot()) {
            FluidTank tank = this.slotToFluidTank(index);
            return !FluidUtil2.canFill(stack, tank.getFluid().getFluid());
        }
        return super.func_180461_b(index, stack, direction);
    }

    @Override
    public boolean hasSpaceInOutput() {
        OxygenMakingRecipeAbstract recipe = this.cacheRecipe();
        return recipe != null && this.hasSpaceInOutput(recipe.getOxygen());
    }

    public boolean hasSpaceInOutput(int oxygen) {
        return this.hasSpaceInOutput(oxygen, this.getOutputTank());
    }

    public boolean hasSpaceInOutput(int oxygen, IOxygenStorage storage) {
        return oxygen + storage.getOxygenStored() <= storage.getMaxOxygenStored();
    }

    public OxygenMakingRecipeAbstract cacheRecipe() {
        FluidStack fluidStack = this.getInputTank().getFluid();
        if (fluidStack.isEmpty()) {
            this.recipeCacher.set(fluidStack);
            this.cachedRecipe = null;
        } else if (!this.recipeCacher.test(fluidStack)) {
            this.recipeCacher.set(fluidStack);
            this.cachedRecipe = this.getRecipeType().findFirst(this.func_145831_w(), r -> r.test(fluidStack));
        }
        return this.cachedRecipe;
    }

    public abstract BossToolsRecipeType<? extends OxygenMakingRecipeAbstract> getRecipeType();

    @Override
    protected int getInitialInventorySize() {
        return super.getInitialInventorySize() + 2;
    }

    public int func_70297_j_() {
        return 1;
    }

    public int getInputSourceSlot() {
        return 0;
    }

    public int getInputSinkSlot() {
        return 1;
    }

    public boolean isSourceSlot(int slot) {
        return slot == this.getInputSourceSlot();
    }

    public boolean isSinkSlot(int slot) {
        return slot == this.getInputSinkSlot();
    }

    public FluidTank slotToFluidTank(int slot) {
        if (slot == this.getInputSourceSlot() || slot == this.getInputSinkSlot()) {
            return this.getInputTank();
        }
        return null;
    }

    public IOxygenStorage slotToOxygenTank(int slot) {
        return null;
    }

    public ResourceLocation slotToTankName(int slot) {
        if (slot == this.getInputSourceSlot() || slot == this.getInputSinkSlot()) {
            return this.getInputTankName();
        }
        return null;
    }

    public ResourceLocation getInputTankName() {
        return TANK_INPUT;
    }

    public FluidTank getInputTank() {
        return this.inputTank;
    }

    public ResourceLocation getOutputTankName() {
        return TANK_OUTPUT;
    }

    public IOxygenStorage getOutputTank() {
        return this.outputTank;
    }

    public int getTransferPerTick() {
        return 256;
    }
}

