/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.machines.tile;

import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.mrscauthd.boss_tools.ModInnet;
import net.mrscauthd.boss_tools.capability.FluidHandlerWrapper;
import net.mrscauthd.boss_tools.fluid.FluidUtil2;
import net.mrscauthd.boss_tools.gui.screens.waterpump.WaterPumpGui;
import net.mrscauthd.boss_tools.machines.WaterPump;
import net.mrscauthd.boss_tools.machines.tile.AbstractMachineTileEntity;
import net.mrscauthd.boss_tools.machines.tile.NamedComponentRegistry;
import net.mrscauthd.boss_tools.machines.tile.PowerSystemEnergyCommon;
import net.mrscauthd.boss_tools.machines.tile.PowerSystemRegistry;

public class WaterPumpTileEntity
extends AbstractMachineTileEntity {
    public static final int TRANSFER_PER_TICK = 10;
    public static final ResourceLocation WATER_TANK = new ResourceLocation("boss_tools", "water_tank");
    public static final int TANK_CAPACITY = 6000;
    public double WATER_TIMER = 0.0;
    private FluidTank waterTank;

    public WaterPumpTileEntity() {
        super((TileEntityType)ModInnet.WATER_PUMP.get());
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new WaterPumpGui.GuiContainer(id, player, this);
    }

    @Override
    protected void tickProcessing() {
        BlockPos pos = new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p());
        if (this.field_145850_b.func_204610_c(pos) == Fluids.field_204546_a.func_207204_a(false)) {
            int transferPerTick;
            IFluidHandler fluidHandler;
            TileEntity tileEntity;
            if (this.hasSpaceInWaterTank(this.getWaterTank().getFluid().getAmount()) && this.consumePowerForOperation() != null) {
                this.WATER_TIMER += 1.0;
                if (this.WATER_TIMER > 10.0) {
                    ((IBucketPickupHandler)this.field_145850_b.func_180495_p(pos).func_177230_c()).func_204508_a((IWorld)this.field_145850_b, pos, this.field_145850_b.func_180495_p(pos));
                    this.getWaterTank().fill(new FluidStack((Fluid)Fluids.field_204546_a, 1000), IFluidHandler.FluidAction.EXECUTE);
                    this.WATER_TIMER = 0.0;
                }
            }
            if (this.getWaterTank().getFluid().getAmount() > 1 && (tileEntity = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p()))) != null && (fluidHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.DOWN).orElse(null)) != null && FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)this.waterTank, (int)(transferPerTick = this.getTransferPerTick()), (boolean)false).getAmount() == transferPerTick) {
                FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)this.waterTank, (int)transferPerTick, (boolean)true);
            }
        }
    }

    public int getTransferPerTick() {
        return 10;
    }

    public boolean hasSpaceInWaterTank(int water) {
        return this.hasSpaceIn(water, this.getWaterTank().getFluid());
    }

    public boolean hasSpaceIn(int water, FluidStack storage) {
        return water < 5001;
    }

    @Override
    public <T> LazyOptional<T> getCapabilityFluidHandler(Capability<T> capability, Direction facing) {
        if (facing == null || facing == Direction.UP) {
            return super.getCapabilityFluidHandler(capability, facing).lazyMap(handler -> new FluidHandlerWrapper((IFluidHandler)handler, true, false)).cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public <T> LazyOptional<T> getCapabilityEnergy(Capability<T> capability, Direction facing) {
        BlockState blockState = this.func_195044_w();
        if (blockState.func_235901_b_((Property)WaterPump.FACING)) {
            Direction blockDirection = (Direction)blockState.func_177229_b((Property)WaterPump.FACING);
            if (facing == null || facing == blockDirection) {
                return super.getCapabilityEnergy(capability, facing);
            }
        }
        return LazyOptional.empty();
    }

    @Override
    protected void createPowerSystems(PowerSystemRegistry map) {
        super.createPowerSystems(map);
        map.put(new PowerSystemEnergyCommon(this){

            @Override
            public int getBasePowerForOperation() {
                return WaterPumpTileEntity.this.getBasePowerForOperation();
            }
        });
    }

    @Override
    protected void createEnergyStorages(NamedComponentRegistry<IEnergyStorage> registry) {
        super.createEnergyStorages(registry);
        registry.put(this.createEnergyStorageCommon());
    }

    public int getBasePowerForOperation() {
        return 1;
    }

    @Override
    protected void createFluidHandlers(NamedComponentRegistry<IFluidHandler> registry) {
        super.createFluidHandlers(registry);
        this.waterTank = (FluidTank)registry.computeIfAbsent(this.getTankName(), k -> this.creatTank((ResourceLocation)k));
    }

    protected int getInitialTankCapacity(ResourceLocation name) {
        return 6000;
    }

    protected Predicate<FluidStack> getInitialTankValidator(ResourceLocation name) {
        Fluid fluid = this.getTankFluid(name);
        return fluid != null ? fs -> FluidUtil2.isEquivalentTo(fs, fluid) : null;
    }

    protected Fluid getTankFluid(ResourceLocation name) {
        if (name.equals((Object)this.getTankName())) {
            return Fluids.field_204546_a;
        }
        return null;
    }

    protected FluidTank creatTank(ResourceLocation name) {
        return new FluidTank(this.getInitialTankCapacity(name), this.getInitialTankValidator(name)){

            protected void onContentsChanged() {
                super.onContentsChanged();
                WaterPumpTileEntity.this.func_70296_d();
            }
        };
    }

    public ResourceLocation getTankName() {
        return WATER_TANK;
    }

    public FluidTank getWaterTank() {
        return this.waterTank;
    }

    @Override
    public boolean hasSpaceInOutput() {
        return false;
    }
}

