/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.boss_tools.mixin;

import net.minecraft.entity.item.ItemEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.mrscauthd.boss_tools.events.Methodes;
import net.mrscauthd.boss_tools.events.forgeevents.ItemGravityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class MixinItemGravity {
    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void tick(CallbackInfo info) {
        ItemEntity w = (ItemEntity)this;
        if (MixinItemGravity.GravityCheckItem(w)) {
            if (Methodes.isWorld(w.field_70170_p, new ResourceLocation("boss_tools", "moon"))) {
                MixinItemGravity.itemGravityMath(w, 0.05);
            }
            if (Methodes.isWorld(w.field_70170_p, new ResourceLocation("boss_tools", "mars"))) {
                MixinItemGravity.itemGravityMath(w, 0.06);
            }
            if (Methodes.isWorld(w.field_70170_p, new ResourceLocation("boss_tools", "mercury"))) {
                MixinItemGravity.itemGravityMath(w, 0.05);
            }
            if (Methodes.isWorld(w.field_70170_p, new ResourceLocation("boss_tools", "venus"))) {
                MixinItemGravity.itemGravityMath(w, 0.06);
            }
            if (Methodes.isOrbitWorld(w.field_70170_p)) {
                MixinItemGravity.itemGravityMath(w, 0.05);
            }
        }
    }

    private static boolean GravityCheckItem(ItemEntity entity) {
        return !entity.func_70090_H() && !entity.func_180799_ab() && !entity.func_189652_ae();
    }

    private static void itemGravityMath(ItemEntity entity, double gravity) {
        if (MinecraftForge.EVENT_BUS.post((Event)new ItemGravityEvent(entity))) {
            return;
        }
        entity.func_213293_j(entity.func_213322_ci().func_82615_a(), entity.func_213322_ci().func_82617_b() / 0.98 + 0.08 - gravity, entity.func_213322_ci().func_82616_c());
    }
}

